/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.multithread;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.S3ObjectsChunk;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.ServiceException;
import org.jets3t.service.StorageObjectsChunk;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.io.BytesProgressWatcher;
import org.jets3t.service.io.InterruptableInputStream;
import org.jets3t.service.io.ProgressMonitoredInputStream;
import org.jets3t.service.io.TempFile;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.S3Version;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.multithread.CancelEventTrigger;
import org.jets3t.service.multithread.CopyObjectsEvent;
import org.jets3t.service.multithread.CreateBucketsEvent;
import org.jets3t.service.multithread.CreateObjectsEvent;
import org.jets3t.service.multithread.DeleteObjectsEvent;
import org.jets3t.service.multithread.DeleteVersionedObjectsEvent;
import org.jets3t.service.multithread.DownloadObjectsEvent;
import org.jets3t.service.multithread.DownloadPackage;
import org.jets3t.service.multithread.GetObjectHeadsEvent;
import org.jets3t.service.multithread.GetObjectsEvent;
import org.jets3t.service.multithread.ListObjectsEvent;
import org.jets3t.service.multithread.LookupACLEvent;
import org.jets3t.service.multithread.S3ServiceEventListener;
import org.jets3t.service.multithread.ServiceEvent;
import org.jets3t.service.multithread.ThreadWatcher;
import org.jets3t.service.multithread.UpdateACLEvent;
import org.jets3t.service.security.ProviderCredentials;
import org.jets3t.service.utils.ServiceUtils;
import org.jets3t.service.utils.signedurl.SignedUrlAndObject;
import org.jets3t.service.utils.signedurl.SignedUrlHandler;

@Deprecated
public class S3ServiceMulti {
    private static final Log log = LogFactory.getLog(S3ServiceMulti.class);
    private S3Service s3Service = null;
    private final boolean[] isShutdown = new boolean[]{false};
    private final ArrayList<S3ServiceEventListener> serviceEventListeners = new ArrayList();
    private final long sleepTime;

    public S3ServiceMulti(S3Service s3Service, S3ServiceEventListener listener) {
        this(s3Service, listener, 500L);
    }

    public S3ServiceMulti(S3Service s3Service, S3ServiceEventListener listener, long threadSleepTimeMS) {
        this.s3Service = s3Service;
        this.addServiceEventListener(listener);
        this.sleepTime = threadSleepTimeMS;
        int adminMaxThreadCount = this.s3Service.getJetS3tProperties().getIntProperty("s3service.admin-max-thread-count", 20);
        int maxThreadCount = this.s3Service.getJetS3tProperties().getIntProperty("s3service.max-thread-count", 2);
        int maxConnectionCount = this.s3Service.getJetS3tProperties().getIntProperty("httpclient.max-connections", 20);
        if (maxConnectionCount < maxThreadCount && log.isWarnEnabled()) {
            log.warn((Object)("Insufficient connections available (httpclient.max-connections=" + maxConnectionCount + ") to run " + maxThreadCount + " simultaneous threads (s3service.max-thread-count) - please adjust JetS3t settings"));
        }
        if (maxConnectionCount < adminMaxThreadCount && log.isWarnEnabled()) {
            log.warn((Object)("Insufficient connections available (httpclient.max-connections=" + maxConnectionCount + ") to run " + adminMaxThreadCount + " simultaneous admin threads (s3service.admin-max-thread-count) - please adjust JetS3t settings"));
        }
    }

    public void shutdown() throws S3ServiceException {
        this.isShutdown[0] = true;
        try {
            this.getS3Service().shutdown();
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public boolean isShutdown() {
        return this.isShutdown[0];
    }

    public S3Service getS3Service() {
        return this.s3Service;
    }

    public void addServiceEventListener(S3ServiceEventListener listener) {
        if (listener != null) {
            this.serviceEventListeners.add(listener);
        }
    }

    public void removeServiceEventListener(S3ServiceEventListener listener) {
        if (listener != null) {
            this.serviceEventListeners.remove(listener);
        }
    }

    protected void fireServiceEvent(ServiceEvent event) {
        if (this.serviceEventListeners.size() == 0 && log.isWarnEnabled()) {
            log.warn((Object)"S3ServiceMulti invoked without any S3ServiceEventListener objects, this is dangerous!");
        }
        for (S3ServiceEventListener listener : this.serviceEventListeners) {
            if (event instanceof CreateObjectsEvent) {
                listener.s3ServiceEventPerformed((CreateObjectsEvent)event);
                continue;
            }
            if (event instanceof CopyObjectsEvent) {
                listener.s3ServiceEventPerformed((CopyObjectsEvent)event);
                continue;
            }
            if (event instanceof CreateBucketsEvent) {
                listener.s3ServiceEventPerformed((CreateBucketsEvent)event);
                continue;
            }
            if (event instanceof ListObjectsEvent) {
                listener.s3ServiceEventPerformed((ListObjectsEvent)event);
                continue;
            }
            if (event instanceof DeleteObjectsEvent) {
                listener.s3ServiceEventPerformed((DeleteObjectsEvent)event);
                continue;
            }
            if (event instanceof DeleteVersionedObjectsEvent) {
                listener.s3ServiceEventPerformed((DeleteVersionedObjectsEvent)event);
                continue;
            }
            if (event instanceof GetObjectsEvent) {
                listener.s3ServiceEventPerformed((GetObjectsEvent)event);
                continue;
            }
            if (event instanceof GetObjectHeadsEvent) {
                listener.s3ServiceEventPerformed((GetObjectHeadsEvent)event);
                continue;
            }
            if (event instanceof LookupACLEvent) {
                listener.s3ServiceEventPerformed((LookupACLEvent)event);
                continue;
            }
            if (event instanceof UpdateACLEvent) {
                listener.s3ServiceEventPerformed((UpdateACLEvent)event);
                continue;
            }
            if (event instanceof DownloadObjectsEvent) {
                listener.s3ServiceEventPerformed((DownloadObjectsEvent)event);
                continue;
            }
            throw new IllegalArgumentException("Listener not invoked for event class: " + event.getClass());
        }
    }

    public boolean isAuthenticatedConnection() {
        return this.s3Service.isAuthenticatedConnection();
    }

    public ProviderCredentials getAWSCredentials() {
        return this.s3Service.getProviderCredentials();
    }

    public boolean listObjects(String bucketName, String[] prefixes, String delimiter, long maxListingLength) {
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{true};
        AbstractRunnable[] runnables = new ListObjectsRunnable[prefixes.length];
        for (int i = 0; i < runnables.length; ++i) {
            runnables[i] = new ListObjectsRunnable(bucketName, prefixes[i], delimiter, maxListingLength, null);
        }
        new ThreadGroupManager(runnables, new ThreadWatcher(runnables.length), this.s3Service.getJetS3tProperties(), true){

            @Override
            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(ListObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            @Override
            public void fireProgressEvent(ThreadWatcher threadWatcher, List chunkList) {
                S3ServiceMulti.this.fireServiceEvent(ListObjectsEvent.newInProgressEvent(threadWatcher, chunkList, uniqueOperationId));
            }

            @Override
            public void fireCancelEvent() {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(ListObjectsEvent.newCancelledEvent(uniqueOperationId));
            }

            @Override
            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(ListObjectsEvent.newCompletedEvent(uniqueOperationId));
            }

            @Override
            public void fireErrorEvent(Throwable throwable) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(ListObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            @Override
            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(ListObjectsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean createBuckets(S3Bucket[] buckets) {
        final ArrayList<S3Bucket> incompletedBucketList = new ArrayList<S3Bucket>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{true};
        AbstractRunnable[] runnables = new CreateBucketRunnable[buckets.length];
        for (int i = 0; i < runnables.length; ++i) {
            incompletedBucketList.add(buckets[i]);
            runnables[i] = new CreateBucketRunnable(buckets[i]);
        }
        new ThreadGroupManager(runnables, new ThreadWatcher(runnables.length), this.s3Service.getJetS3tProperties(), true){

            @Override
            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(CreateBucketsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            @Override
            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                incompletedBucketList.removeAll(completedResults);
                S3Bucket[] completedBuckets = completedResults.toArray(new S3Bucket[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(CreateBucketsEvent.newInProgressEvent(threadWatcher, completedBuckets, uniqueOperationId));
            }

            @Override
            public void fireCancelEvent() {
                S3Bucket[] incompletedBuckets = incompletedBucketList.toArray(new S3Bucket[incompletedBucketList.size()]);
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(CreateBucketsEvent.newCancelledEvent(incompletedBuckets, uniqueOperationId));
            }

            @Override
            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(CreateBucketsEvent.newCompletedEvent(uniqueOperationId));
            }

            @Override
            public void fireErrorEvent(Throwable throwable) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(CreateBucketsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            @Override
            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(CreateBucketsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean copyObjects(String sourceBucketName, String destinationBucketName, final String[] sourceObjectKeys, final S3Object[] destinationObjects, boolean replaceMetadata) {
        final ArrayList<S3Object> incompletedObjectsList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{true};
        AbstractRunnable[] runnables = new CopyObjectRunnable[sourceObjectKeys.length];
        for (int i = 0; i < runnables.length; ++i) {
            incompletedObjectsList.add(destinationObjects[i]);
            runnables[i] = new CopyObjectRunnable(sourceBucketName, destinationBucketName, sourceObjectKeys[i], destinationObjects[i], replaceMetadata);
        }
        new ThreadGroupManager(runnables, new ThreadWatcher(runnables.length), this.s3Service.getJetS3tProperties(), true){

            @Override
            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(CopyObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            @Override
            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                incompletedObjectsList.removeAll(completedResults);
                Map[] copyResults = completedResults.toArray(new Map[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(CopyObjectsEvent.newInProgressEvent(threadWatcher, copyResults, uniqueOperationId));
            }

            @Override
            public void fireCancelEvent() {
                S3Object[] incompletedObjects = incompletedObjectsList.toArray(new S3Object[incompletedObjectsList.size()]);
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(CopyObjectsEvent.newCancelledEvent(incompletedObjects, uniqueOperationId));
            }

            @Override
            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(CopyObjectsEvent.newCompletedEvent(uniqueOperationId, sourceObjectKeys, destinationObjects));
            }

            @Override
            public void fireErrorEvent(Throwable throwable) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(CopyObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            @Override
            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(CopyObjectsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean putObjects(S3Bucket bucket, S3Object[] objects) {
        final ArrayList<S3Object> incompletedObjectsList = new ArrayList<S3Object>();
        ArrayList<BytesProgressWatcher> progressWatchers = new ArrayList<BytesProgressWatcher>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{true};
        AbstractRunnable[] runnables = new CreateObjectRunnable[objects.length];
        for (int i = 0; i < runnables.length; ++i) {
            incompletedObjectsList.add(objects[i]);
            BytesProgressWatcher progressMonitor = new BytesProgressWatcher(objects[i].getContentLength());
            runnables[i] = new CreateObjectRunnable(bucket, objects[i], progressMonitor);
            progressWatchers.add(progressMonitor);
        }
        ThreadWatcher threadWatcher = new ThreadWatcher(progressWatchers.toArray(new BytesProgressWatcher[progressWatchers.size()]));
        new ThreadGroupManager(runnables, threadWatcher, this.s3Service.getJetS3tProperties(), false){

            @Override
            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            @Override
            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                incompletedObjectsList.removeAll(completedResults);
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            @Override
            public void fireCancelEvent() {
                S3Object[] incompletedObjects = incompletedObjectsList.toArray(new S3Object[incompletedObjectsList.size()]);
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newCancelledEvent(incompletedObjects, uniqueOperationId));
            }

            @Override
            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newCompletedEvent(uniqueOperationId));
            }

            @Override
            public void fireErrorEvent(Throwable throwable) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            @Override
            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean deleteObjects(S3Bucket bucket, String[] objectKeys) {
        S3Object[] objects = new S3Object[objectKeys.length];
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = new S3Object(objectKeys[i]);
        }
        return this.deleteObjects(bucket, objects);
    }

    public boolean deleteObjects(S3Bucket bucket, S3Object[] objects) {
        final ArrayList<S3Object> objectsToDeleteList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{true};
        AbstractRunnable[] runnables = new DeleteObjectRunnable[objects.length];
        for (int i = 0; i < runnables.length; ++i) {
            objectsToDeleteList.add(objects[i]);
            runnables[i] = new DeleteObjectRunnable(bucket, objects[i]);
        }
        new ThreadGroupManager(runnables, new ThreadWatcher(runnables.length), this.s3Service.getJetS3tProperties(), true){

            @Override
            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            @Override
            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                objectsToDeleteList.removeAll(completedResults);
                S3Object[] deletedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newInProgressEvent(threadWatcher, deletedObjects, uniqueOperationId));
            }

            @Override
            public void fireCancelEvent() {
                S3Object[] remainingObjects = objectsToDeleteList.toArray(new S3Object[objectsToDeleteList.size()]);
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newCancelledEvent(remainingObjects, uniqueOperationId));
            }

            @Override
            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newCompletedEvent(uniqueOperationId));
            }

            @Override
            public void fireErrorEvent(Throwable throwable) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            @Override
            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean deleteVersionsOfObjectWithMFA(String[] versionIds, String multiFactorSerialNumber, String multiFactorAuthCode, String bucketName, String objectKey) {
        final ArrayList<S3Version> versionsToDeleteList = new ArrayList<S3Version>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{true};
        AbstractRunnable[] runnables = new DeleteVersionedObjectRunnable[versionIds.length];
        for (int i = 0; i < runnables.length; ++i) {
            versionsToDeleteList.add(new S3Version(objectKey, versionIds[i]));
            runnables[i] = new DeleteVersionedObjectRunnable(versionIds[i], multiFactorSerialNumber, multiFactorAuthCode, bucketName, objectKey);
        }
        new ThreadGroupManager(runnables, new ThreadWatcher(runnables.length), this.s3Service.getJetS3tProperties(), true){

            @Override
            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(DeleteVersionedObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            @Override
            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                versionsToDeleteList.removeAll(completedResults);
                S3Version[] deletedVersions = completedResults.toArray(new S3Version[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(DeleteVersionedObjectsEvent.newInProgressEvent(threadWatcher, deletedVersions, uniqueOperationId));
            }

            @Override
            public void fireCancelEvent() {
                S3Version[] remainingVersions = versionsToDeleteList.toArray(new S3Version[versionsToDeleteList.size()]);
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(DeleteVersionedObjectsEvent.newCancelledEvent(remainingVersions, uniqueOperationId));
            }

            @Override
            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(DeleteVersionedObjectsEvent.newCompletedEvent(uniqueOperationId));
            }

            @Override
            public void fireErrorEvent(Throwable throwable) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(DeleteVersionedObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            @Override
            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(DeleteVersionedObjectsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean deleteVersionsOfObject(String[] versionIds, String bucketName, String objectKey) {
        return this.deleteVersionsOfObjectWithMFA(versionIds, null, null, bucketName, objectKey);
    }

    public boolean getObjects(S3Bucket bucket, S3Object[] objects) {
        String[] objectKeys = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            objectKeys[i] = objects[i].getKey();
        }
        return this.getObjects(bucket, objectKeys);
    }

    public boolean getObjects(S3Bucket bucket, String[] objectKeys) {
        final ArrayList<String> pendingObjectKeysList = new ArrayList<String>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{true};
        AbstractRunnable[] runnables = new GetObjectRunnable[objectKeys.length];
        for (int i = 0; i < runnables.length; ++i) {
            pendingObjectKeysList.add(objectKeys[i]);
            runnables[i] = new GetObjectRunnable(bucket, objectKeys[i], false);
        }
        new ThreadGroupManager(runnables, new ThreadWatcher(runnables.length), this.s3Service.getJetS3tProperties(), false){

            @Override
            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            @Override
            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                for (int i = 0; i < completedObjects.length; ++i) {
                    pendingObjectKeysList.remove(completedObjects[i].getKey());
                }
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            @Override
            public void fireCancelEvent() {
                ArrayList<S3Object> cancelledObjectsList = new ArrayList<S3Object>();
                for (String key : pendingObjectKeysList) {
                    cancelledObjectsList.add(new S3Object(key));
                }
                S3Object[] cancelledObjects = cancelledObjectsList.toArray(new S3Object[cancelledObjectsList.size()]);
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newCancelledEvent(cancelledObjects, uniqueOperationId));
            }

            @Override
            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newCompletedEvent(uniqueOperationId));
            }

            @Override
            public void fireErrorEvent(Throwable throwable) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            @Override
            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean getObjectsHeads(S3Bucket bucket, S3Object[] objects) {
        String[] objectKeys = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            objectKeys[i] = objects[i].getKey();
        }
        return this.getObjectsHeads(bucket, objectKeys);
    }

    public boolean getObjectsHeads(S3Bucket bucket, String[] objectKeys) {
        final ArrayList<String> pendingObjectKeysList = new ArrayList<String>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{true};
        AbstractRunnable[] runnables = new GetObjectRunnable[objectKeys.length];
        for (int i = 0; i < runnables.length; ++i) {
            pendingObjectKeysList.add(objectKeys[i]);
            runnables[i] = new GetObjectRunnable(bucket, objectKeys[i], true);
        }
        new ThreadGroupManager(runnables, new ThreadWatcher(runnables.length), this.s3Service.getJetS3tProperties(), true){

            @Override
            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            @Override
            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                for (int i = 0; i < completedObjects.length; ++i) {
                    pendingObjectKeysList.remove(completedObjects[i].getKey());
                }
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            @Override
            public void fireCancelEvent() {
                ArrayList<S3Object> cancelledObjectsList = new ArrayList<S3Object>();
                for (String key : pendingObjectKeysList) {
                    cancelledObjectsList.add(new S3Object(key));
                }
                S3Object[] cancelledObjects = cancelledObjectsList.toArray(new S3Object[cancelledObjectsList.size()]);
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newCancelledEvent(cancelledObjects, uniqueOperationId));
            }

            @Override
            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newCompletedEvent(uniqueOperationId));
            }

            @Override
            public void fireErrorEvent(Throwable throwable) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            @Override
            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean getObjectACLs(S3Bucket bucket, S3Object[] objects) {
        final ArrayList<S3Object> pendingObjectsList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{true};
        AbstractRunnable[] runnables = new GetACLRunnable[objects.length];
        for (int i = 0; i < runnables.length; ++i) {
            pendingObjectsList.add(objects[i]);
            runnables[i] = new GetACLRunnable(bucket, objects[i]);
        }
        new ThreadGroupManager(runnables, new ThreadWatcher(runnables.length), this.s3Service.getJetS3tProperties(), true){

            @Override
            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            @Override
            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                pendingObjectsList.removeAll(completedResults);
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            @Override
            public void fireCancelEvent() {
                S3Object[] cancelledObjects = pendingObjectsList.toArray(new S3Object[pendingObjectsList.size()]);
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newCancelledEvent(cancelledObjects, uniqueOperationId));
            }

            @Override
            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newCompletedEvent(uniqueOperationId));
            }

            @Override
            public void fireErrorEvent(Throwable throwable) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            @Override
            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean putACLs(S3Bucket bucket, S3Object[] objects) {
        final ArrayList<S3Object> pendingObjectsList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{true};
        AbstractRunnable[] runnables = new PutACLRunnable[objects.length];
        for (int i = 0; i < runnables.length; ++i) {
            pendingObjectsList.add(objects[i]);
            runnables[i] = new PutACLRunnable(bucket, objects[i]);
        }
        new ThreadGroupManager(runnables, new ThreadWatcher(runnables.length), this.s3Service.getJetS3tProperties(), true){

            @Override
            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            @Override
            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                pendingObjectsList.removeAll(completedResults);
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            @Override
            public void fireCancelEvent() {
                S3Object[] cancelledObjects = pendingObjectsList.toArray(new S3Object[pendingObjectsList.size()]);
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newCancelledEvent(cancelledObjects, uniqueOperationId));
            }

            @Override
            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newCompletedEvent(uniqueOperationId));
            }

            @Override
            public void fireErrorEvent(Throwable throwable) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            @Override
            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean downloadObjects(S3Bucket bucket, DownloadPackage[] downloadPackages) throws S3ServiceException {
        ArrayList<BytesProgressWatcher> progressWatchers = new ArrayList<BytesProgressWatcher>();
        final ArrayList<S3Object> incompleteObjectDownloadList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{true};
        boolean restoreLastModifiedDate = this.s3Service.getJetS3tProperties().getBoolProperty("downloads.restoreLastModifiedDate", false);
        AbstractRunnable[] runnables = new DownloadObjectRunnable[downloadPackages.length];
        S3Object[] objects = new S3Object[downloadPackages.length];
        for (int i = 0; i < runnables.length; ++i) {
            if (downloadPackages[i].getObject() == null) {
                try {
                    URL url = new URL(downloadPackages[i].getSignedUrl());
                    objects[i] = ServiceUtils.buildObjectFromUrl(url.getHost(), url.getPath(), this.s3Service.getEndpoint());
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new S3ServiceException("Unable to determine S3 Object key name from signed URL: " + downloadPackages[i].getSignedUrl());
                }
            } else {
                objects[i] = downloadPackages[i].getObject();
            }
            BytesProgressWatcher progressMonitor = new BytesProgressWatcher(objects[i].getContentLength());
            incompleteObjectDownloadList.add(objects[i]);
            progressWatchers.add(progressMonitor);
            runnables[i] = downloadPackages[i].isSignedDownload() ? new DownloadObjectRunnable(downloadPackages[i], progressMonitor, restoreLastModifiedDate) : new DownloadObjectRunnable(bucket, objects[i].getKey(), downloadPackages[i], progressMonitor, restoreLastModifiedDate);
        }
        ThreadWatcher threadWatcher = new ThreadWatcher(progressWatchers.toArray(new BytesProgressWatcher[progressWatchers.size()]));
        new ThreadGroupManager(runnables, threadWatcher, this.s3Service.getJetS3tProperties(), false){

            @Override
            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(DownloadObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            @Override
            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                incompleteObjectDownloadList.removeAll(completedResults);
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(DownloadObjectsEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            @Override
            public void fireCancelEvent() {
                S3Object[] incompleteObjects = incompleteObjectDownloadList.toArray(new S3Object[incompleteObjectDownloadList.size()]);
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(DownloadObjectsEvent.newCancelledEvent(incompleteObjects, uniqueOperationId));
            }

            @Override
            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(DownloadObjectsEvent.newCompletedEvent(uniqueOperationId));
            }

            @Override
            public void fireErrorEvent(Throwable throwable) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(DownloadObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            @Override
            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(DownloadObjectsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean downloadObjects(DownloadPackage[] downloadPackages) throws S3ServiceException {
        for (int i = 0; i < downloadPackages.length; ++i) {
            if (downloadPackages[i].isSignedDownload()) continue;
            throw new S3ServiceException("The downloadObjects(DownloadPackage[]) method may only be used with download packages based on signed URLs. Download package " + (i + 1) + " of " + downloadPackages.length + " is not based on a signed URL");
        }
        return this.downloadObjects(null, downloadPackages);
    }

    public boolean getObjects(String[] signedGetURLs) throws MalformedURLException, UnsupportedEncodingException {
        if (!(this.s3Service instanceof SignedUrlHandler)) {
            throw new IllegalStateException("S3ServiceMutli's underlying S3Service must implement theSignedUrlHandler interface to make the method getObjects(String[] signedGetURLs) available");
        }
        final ArrayList<S3Object> pendingObjectKeysList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{true};
        AbstractRunnable[] runnables = new GetObjectRunnable[signedGetURLs.length];
        for (int i = 0; i < runnables.length; ++i) {
            URL url = new URL(signedGetURLs[i]);
            S3Object object = ServiceUtils.buildObjectFromUrl(url.getHost(), url.getPath(), this.s3Service.getEndpoint());
            pendingObjectKeysList.add(object);
            runnables[i] = new GetObjectRunnable(signedGetURLs[i], false);
        }
        new ThreadGroupManager(runnables, new ThreadWatcher(runnables.length), this.s3Service.getJetS3tProperties(), false){

            @Override
            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            @Override
            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                for (int i = 0; i < completedObjects.length; ++i) {
                    pendingObjectKeysList.remove(completedObjects[i].getKey());
                }
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            @Override
            public void fireCancelEvent() {
                ArrayList<S3Object> cancelledObjectsList = new ArrayList<S3Object>();
                for (String key : pendingObjectKeysList) {
                    cancelledObjectsList.add(new S3Object(key));
                }
                S3Object[] cancelledObjects = cancelledObjectsList.toArray(new S3Object[cancelledObjectsList.size()]);
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newCancelledEvent(cancelledObjects, uniqueOperationId));
            }

            @Override
            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newCompletedEvent(uniqueOperationId));
            }

            @Override
            public void fireErrorEvent(Throwable throwable) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            @Override
            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(GetObjectsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean getObjectsHeads(String[] signedHeadURLs) throws MalformedURLException, UnsupportedEncodingException {
        if (!(this.s3Service instanceof SignedUrlHandler)) {
            throw new IllegalStateException("S3ServiceMutli's underlying S3Service must implement theSignedUrlHandler interface to make the method getObjectsHeads(String[] signedHeadURLs) available");
        }
        final ArrayList<S3Object> pendingObjectKeysList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{true};
        AbstractRunnable[] runnables = new GetObjectRunnable[signedHeadURLs.length];
        for (int i = 0; i < runnables.length; ++i) {
            URL url = new URL(signedHeadURLs[i]);
            S3Object object = ServiceUtils.buildObjectFromUrl(url.getHost(), url.getPath(), this.s3Service.getEndpoint());
            pendingObjectKeysList.add(object);
            runnables[i] = new GetObjectRunnable(signedHeadURLs[i], true);
        }
        new ThreadGroupManager(runnables, new ThreadWatcher(runnables.length), this.s3Service.getJetS3tProperties(), true){

            @Override
            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            @Override
            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                for (int i = 0; i < completedObjects.length; ++i) {
                    pendingObjectKeysList.remove(completedObjects[i].getKey());
                }
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            @Override
            public void fireCancelEvent() {
                ArrayList<S3Object> cancelledObjectsList = new ArrayList<S3Object>();
                for (String key : pendingObjectKeysList) {
                    cancelledObjectsList.add(new S3Object(key));
                }
                S3Object[] cancelledObjects = cancelledObjectsList.toArray(new S3Object[cancelledObjectsList.size()]);
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newCancelledEvent(cancelledObjects, uniqueOperationId));
            }

            @Override
            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newCompletedEvent(uniqueOperationId));
            }

            @Override
            public void fireErrorEvent(Throwable throwable) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            @Override
            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(GetObjectHeadsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean putObjectsACLs(String[] signedURLs, AccessControlList acl) throws MalformedURLException, UnsupportedEncodingException {
        final ArrayList<S3Object> pendingObjectsList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{true};
        AbstractRunnable[] runnables = new PutACLRunnable[signedURLs.length];
        for (int i = 0; i < runnables.length; ++i) {
            URL url = new URL(signedURLs[i]);
            S3Object object = ServiceUtils.buildObjectFromUrl(url.getHost(), url.getPath(), this.s3Service.getEndpoint());
            pendingObjectsList.add(object);
            runnables[i] = new PutACLRunnable(signedURLs[i], acl);
        }
        new ThreadGroupManager(runnables, new ThreadWatcher(runnables.length), this.s3Service.getJetS3tProperties(), true){

            @Override
            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            @Override
            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                pendingObjectsList.removeAll(completedResults);
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            @Override
            public void fireCancelEvent() {
                S3Object[] cancelledObjects = pendingObjectsList.toArray(new S3Object[pendingObjectsList.size()]);
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newCancelledEvent(cancelledObjects, uniqueOperationId));
            }

            @Override
            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newCompletedEvent(uniqueOperationId));
            }

            @Override
            public void fireErrorEvent(Throwable throwable) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            @Override
            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(UpdateACLEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean deleteObjects(String[] signedDeleteUrls) throws MalformedURLException, UnsupportedEncodingException {
        if (!(this.s3Service instanceof SignedUrlHandler)) {
            throw new IllegalStateException("S3ServiceMutli's underlying S3Service must implement theSignedUrlHandler interface to make the method deleteObjects(String[] signedDeleteURLs) available");
        }
        final ArrayList<S3Object> objectsToDeleteList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{true};
        AbstractRunnable[] runnables = new DeleteObjectRunnable[signedDeleteUrls.length];
        for (int i = 0; i < runnables.length; ++i) {
            URL url = new URL(signedDeleteUrls[i]);
            S3Object object = ServiceUtils.buildObjectFromUrl(url.getHost(), url.getPath(), this.s3Service.getEndpoint());
            objectsToDeleteList.add(object);
            runnables[i] = new DeleteObjectRunnable(signedDeleteUrls[i]);
        }
        new ThreadGroupManager(runnables, new ThreadWatcher(runnables.length), this.s3Service.getJetS3tProperties(), true){

            @Override
            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            @Override
            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                objectsToDeleteList.removeAll(completedResults);
                S3Object[] deletedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newInProgressEvent(threadWatcher, deletedObjects, uniqueOperationId));
            }

            @Override
            public void fireCancelEvent() {
                S3Object[] remainingObjects = objectsToDeleteList.toArray(new S3Object[objectsToDeleteList.size()]);
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newCancelledEvent(remainingObjects, uniqueOperationId));
            }

            @Override
            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newCompletedEvent(uniqueOperationId));
            }

            @Override
            public void fireErrorEvent(Throwable throwable) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            @Override
            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(DeleteObjectsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean putObjects(SignedUrlAndObject[] signedPutUrlAndObjects) {
        if (!(this.s3Service instanceof SignedUrlHandler)) {
            throw new IllegalStateException("S3ServiceMutli's underlying S3Service must implement theSignedUrlHandler interface to make the method putObjects(SignedUrlAndObject[] signedPutUrlAndObjects) available");
        }
        ArrayList<BytesProgressWatcher> progressWatchers = new ArrayList<BytesProgressWatcher>();
        final ArrayList<S3Object> incompletedObjectsList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{true};
        S3Object[] objects = new S3Object[signedPutUrlAndObjects.length];
        for (int i = 0; i < signedPutUrlAndObjects.length; ++i) {
            objects[i] = signedPutUrlAndObjects[i].getObject();
        }
        AbstractRunnable[] runnables = new SignedPutRunnable[signedPutUrlAndObjects.length];
        for (int i = 0; i < runnables.length; ++i) {
            BytesProgressWatcher progressMonitor = new BytesProgressWatcher(objects[i].getContentLength());
            progressWatchers.add(progressMonitor);
            incompletedObjectsList.add(signedPutUrlAndObjects[i].getObject());
            runnables[i] = new SignedPutRunnable(signedPutUrlAndObjects[i], progressMonitor);
        }
        ThreadWatcher threadWatcher = new ThreadWatcher(progressWatchers.toArray(new BytesProgressWatcher[progressWatchers.size()]));
        new ThreadGroupManager(runnables, threadWatcher, this.s3Service.getJetS3tProperties(), false){

            @Override
            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            @Override
            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                incompletedObjectsList.removeAll(completedResults);
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            @Override
            public void fireCancelEvent() {
                S3Object[] incompletedObjects = incompletedObjectsList.toArray(new S3Object[incompletedObjectsList.size()]);
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newCancelledEvent(incompletedObjects, uniqueOperationId));
            }

            @Override
            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newCompletedEvent(uniqueOperationId));
            }

            @Override
            public void fireErrorEvent(Throwable throwable) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            @Override
            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(CreateObjectsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean getObjectsACLs(String[] signedAclURLs) throws MalformedURLException, UnsupportedEncodingException {
        if (!(this.s3Service instanceof SignedUrlHandler)) {
            throw new IllegalStateException("S3ServiceMutli's underlying S3Service must implement theSignedUrlHandler interface to make the method getObjects(String[] signedGetURLs) available");
        }
        final ArrayList<S3Object> pendingObjectKeysList = new ArrayList<S3Object>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{true};
        AbstractRunnable[] runnables = new GetACLRunnable[signedAclURLs.length];
        for (int i = 0; i < runnables.length; ++i) {
            URL url = new URL(signedAclURLs[i]);
            S3Object object = ServiceUtils.buildObjectFromUrl(url.getHost(), url.getPath(), this.s3Service.getEndpoint());
            pendingObjectKeysList.add(object);
            runnables[i] = new GetACLRunnable(signedAclURLs[i]);
        }
        new ThreadGroupManager(runnables, new ThreadWatcher(runnables.length), this.s3Service.getJetS3tProperties(), false){

            @Override
            public void fireStartEvent(ThreadWatcher threadWatcher) {
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            @Override
            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                S3Object[] completedObjects = completedResults.toArray(new S3Object[completedResults.size()]);
                for (int i = 0; i < completedObjects.length; ++i) {
                    pendingObjectKeysList.remove(completedObjects[i].getKey());
                }
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            @Override
            public void fireCancelEvent() {
                ArrayList cancelledObjectsList = new ArrayList();
                Iterator iter = pendingObjectKeysList.iterator();
                while (iter.hasNext()) {
                    cancelledObjectsList.add(iter.next());
                }
                S3Object[] cancelledObjects = cancelledObjectsList.toArray(new S3Object[cancelledObjectsList.size()]);
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newCancelledEvent(cancelledObjects, uniqueOperationId));
            }

            @Override
            public void fireCompletedEvent() {
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newCompletedEvent(uniqueOperationId));
            }

            @Override
            public void fireErrorEvent(Throwable throwable) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            @Override
            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                success[0] = false;
                S3ServiceMulti.this.fireServiceEvent(LookupACLEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    private class ListObjectsRunnable
    extends AbstractRunnable {
        private Object result;
        private String bucketName;
        private String prefix;
        private String delimiter;
        private long maxListingLength;
        private String priorLastKey;
        private boolean halted;

        public ListObjectsRunnable(String bucketName, String prefix, String delimiter, long maxListingLength, String priorLastKey) {
            this.result = null;
            this.bucketName = null;
            this.prefix = null;
            this.delimiter = null;
            this.maxListingLength = 1000L;
            this.priorLastKey = null;
            this.halted = false;
            this.bucketName = bucketName;
            this.prefix = prefix;
            this.delimiter = delimiter;
            this.maxListingLength = maxListingLength;
            this.priorLastKey = priorLastKey;
        }

        @Override
        public void run() {
            try {
                ArrayList<StorageObject> allObjects = new ArrayList<StorageObject>();
                ArrayList<String> allCommonPrefixes = new ArrayList<String>();
                do {
                    StorageObjectsChunk chunk = S3ServiceMulti.this.s3Service.listObjectsChunked(this.bucketName, this.prefix, this.delimiter, this.maxListingLength, this.priorLastKey);
                    this.priorLastKey = chunk.getPriorLastKey();
                    allObjects.addAll(Arrays.asList(chunk.getObjects()));
                    allCommonPrefixes.addAll(Arrays.asList(chunk.getCommonPrefixes()));
                } while (!this.halted && this.priorLastKey != null);
                this.result = new S3ObjectsChunk(this.prefix, this.delimiter, allObjects.toArray(new S3Object[allObjects.size()]), allCommonPrefixes.toArray(new String[allCommonPrefixes.size()]), null);
            }
            catch (ServiceException se) {
                this.result = new S3ServiceException(se);
            }
        }

        @Override
        public Object getResult() {
            return this.result;
        }

        @Override
        public void forceInterruptCalled() {
            this.halted = true;
        }
    }

    private abstract class AbstractRunnable
    implements Runnable {
        private AbstractRunnable() {
        }

        public abstract Object getResult();

        public abstract void forceInterruptCalled();

        protected void forceInterrupt() {
            this.forceInterruptCalled();
        }
    }

    private class CreateBucketRunnable
    extends AbstractRunnable {
        private S3Bucket bucket = null;
        private Object result = null;

        public CreateBucketRunnable(S3Bucket bucket) {
            this.bucket = bucket;
        }

        @Override
        public void run() {
            try {
                this.result = S3ServiceMulti.this.s3Service.createBucket(this.bucket);
            }
            catch (S3ServiceException e) {
                this.result = e;
            }
        }

        @Override
        public Object getResult() {
            return this.result;
        }

        @Override
        public void forceInterruptCalled() {
        }
    }

    private class CopyObjectRunnable
    extends AbstractRunnable {
        private String sourceBucketName = null;
        private String destinationBucketName = null;
        private String sourceObjectKey = null;
        private S3Object destinationObject = null;
        private boolean replaceMetadata = false;
        private Object result = null;

        public CopyObjectRunnable(String sourceBucketName, String destinationBucketName, String sourceObjectKey, S3Object destinationObject, boolean replaceMetadata) {
            this.sourceBucketName = sourceBucketName;
            this.destinationBucketName = destinationBucketName;
            this.sourceObjectKey = sourceObjectKey;
            this.destinationObject = destinationObject;
            this.replaceMetadata = replaceMetadata;
        }

        @Override
        public void run() {
            try {
                this.result = S3ServiceMulti.this.s3Service.copyObject(this.sourceBucketName, this.sourceObjectKey, this.destinationBucketName, this.destinationObject, this.replaceMetadata);
            }
            catch (ServiceException se) {
                this.result = new S3ServiceException(se);
            }
        }

        @Override
        public Object getResult() {
            return this.result;
        }

        @Override
        public void forceInterruptCalled() {
        }
    }

    private class CreateObjectRunnable
    extends AbstractRunnable {
        private S3Bucket bucket = null;
        private S3Object s3Object = null;
        private InterruptableInputStream interruptableInputStream = null;
        private BytesProgressWatcher progressMonitor = null;
        private Object result = null;

        public CreateObjectRunnable(S3Bucket bucket, S3Object s3Object, BytesProgressWatcher progressMonitor) {
            this.bucket = bucket;
            this.s3Object = s3Object;
            this.progressMonitor = progressMonitor;
        }

        @Override
        public void run() {
            try {
                File underlyingFile = this.s3Object.getDataInputFile();
                if (this.s3Object.getDataInputStream() != null) {
                    this.interruptableInputStream = new InterruptableInputStream(this.s3Object.getDataInputStream());
                    ProgressMonitoredInputStream pmInputStream = new ProgressMonitoredInputStream(this.interruptableInputStream, this.progressMonitor);
                    this.s3Object.setDataInputStream(pmInputStream);
                }
                this.result = S3ServiceMulti.this.s3Service.putObject(this.bucket, this.s3Object);
                if (underlyingFile instanceof TempFile) {
                    underlyingFile.delete();
                }
            }
            catch (ServiceException se) {
                this.result = new S3ServiceException(se);
            }
        }

        @Override
        public Object getResult() {
            return this.result;
        }

        @Override
        public void forceInterruptCalled() {
            if (this.interruptableInputStream != null) {
                this.interruptableInputStream.interrupt();
            }
        }
    }

    private class DeleteObjectRunnable
    extends AbstractRunnable {
        private S3Bucket bucket = null;
        private S3Object object = null;
        private String signedDeleteUrl = null;
        private Object result = null;

        public DeleteObjectRunnable(S3Bucket bucket, S3Object object) {
            this.signedDeleteUrl = null;
            this.bucket = bucket;
            this.object = object;
        }

        public DeleteObjectRunnable(String signedDeleteUrl) {
            this.signedDeleteUrl = signedDeleteUrl;
            this.bucket = null;
            this.object = null;
        }

        @Override
        public void run() {
            try {
                if (this.signedDeleteUrl == null) {
                    S3ServiceMulti.this.s3Service.deleteObject(this.bucket, this.object.getKey());
                    this.result = this.object;
                } else {
                    S3Service handler = S3ServiceMulti.this.s3Service;
                    handler.deleteObjectWithSignedUrl(this.signedDeleteUrl);
                    URL url = new URL(this.signedDeleteUrl);
                    this.result = ServiceUtils.buildObjectFromUrl(url.getHost(), url.getPath(), S3ServiceMulti.this.s3Service.getEndpoint());
                }
            }
            catch (RuntimeException e) {
                this.result = e;
                throw e;
            }
            catch (Exception e) {
                this.result = e;
            }
        }

        @Override
        public Object getResult() {
            return this.result;
        }

        @Override
        public void forceInterruptCalled() {
        }
    }

    private class DeleteVersionedObjectRunnable
    extends AbstractRunnable {
        private String versionId = null;
        private String multiFactorSerialNumber = null;
        private String multiFactorAuthCode = null;
        private String bucketName = null;
        private String objectKey = null;
        private Object result = null;

        public DeleteVersionedObjectRunnable(String versionId, String multiFactorSerialNumber, String multiFactorAuthCode, String bucketName, String objectKey) {
            this.versionId = versionId;
            this.multiFactorSerialNumber = multiFactorSerialNumber;
            this.multiFactorAuthCode = multiFactorAuthCode;
            this.bucketName = bucketName;
            this.objectKey = objectKey;
        }

        @Override
        public void run() {
            try {
                S3ServiceMulti.this.s3Service.deleteVersionedObjectWithMFA(this.versionId, this.multiFactorSerialNumber, this.multiFactorAuthCode, this.bucketName, this.objectKey);
                this.result = new S3Version(this.objectKey, this.versionId);
            }
            catch (RuntimeException e) {
                this.result = e;
                throw e;
            }
            catch (Exception e) {
                this.result = e;
            }
        }

        @Override
        public Object getResult() {
            return this.result;
        }

        @Override
        public void forceInterruptCalled() {
        }
    }

    private class GetObjectRunnable
    extends AbstractRunnable {
        private S3Bucket bucket = null;
        private String objectKey = null;
        private String signedGetOrHeadUrl = null;
        private boolean headOnly = false;
        private Object result = null;

        public GetObjectRunnable(S3Bucket bucket, String objectKey, boolean headOnly) {
            this.signedGetOrHeadUrl = null;
            this.bucket = bucket;
            this.objectKey = objectKey;
            this.headOnly = headOnly;
        }

        public GetObjectRunnable(String signedGetOrHeadUrl, boolean headOnly) {
            this.signedGetOrHeadUrl = signedGetOrHeadUrl;
            this.bucket = null;
            this.objectKey = null;
            this.headOnly = headOnly;
        }

        @Override
        public void run() {
            try {
                if (this.headOnly) {
                    if (this.signedGetOrHeadUrl == null) {
                        this.result = S3ServiceMulti.this.s3Service.getObjectDetails(this.bucket, this.objectKey);
                    } else {
                        S3Service handler = S3ServiceMulti.this.s3Service;
                        this.result = handler.getObjectDetailsWithSignedUrl(this.signedGetOrHeadUrl);
                    }
                } else if (this.signedGetOrHeadUrl == null) {
                    this.result = S3ServiceMulti.this.s3Service.getObject(this.bucket, this.objectKey);
                } else {
                    S3Service handler = S3ServiceMulti.this.s3Service;
                    this.result = handler.getObjectWithSignedUrl(this.signedGetOrHeadUrl);
                }
            }
            catch (ServiceException se) {
                this.result = new S3ServiceException(se);
            }
        }

        @Override
        public Object getResult() {
            return this.result;
        }

        @Override
        public void forceInterruptCalled() {
        }
    }

    private class GetACLRunnable
    extends AbstractRunnable {
        private S3Bucket bucket = null;
        private S3Object object = null;
        private String signedAclUrl = null;
        private Object result = null;

        public GetACLRunnable(S3Bucket bucket, S3Object object) {
            this.bucket = bucket;
            this.object = object;
        }

        public GetACLRunnable(String signedAclUrl) {
            this.signedAclUrl = signedAclUrl;
            this.bucket = null;
            this.object = null;
        }

        @Override
        public void run() {
            try {
                if (this.signedAclUrl == null) {
                    AccessControlList acl = S3ServiceMulti.this.s3Service.getObjectAcl(this.bucket, this.object.getKey());
                    this.object.setAcl(acl);
                    this.result = this.object;
                } else {
                    S3Service handler = S3ServiceMulti.this.s3Service;
                    AccessControlList acl = handler.getObjectAclWithSignedUrl(this.signedAclUrl);
                    URL url = new URL(this.signedAclUrl);
                    this.object = ServiceUtils.buildObjectFromUrl(url.getHost(), url.getPath(), S3ServiceMulti.this.s3Service.getEndpoint());
                    this.object.setAcl(acl);
                    this.result = this.object;
                }
            }
            catch (RuntimeException e) {
                this.result = e;
                throw e;
            }
            catch (Exception e) {
                this.result = e;
            }
        }

        @Override
        public Object getResult() {
            return this.result;
        }

        @Override
        public void forceInterruptCalled() {
        }
    }

    private class PutACLRunnable
    extends AbstractRunnable {
        private S3Bucket bucket = null;
        private S3Object s3Object = null;
        private String signedUrl = null;
        private AccessControlList signedUrlAcl = null;
        private Object result = null;

        public PutACLRunnable(S3Bucket bucket, S3Object s3Object) {
            this.bucket = bucket;
            this.s3Object = s3Object;
        }

        public PutACLRunnable(String signedAclUrl, AccessControlList signedUrlAcl) {
            this.signedUrl = signedAclUrl;
            this.signedUrlAcl = signedUrlAcl;
            this.bucket = null;
            this.s3Object = null;
        }

        @Override
        public void run() {
            try {
                if (this.signedUrl == null) {
                    if (this.s3Object == null) {
                        S3ServiceMulti.this.s3Service.putBucketAcl(this.bucket);
                    } else {
                        S3ServiceMulti.this.s3Service.putObjectAcl(this.bucket, this.s3Object);
                    }
                    this.result = this.s3Object;
                } else {
                    S3Service handler = S3ServiceMulti.this.s3Service;
                    handler.putObjectAclWithSignedUrl(this.signedUrl, this.signedUrlAcl);
                    URL url = new URL(this.signedUrl);
                    S3Object object = ServiceUtils.buildObjectFromUrl(url.getHost(), url.getPath(), S3ServiceMulti.this.s3Service.getEndpoint());
                    object.setAcl(this.signedUrlAcl);
                    this.result = object;
                }
            }
            catch (RuntimeException e) {
                this.result = e;
                throw e;
            }
            catch (Exception e) {
                this.result = e;
            }
        }

        @Override
        public Object getResult() {
            return this.result;
        }

        @Override
        public void forceInterruptCalled() {
        }
    }

    private class DownloadObjectRunnable
    extends AbstractRunnable {
        private String objectKey = null;
        private S3Bucket bucket = null;
        private DownloadPackage downloadPackage = null;
        private InterruptableInputStream interruptableInputStream = null;
        private BytesProgressWatcher progressMonitor = null;
        private boolean restoreLastModifiedDate = true;
        private Object result = null;

        public DownloadObjectRunnable(S3Bucket bucket, String objectKey, DownloadPackage downloadPackage, BytesProgressWatcher progressMonitor, boolean restoreLastModifiedDate) {
            this.bucket = bucket;
            this.objectKey = objectKey;
            this.downloadPackage = downloadPackage;
            this.progressMonitor = progressMonitor;
            this.restoreLastModifiedDate = restoreLastModifiedDate;
        }

        public DownloadObjectRunnable(DownloadPackage downloadPackage, BytesProgressWatcher progressMonitor, boolean restoreLastModifiedDate) {
            this.downloadPackage = downloadPackage;
            this.progressMonitor = progressMonitor;
            this.restoreLastModifiedDate = restoreLastModifiedDate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BufferedInputStream bufferedInputStream = null;
            FilterOutputStream bufferedOutputStream = null;
            S3Object object = null;
            try {
                String metadataLocalFileDate;
                MessageDigest messageDigest;
                block37: {
                    if (!this.downloadPackage.isSignedDownload()) {
                        object = S3ServiceMulti.this.s3Service.getObject(this.bucket, this.objectKey);
                    } else {
                        S3Service handler = S3ServiceMulti.this.s3Service;
                        object = handler.getObjectWithSignedUrl(this.downloadPackage.getSignedUrl());
                    }
                    this.downloadPackage.setObject(object);
                    this.interruptableInputStream = new InterruptableInputStream(object.getDataInputStream());
                    bufferedInputStream = new BufferedInputStream(new ProgressMonitoredInputStream(this.interruptableInputStream, this.progressMonitor));
                    bufferedOutputStream = new BufferedOutputStream(this.downloadPackage.getOutputStream());
                    messageDigest = null;
                    try {
                        messageDigest = MessageDigest.getInstance("MD5");
                    }
                    catch (NoSuchAlgorithmException e) {
                        if (!log.isWarnEnabled()) break block37;
                        log.warn((Object)"Unable to calculate MD5 hash of data received as algorithm is not available", (Throwable)e);
                    }
                }
                try {
                    byte[] buffer = new byte[1024];
                    int byteCount = -1;
                    while ((byteCount = bufferedInputStream.read(buffer)) != -1) {
                        ((BufferedOutputStream)bufferedOutputStream).write(buffer, 0, byteCount);
                        if (messageDigest == null) continue;
                        messageDigest.update(buffer, 0, byteCount);
                    }
                    if (messageDigest != null) {
                        byte[] dataMD5Hash = messageDigest.digest();
                        String hexMD5OfDownloadedData = ServiceUtils.toHex(dataMD5Hash);
                        if (!ServiceUtils.isEtagAlsoAnMD5Hash(object.getETag())) {
                            if (!hexMD5OfDownloadedData.equals(object.getMd5HashAsHex()) && log.isWarnEnabled()) {
                                log.warn((Object)("Unable to verify MD5 hash of downloaded data against ETag returned by service because ETag value \"" + object.getETag() + "\" is not an MD5 hash value, for object key: " + object.getKey()));
                            }
                        } else {
                            if (!hexMD5OfDownloadedData.equals(object.getETag())) {
                                throw new S3ServiceException("Mismatch between MD5 hash of downloaded data (" + hexMD5OfDownloadedData + ") and ETag returned by S3 (" + object.getETag() + ") for object key: " + object.getKey());
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Object download was automatically verified, the calculated MD5 hash value matched the ETag provided by S3: " + object.getKey()));
                            }
                        }
                    }
                }
                finally {
                    if (bufferedOutputStream != null) {
                        bufferedOutputStream.close();
                    }
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                }
                object.setDataInputStream(null);
                object.setDataInputFile(this.downloadPackage.getDataFile());
                if (this.restoreLastModifiedDate && this.downloadPackage.getDataFile() != null && (metadataLocalFileDate = (String)object.getMetadata("jets3t-original-file-date-iso8601")) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Restoring original Last Modified date for object '" + object.getKey() + "' to file '" + this.downloadPackage.getDataFile() + "': " + metadataLocalFileDate));
                    }
                    this.downloadPackage.getDataFile().setLastModified(ServiceUtils.parseIso8601Date(metadataLocalFileDate).getTime());
                }
                this.result = object;
            }
            catch (Throwable t) {
                this.result = t;
            }
            finally {
                block41: {
                    block40: {
                        if (bufferedInputStream != null) {
                            try {
                                bufferedInputStream.close();
                            }
                            catch (Exception e) {
                                if (!log.isErrorEnabled()) break block40;
                                log.error((Object)"Unable to close Object input stream", (Throwable)e);
                            }
                        }
                    }
                    if (bufferedOutputStream != null) {
                        try {
                            bufferedOutputStream.close();
                        }
                        catch (Exception e) {
                            if (!log.isErrorEnabled()) break block41;
                            log.error((Object)"Unable to close download output stream", (Throwable)e);
                        }
                    }
                }
            }
        }

        @Override
        public Object getResult() {
            return this.result;
        }

        @Override
        public void forceInterruptCalled() {
            if (this.interruptableInputStream != null) {
                this.interruptableInputStream.interrupt();
            }
        }
    }

    private class SignedPutRunnable
    extends AbstractRunnable {
        private SignedUrlAndObject signedUrlAndObject = null;
        private InterruptableInputStream interruptableInputStream = null;
        private BytesProgressWatcher progressMonitor = null;
        private Object result = null;

        public SignedPutRunnable(SignedUrlAndObject signedUrlAndObject, BytesProgressWatcher progressMonitor) {
            this.signedUrlAndObject = signedUrlAndObject;
            this.progressMonitor = progressMonitor;
        }

        @Override
        public void run() {
            try {
                File underlyingFile = this.signedUrlAndObject.getObject().getDataInputFile();
                if (this.signedUrlAndObject.getObject().getDataInputStream() != null) {
                    this.interruptableInputStream = new InterruptableInputStream(this.signedUrlAndObject.getObject().getDataInputStream());
                    ProgressMonitoredInputStream pmInputStream = new ProgressMonitoredInputStream(this.interruptableInputStream, this.progressMonitor);
                    this.signedUrlAndObject.getObject().setDataInputStream(pmInputStream);
                }
                S3Service signedPutUploader = S3ServiceMulti.this.s3Service;
                this.result = signedPutUploader.putObjectWithSignedUrl(this.signedUrlAndObject.getSignedUrl(), this.signedUrlAndObject.getObject());
                if (underlyingFile instanceof TempFile) {
                    underlyingFile.delete();
                }
            }
            catch (ServiceException se) {
                this.result = new S3ServiceException(se);
            }
            finally {
                block14: {
                    try {
                        this.signedUrlAndObject.getObject().closeDataInputStream();
                    }
                    catch (IOException e) {
                        if (!log.isErrorEnabled()) break block14;
                        log.error((Object)"Unable to close Object's input stream", (Throwable)e);
                    }
                }
            }
        }

        @Override
        public Object getResult() {
            return this.result;
        }

        @Override
        public void forceInterruptCalled() {
            if (this.interruptableInputStream != null) {
                this.interruptableInputStream.interrupt();
            }
        }
    }

    private abstract class ThreadGroupManager {
        private final Log log = LogFactory.getLog(ThreadGroupManager.class);
        private int maxThreadCount = 1;
        private AbstractRunnable[] runnables = null;
        private Thread[] threads = null;
        private boolean ignoreExceptions = false;
        private boolean[] started = null;
        private boolean[] alreadyFired = null;
        private ThreadWatcher threadWatcher = null;
        private long lastProgressEventFiredTime = 0L;

        public ThreadGroupManager(AbstractRunnable[] runnables, ThreadWatcher threadWatcher, Jets3tProperties jets3tProperties, boolean isAdminTask) {
            this.runnables = runnables;
            this.threadWatcher = threadWatcher;
            this.maxThreadCount = isAdminTask ? jets3tProperties.getIntProperty("s3service.admin-max-thread-count", 20) : jets3tProperties.getIntProperty("s3service.max-thread-count", 2);
            this.ignoreExceptions = jets3tProperties.getBoolProperty("s3service.ignore-exceptions-in-multi", false);
            this.threads = new Thread[runnables.length];
            this.started = new boolean[runnables.length];
            this.alreadyFired = new boolean[runnables.length];
        }

        private ResultsTuple getNewlyCompletedResults() throws Throwable {
            ArrayList<Object> completedResults = new ArrayList<Object>();
            ArrayList<Throwable> errorResults = new ArrayList<Throwable>();
            for (int i = 0; i < this.threads.length; ++i) {
                if (this.alreadyFired[i] || !this.started[i] || this.threads[i].isAlive()) continue;
                this.alreadyFired[i] = true;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Thread " + (i + 1) + " of " + this.threads.length + " has recently completed, releasing resources"));
                }
                if (this.runnables[i].getResult() instanceof Throwable) {
                    Throwable throwable = (Throwable)this.runnables[i].getResult();
                    this.runnables[i] = null;
                    this.threads[i] = null;
                    if (this.ignoreExceptions) {
                        if (this.log.isWarnEnabled()) {
                            this.log.warn((Object)"Ignoring exception (property s3service.ignore-exceptions-in-multi is set to true)", throwable);
                        }
                        errorResults.add(throwable);
                        continue;
                    }
                    throw throwable;
                }
                completedResults.add(this.runnables[i].getResult());
                this.runnables[i] = null;
                this.threads[i] = null;
            }
            Throwable[] ignoredErrors = new Throwable[]{};
            if (errorResults.size() > 0) {
                ignoredErrors = errorResults.toArray(new Throwable[errorResults.size()]);
            }
            return new ResultsTuple(completedResults, ignoredErrors);
        }

        private void startPendingThreads() throws Throwable {
            int i;
            int runningThreadCount = 0;
            for (i = 0; i < this.runnables.length; ++i) {
                if (!this.started[i] || this.alreadyFired[i]) continue;
                ++runningThreadCount;
            }
            for (i = 0; runningThreadCount < this.maxThreadCount && i < this.started.length; ++i) {
                if (this.started[i]) continue;
                this.threads[i] = new Thread(this.runnables[i]);
                this.threads[i].start();
                this.started[i] = true;
                ++runningThreadCount;
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Thread " + (i + 1) + " of " + this.runnables.length + " has started"));
            }
        }

        private int getPendingThreadCount() {
            int pendingThreadCount = 0;
            for (int i = 0; i < this.runnables.length; ++i) {
                if (this.alreadyFired[i]) continue;
                ++pendingThreadCount;
            }
            return pendingThreadCount;
        }

        private void forceInterruptAllRunnables() {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Setting force interrupt flag on all runnables");
            }
            for (int i = 0; i < this.runnables.length; ++i) {
                if (this.runnables[i] == null) continue;
                this.runnables[i].forceInterrupt();
                this.runnables[i] = null;
            }
        }

        public void run() {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Started ThreadManager");
            }
            final boolean[] interrupted = new boolean[]{false};
            CancelEventTrigger cancelEventTrigger = new CancelEventTrigger(){
                private static final long serialVersionUID = 6328417466929608235L;

                @Override
                public void cancelTask(Object eventSource) {
                    if (ThreadGroupManager.this.log.isDebugEnabled()) {
                        ThreadGroupManager.this.log.debug((Object)"Cancel task invoked on ThreadManager");
                    }
                    interrupted[0] = true;
                    ThreadGroupManager.this.forceInterruptAllRunnables();
                }
            };
            try {
                ResultsTuple results;
                int completedThreads;
                this.startPendingThreads();
                this.threadWatcher.updateThreadsCompletedCount(0L, cancelEventTrigger);
                this.fireStartEvent(this.threadWatcher);
                while (!interrupted[0] && this.getPendingThreadCount() > 0) {
                    try {
                        if (S3ServiceMulti.this.isShutdown[0]) {
                            throw new InterruptedException("S3ServiceMulti#shutdown method invoked");
                        }
                        Thread.sleep(100L);
                        if (interrupted[0]) continue;
                        if (System.currentTimeMillis() - this.lastProgressEventFiredTime > S3ServiceMulti.this.sleepTime) {
                            completedThreads = this.runnables.length - this.getPendingThreadCount();
                            this.threadWatcher.updateThreadsCompletedCount((long)completedThreads, cancelEventTrigger);
                            results = this.getNewlyCompletedResults();
                            this.lastProgressEventFiredTime = System.currentTimeMillis();
                            this.fireProgressEvent(this.threadWatcher, results.completedResults);
                            if (results.errorResults.length > 0) {
                                this.fireIgnoredErrorsEvent(this.threadWatcher, results.errorResults);
                            }
                        }
                        this.startPendingThreads();
                    }
                    catch (InterruptedException e) {
                        interrupted[0] = true;
                        this.forceInterruptAllRunnables();
                    }
                }
                if (interrupted[0]) {
                    this.fireCancelEvent();
                } else {
                    completedThreads = this.runnables.length - this.getPendingThreadCount();
                    this.threadWatcher.updateThreadsCompletedCount((long)completedThreads, cancelEventTrigger);
                    results = this.getNewlyCompletedResults();
                    this.fireProgressEvent(this.threadWatcher, results.completedResults);
                    if (results.completedResults.size() > 0 && this.log.isDebugEnabled()) {
                        this.log.debug((Object)(results.completedResults.size() + " threads have recently completed"));
                    }
                    if (results.errorResults.length > 0) {
                        this.fireIgnoredErrorsEvent(this.threadWatcher, results.errorResults);
                    }
                    this.fireCompletedEvent();
                }
            }
            catch (Throwable t) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"A thread failed with an exception. Firing ERROR event and cancelling all threads", t);
                }
                this.forceInterruptAllRunnables();
                this.fireErrorEvent(t);
            }
        }

        public abstract void fireStartEvent(ThreadWatcher var1);

        public abstract void fireProgressEvent(ThreadWatcher var1, List var2);

        public abstract void fireCompletedEvent();

        public abstract void fireCancelEvent();

        public abstract void fireErrorEvent(Throwable var1);

        public abstract void fireIgnoredErrorsEvent(ThreadWatcher var1, Throwable[] var2);

        private class ResultsTuple {
            public List completedResults = null;
            public Throwable[] errorResults = null;

            public ResultsTuple(List completedResults, Throwable[] errorResults) {
                this.completedResults = completedResults;
                this.errorResults = errorResults;
            }
        }
    }
}

