/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.UserInfo;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="Deleted node information (Deleted node can be a folder or file)")
public class DeletedNode {
    @JsonProperty(value="id")
    private Long id = null;
    @JsonProperty(value="parentId")
    private Long parentId = null;
    @JsonProperty(value="parentPath")
    private String parentPath = null;
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="expireAt")
    private DateTime expireAt = null;
    @JsonProperty(value="accessedAt")
    private DateTime accessedAt = null;
    @JsonProperty(value="isEncrypted")
    private Boolean isEncrypted = null;
    @JsonProperty(value="notes")
    private String notes = null;
    @JsonProperty(value="size")
    private Long size = null;
    @JsonProperty(value="classification")
    private ClassificationEnum classification = null;
    @JsonProperty(value="createdAt")
    private DateTime createdAt = null;
    @JsonProperty(value="createdBy")
    private UserInfo createdBy = null;
    @JsonProperty(value="updatedAt")
    private DateTime updatedAt = null;
    @JsonProperty(value="updatedBy")
    private UserInfo updatedBy = null;
    @JsonProperty(value="deletedAt")
    private DateTime deletedAt = null;
    @JsonProperty(value="deletedBy")
    private UserInfo deletedBy = null;

    public DeletedNode id(Long id) {
        this.id = id;
        return this;
    }

    @Schema(description="Node ID")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public DeletedNode parentId(Long parentId) {
        this.parentId = parentId;
        return this;
    }

    @Schema(required=true, description="Parent node ID (room or folder)")
    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public DeletedNode parentPath(String parentPath) {
        this.parentPath = parentPath;
        return this;
    }

    @Schema(required=true, description="Parent node path  `/` if node is a root node (room)")
    public String getParentPath() {
        return this.parentPath;
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    public DeletedNode type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(required=true, description="Node type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public DeletedNode name(String name) {
        this.name = name;
        return this;
    }

    @Schema(required=true, description="Node name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DeletedNode expireAt(DateTime expireAt) {
        this.expireAt = expireAt;
        return this;
    }

    @Schema(description="Expiration date")
    public DateTime getExpireAt() {
        return this.expireAt;
    }

    public void setExpireAt(DateTime expireAt) {
        this.expireAt = expireAt;
    }

    public DeletedNode accessedAt(DateTime accessedAt) {
        this.accessedAt = accessedAt;
        return this;
    }

    @Schema(description="Last access date")
    public DateTime getAccessedAt() {
        return this.accessedAt;
    }

    public void setAccessedAt(DateTime accessedAt) {
        this.accessedAt = accessedAt;
    }

    public DeletedNode isEncrypted(Boolean isEncrypted) {
        this.isEncrypted = isEncrypted;
        return this;
    }

    @Schema(description="Encryption state")
    public Boolean isIsEncrypted() {
        return this.isEncrypted;
    }

    public void setIsEncrypted(Boolean isEncrypted) {
        this.isEncrypted = isEncrypted;
    }

    public DeletedNode notes(String notes) {
        this.notes = notes;
        return this;
    }

    @Schema(description="User notes")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public DeletedNode size(Long size) {
        this.size = size;
        return this;
    }

    @Schema(description="Node size in byte")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public DeletedNode classification(ClassificationEnum classification) {
        this.classification = classification;
        return this;
    }

    @Schema(description="Classification ID:  * `1` - public  * `2` - internal  * `3` - confidential  * `4` - strictly confidential    (default: classification from parent room)")
    public ClassificationEnum getClassification() {
        return this.classification;
    }

    public void setClassification(ClassificationEnum classification) {
        this.classification = classification;
    }

    public DeletedNode createdAt(DateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Schema(description="Creation date")
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public DeletedNode createdBy(UserInfo createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @Schema(description="")
    public UserInfo getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(UserInfo createdBy) {
        this.createdBy = createdBy;
    }

    public DeletedNode updatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Schema(description="Modification date")
    public DateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public DeletedNode updatedBy(UserInfo updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Schema(description="")
    public UserInfo getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(UserInfo updatedBy) {
        this.updatedBy = updatedBy;
    }

    public DeletedNode deletedAt(DateTime deletedAt) {
        this.deletedAt = deletedAt;
        return this;
    }

    @Schema(description="Deletion date")
    public DateTime getDeletedAt() {
        return this.deletedAt;
    }

    public void setDeletedAt(DateTime deletedAt) {
        this.deletedAt = deletedAt;
    }

    public DeletedNode deletedBy(UserInfo deletedBy) {
        this.deletedBy = deletedBy;
        return this;
    }

    @Schema(description="")
    public UserInfo getDeletedBy() {
        return this.deletedBy;
    }

    public void setDeletedBy(UserInfo deletedBy) {
        this.deletedBy = deletedBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeletedNode deletedNode = (DeletedNode)o;
        return Objects.equals(this.id, deletedNode.id) && Objects.equals(this.parentId, deletedNode.parentId) && Objects.equals(this.parentPath, deletedNode.parentPath) && Objects.equals((Object)this.type, (Object)deletedNode.type) && Objects.equals(this.name, deletedNode.name) && Objects.equals(this.expireAt, deletedNode.expireAt) && Objects.equals(this.accessedAt, deletedNode.accessedAt) && Objects.equals(this.isEncrypted, deletedNode.isEncrypted) && Objects.equals(this.notes, deletedNode.notes) && Objects.equals(this.size, deletedNode.size) && Objects.equals((Object)this.classification, (Object)deletedNode.classification) && Objects.equals(this.createdAt, deletedNode.createdAt) && Objects.equals(this.createdBy, deletedNode.createdBy) && Objects.equals(this.updatedAt, deletedNode.updatedAt) && Objects.equals(this.updatedBy, deletedNode.updatedBy) && Objects.equals(this.deletedAt, deletedNode.deletedAt) && Objects.equals(this.deletedBy, deletedNode.deletedBy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.parentId, this.parentPath, this.type, this.name, this.expireAt, this.accessedAt, this.isEncrypted, this.notes, this.size, this.classification, this.createdAt, this.createdBy, this.updatedAt, this.updatedBy, this.deletedAt, this.deletedBy});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeletedNode {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    parentId: ").append(this.toIndentedString(this.parentId)).append("\n");
        sb.append("    parentPath: ").append(this.toIndentedString(this.parentPath)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    expireAt: ").append(this.toIndentedString(this.expireAt)).append("\n");
        sb.append("    accessedAt: ").append(this.toIndentedString(this.accessedAt)).append("\n");
        sb.append("    isEncrypted: ").append(this.toIndentedString(this.isEncrypted)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    classification: ").append(this.toIndentedString((Object)this.classification)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    updatedBy: ").append(this.toIndentedString(this.updatedBy)).append("\n");
        sb.append("    deletedAt: ").append(this.toIndentedString(this.deletedAt)).append("\n");
        sb.append("    deletedBy: ").append(this.toIndentedString(this.deletedBy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        FOLDER("folder"),
        FILE("file");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum ClassificationEnum {
        NUMBER_1(1),
        NUMBER_2(2),
        NUMBER_3(3),
        NUMBER_4(4);

        private Integer value;

        private ClassificationEnum(Integer value) {
            this.value = value;
        }

        @JsonValue
        public Integer getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ClassificationEnum fromValue(String text) {
            for (ClassificationEnum b : ClassificationEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

