/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.api;

import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.Configuration;
import ch.cyberduck.core.sds.io.swagger.client.Pair;
import ch.cyberduck.core.sds.io.swagger.client.model.AttributesResponse;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateWebhookRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.Customer;
import ch.cyberduck.core.sds.io.swagger.client.model.CustomerAttributes;
import ch.cyberduck.core.sds.io.swagger.client.model.CustomerList;
import ch.cyberduck.core.sds.io.swagger.client.model.EventTypeList;
import ch.cyberduck.core.sds.io.swagger.client.model.NewCustomerRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.NewCustomerResponse;
import ch.cyberduck.core.sds.io.swagger.client.model.UpdateCustomerRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.UpdateCustomerResponse;
import ch.cyberduck.core.sds.io.swagger.client.model.UpdateWebhookRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.UserList;
import ch.cyberduck.core.sds.io.swagger.client.model.Webhook;
import ch.cyberduck.core.sds.io.swagger.client.model.WebhookList;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class ProvisioningApi {
    private ApiClient apiClient;

    public ProvisioningApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProvisioningApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public NewCustomerResponse createCustomer(NewCustomerRequest body, String xSdsDateFormat, String xSdsServiceToken) throws ApiException {
        NewCustomerRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createCustomer");
        }
        String localVarPath = "/v4/provisioning/customers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        if (xSdsServiceToken != null) {
            localVarHeaderParams.put("X-Sds-Service-Token", this.apiClient.parameterToString(xSdsServiceToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<NewCustomerResponse> localVarReturnType = new GenericType<NewCustomerResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Webhook createTenantWebhook(CreateWebhookRequest body, String xSdsDateFormat, String xSdsServiceToken) throws ApiException {
        CreateWebhookRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createTenantWebhook");
        }
        String localVarPath = "/v4/provisioning/webhooks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        if (xSdsServiceToken != null) {
            localVarHeaderParams.put("X-Sds-Service-Token", this.apiClient.parameterToString(xSdsServiceToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<Webhook> localVarReturnType = new GenericType<Webhook>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void removeCustomer(Long customerId, String xSdsServiceToken) throws ApiException {
        Object localVarPostBody = null;
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling removeCustomer");
        }
        String localVarPath = "/v4/provisioning/customers/{customer_id}".replaceAll("\\{customer_id\\}", this.apiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsServiceToken != null) {
            localVarHeaderParams.put("X-Sds-Service-Token", this.apiClient.parameterToString(xSdsServiceToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void removeCustomerAttribute(Long customerId, String key, String xSdsServiceToken) throws ApiException {
        Object localVarPostBody = null;
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling removeCustomerAttribute");
        }
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling removeCustomerAttribute");
        }
        String localVarPath = "/v4/provisioning/customers/{customer_id}/customerAttributes/{key}".replaceAll("\\{customer_id\\}", this.apiClient.escapeString(customerId.toString())).replaceAll("\\{key\\}", this.apiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsServiceToken != null) {
            localVarHeaderParams.put("X-Sds-Service-Token", this.apiClient.parameterToString(xSdsServiceToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void removeTenantWebhook(Long webhookId, String xSdsServiceToken) throws ApiException {
        Object localVarPostBody = null;
        if (webhookId == null) {
            throw new ApiException(400, "Missing the required parameter 'webhookId' when calling removeTenantWebhook");
        }
        String localVarPath = "/v4/provisioning/webhooks/{webhook_id}".replaceAll("\\{webhook_id\\}", this.apiClient.escapeString(webhookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsServiceToken != null) {
            localVarHeaderParams.put("X-Sds-Service-Token", this.apiClient.parameterToString(xSdsServiceToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public Customer requestCustomer(Long customerId, String xSdsDateFormat, Boolean includeAttributes, String xSdsServiceToken) throws ApiException {
        Object localVarPostBody = null;
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling requestCustomer");
        }
        String localVarPath = "/v4/provisioning/customers/{customer_id}".replaceAll("\\{customer_id\\}", this.apiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include_attributes", includeAttributes));
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        if (xSdsServiceToken != null) {
            localVarHeaderParams.put("X-Sds-Service-Token", this.apiClient.parameterToString(xSdsServiceToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<Customer> localVarReturnType = new GenericType<Customer>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AttributesResponse requestCustomerAttributes(Long customerId, Integer offset, Integer limit, String filter, String sort, String xSdsServiceToken) throws ApiException {
        Object localVarPostBody = null;
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling requestCustomerAttributes");
        }
        String localVarPath = "/v4/provisioning/customers/{customer_id}/customerAttributes".replaceAll("\\{customer_id\\}", this.apiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        if (xSdsServiceToken != null) {
            localVarHeaderParams.put("X-Sds-Service-Token", this.apiClient.parameterToString(xSdsServiceToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<AttributesResponse> localVarReturnType = new GenericType<AttributesResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserList requestCustomerUsers(Long customerId, String xSdsDateFormat, Integer offset, Integer limit, String filter, String sort, String xSdsServiceToken) throws ApiException {
        Object localVarPostBody = null;
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling requestCustomerUsers");
        }
        String localVarPath = "/v4/provisioning/customers/{customer_id}/users".replaceAll("\\{customer_id\\}", this.apiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        if (xSdsServiceToken != null) {
            localVarHeaderParams.put("X-Sds-Service-Token", this.apiClient.parameterToString(xSdsServiceToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<UserList> localVarReturnType = new GenericType<UserList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CustomerList requestCustomers(String xSdsDateFormat, Integer offset, Integer limit, String filter, String sort, Boolean includeAttributes, String xSdsServiceToken) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v4/provisioning/customers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include_attributes", includeAttributes));
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        if (xSdsServiceToken != null) {
            localVarHeaderParams.put("X-Sds-Service-Token", this.apiClient.parameterToString(xSdsServiceToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<CustomerList> localVarReturnType = new GenericType<CustomerList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EventTypeList requestListOfEventTypesForTenant(String xSdsServiceToken) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v4/provisioning/webhooks/event_types";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsServiceToken != null) {
            localVarHeaderParams.put("X-Sds-Service-Token", this.apiClient.parameterToString(xSdsServiceToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<EventTypeList> localVarReturnType = new GenericType<EventTypeList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public WebhookList requestListOfTenantWebhooks(String xSdsDateFormat, Integer offset, Integer limit, String filter, String sort, String xSdsServiceToken) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v4/provisioning/webhooks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        if (xSdsServiceToken != null) {
            localVarHeaderParams.put("X-Sds-Service-Token", this.apiClient.parameterToString(xSdsServiceToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<WebhookList> localVarReturnType = new GenericType<WebhookList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Webhook requestTenantWebhook(Long webhookId, String xSdsDateFormat, String xSdsServiceToken) throws ApiException {
        Object localVarPostBody = null;
        if (webhookId == null) {
            throw new ApiException(400, "Missing the required parameter 'webhookId' when calling requestTenantWebhook");
        }
        String localVarPath = "/v4/provisioning/webhooks/{webhook_id}".replaceAll("\\{webhook_id\\}", this.apiClient.escapeString(webhookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        if (xSdsServiceToken != null) {
            localVarHeaderParams.put("X-Sds-Service-Token", this.apiClient.parameterToString(xSdsServiceToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<Webhook> localVarReturnType = new GenericType<Webhook>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Webhook resetTenantWebhookLifetime(Long webhookId, String xSdsDateFormat, String xSdsServiceToken) throws ApiException {
        Object localVarPostBody = null;
        if (webhookId == null) {
            throw new ApiException(400, "Missing the required parameter 'webhookId' when calling resetTenantWebhookLifetime");
        }
        String localVarPath = "/v4/provisioning/webhooks/{webhook_id}/reset_lifetime".replaceAll("\\{webhook_id\\}", this.apiClient.escapeString(webhookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        if (xSdsServiceToken != null) {
            localVarHeaderParams.put("X-Sds-Service-Token", this.apiClient.parameterToString(xSdsServiceToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<Webhook> localVarReturnType = new GenericType<Webhook>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Customer setCustomerAttributes(CustomerAttributes body, Long customerId, String xSdsDateFormat, String xSdsServiceToken) throws ApiException {
        CustomerAttributes localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling setCustomerAttributes");
        }
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling setCustomerAttributes");
        }
        String localVarPath = "/v4/provisioning/customers/{customer_id}/customerAttributes".replaceAll("\\{customer_id\\}", this.apiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        if (xSdsServiceToken != null) {
            localVarHeaderParams.put("X-Sds-Service-Token", this.apiClient.parameterToString(xSdsServiceToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<Customer> localVarReturnType = new GenericType<Customer>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UpdateCustomerResponse updateCustomer(UpdateCustomerRequest body, Long customerId, String xSdsDateFormat, String xSdsServiceToken) throws ApiException {
        UpdateCustomerRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateCustomer");
        }
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling updateCustomer");
        }
        String localVarPath = "/v4/provisioning/customers/{customer_id}".replaceAll("\\{customer_id\\}", this.apiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        if (xSdsServiceToken != null) {
            localVarHeaderParams.put("X-Sds-Service-Token", this.apiClient.parameterToString(xSdsServiceToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<UpdateCustomerResponse> localVarReturnType = new GenericType<UpdateCustomerResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Customer updateCustomerAttributes(CustomerAttributes body, Long customerId, String xSdsDateFormat, String xSdsServiceToken) throws ApiException {
        CustomerAttributes localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateCustomerAttributes");
        }
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling updateCustomerAttributes");
        }
        String localVarPath = "/v4/provisioning/customers/{customer_id}/customerAttributes".replaceAll("\\{customer_id\\}", this.apiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        if (xSdsServiceToken != null) {
            localVarHeaderParams.put("X-Sds-Service-Token", this.apiClient.parameterToString(xSdsServiceToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<Customer> localVarReturnType = new GenericType<Customer>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Webhook updateTenantWebhook(UpdateWebhookRequest body, Long webhookId, String xSdsDateFormat, String xSdsServiceToken) throws ApiException {
        UpdateWebhookRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateTenantWebhook");
        }
        if (webhookId == null) {
            throw new ApiException(400, "Missing the required parameter 'webhookId' when calling updateTenantWebhook");
        }
        String localVarPath = "/v4/provisioning/webhooks/{webhook_id}".replaceAll("\\{webhook_id\\}", this.apiClient.escapeString(webhookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        if (xSdsServiceToken != null) {
            localVarHeaderParams.put("X-Sds-Service-Token", this.apiClient.parameterToString(xSdsServiceToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<Webhook> localVarReturnType = new GenericType<Webhook>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

