/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.AbstractHttpWriteFeature;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.http.DelayedHttpEntityCallable;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.sds.SDSApiClient;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class SDSDirectS3WriteFeature
extends AbstractHttpWriteFeature<VersionId> {
    private static final Logger log = Logger.getLogger(SDSDirectS3WriteFeature.class);
    private final SDSSession session;
    private final Find finder;
    private final AttributesFinder attributes;

    public SDSDirectS3WriteFeature(SDSSession session) {
        this(session, (Find)new DefaultFindFeature((Session)session), (AttributesFinder)new DefaultAttributesFinderFeature((Session)session));
    }

    public SDSDirectS3WriteFeature(SDSSession session, Find finder, AttributesFinder attributes) {
        super(finder, attributes);
        this.session = session;
        this.finder = finder;
        this.attributes = attributes;
    }

    public HttpResponseOutputStream<VersionId> write(Path file, final TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        return this.write(file, status, (DelayedHttpEntityCallable)new DelayedHttpEntityCallable<VersionId>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public VersionId call(AbstractHttpEntity entity) throws BackgroundException {
                try {
                    HttpPut request = new HttpPut(status.getUrl());
                    request.setEntity((HttpEntity)entity);
                    request.setHeader("Content-Type", "application/octet-stream");
                    CloseableHttpResponse response = ((SDSApiClient)SDSDirectS3WriteFeature.this.session.getClient()).getClient().execute((HttpUriRequest)request);
                    try {
                        switch (response.getStatusLine().getStatusCode()) {
                            case 200: {
                                if (!response.containsHeader("ETag")) {
                                    log.error((Object)String.format("Missing ETag in response %s", response));
                                    throw new InteroperabilityException(response.getStatusLine().getReasonPhrase());
                                }
                                if (log.isInfoEnabled()) {
                                    log.info((Object)String.format("Received response %s for part number %d", response, status.getPart()));
                                }
                                VersionId versionId = new VersionId(StringUtils.remove((String)response.getFirstHeader("ETag").getValue(), (char)'\"'));
                                return versionId;
                            }
                        }
                        EntityUtils.updateEntity((HttpResponse)response, (HttpEntity)new BufferedHttpEntity(response.getEntity()));
                        throw new DefaultHttpResponseExceptionMappingService().map(new HttpResponseException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
                    }
                    finally {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                }
                catch (HttpResponseException e) {
                    throw new DefaultHttpResponseExceptionMappingService().map(e);
                }
                catch (IOException e) {
                    throw new DefaultIOExceptionMappingService().map(e);
                }
            }

            public long getContentLength() {
                return status.getLength();
            }
        });
    }

    public Write.Append append(Path file, Long length, Cache<Path> cache) throws BackgroundException {
        if (this.finder.withCache(cache).find(file)) {
            PathAttributes attr = this.attributes.withCache(cache).find(file);
            return new Write.Append(false, true).withSize(Long.valueOf(attr.getSize())).withChecksum(attr.getChecksum());
        }
        return Write.notfound;
    }

    public boolean temporary() {
        return false;
    }

    public boolean random() {
        return false;
    }
}

