/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSReadFeature;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptReadFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.InputStream;

public class SDSDelegatingReadFeature
implements Read {
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;
    private final SDSReadFeature proxy;

    public SDSDelegatingReadFeature(SDSSession session, SDSNodeIdProvider nodeid, SDSReadFeature proxy) {
        this.session = session;
        this.nodeid = nodeid;
        this.proxy = proxy;
    }

    public InputStream read(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        if (this.nodeid.isEncrypted(file)) {
            return new TripleCryptReadFeature(this.session, this.nodeid, this.proxy).read(file, status, callback);
        }
        return this.proxy.read(file, status, callback);
    }

    public boolean offset(Path file) throws BackgroundException {
        if (this.nodeid.isEncrypted(file)) {
            return new TripleCryptReadFeature(this.session, this.nodeid, this.proxy).offset(file);
        }
        return this.proxy.offset(file);
    }
}

