/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.secret.simple;

import java.io.IOException;
import java.security.AccessControlException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.ObjectPath;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.types.Variant;
import org.freedesktop.secret.Collection;
import org.freedesktop.secret.Item;
import org.freedesktop.secret.Pair;
import org.freedesktop.secret.Prompt;
import org.freedesktop.secret.Secret;
import org.freedesktop.secret.Service;
import org.freedesktop.secret.Session;
import org.freedesktop.secret.Static;
import org.freedesktop.secret.TransportEncryption;
import org.freedesktop.secret.interfaces.Collection;
import org.freedesktop.secret.interfaces.Prompt;
import org.freedesktop.secret.interfaces.Service;
import org.gnome.keyring.InternalUnsupportedGuiltRiddenInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleCollection
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(SimpleCollection.class);
    private TransportEncryption encryption = null;
    private Service service = null;
    private Session session = null;
    private Prompt prompt = null;
    private InternalUnsupportedGuiltRiddenInterface withoutPrompt = null;
    private Collection collection;
    private Secret encrypted = null;

    public SimpleCollection() throws IOException {
        this.init();
        ObjectPath path = Static.Convert.toObjectPath("/org/freedesktop/secrets/aliases/default");
        this.collection = new Collection((DBusPath)path, this.service);
        this.unlock();
    }

    public SimpleCollection(String label, CharSequence password) throws IOException {
        this.init();
        if (this.exists(label)) {
            ObjectPath path = this.getCollectionPath(label);
            this.collection = new Collection((DBusPath)path, this.service);
        } else {
            ObjectPath path = null;
            Map<String, Variant> properties = Collection.createProperties(label);
            if (password == null) {
                Pair<ObjectPath, ObjectPath> response = this.service.createCollection(properties);
                if (!"/".equals(((ObjectPath)response.a).getPath())) {
                    path = (DBusPath)response.a;
                }
                this.performPrompt((ObjectPath)response.b);
            } else {
                try {
                    this.encrypted = this.encryption.encrypt(password);
                    path = this.withoutPrompt.createWithMasterPassword(properties, this.encrypted);
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                    log.error(e.toString(), e.getCause());
                }
            }
            if (path == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    log.error(e.toString(), e.getCause());
                }
                Service.CollectionCreated cc = this.service.getSignalHandler().getLastHandledSignal(Service.CollectionCreated.class);
                path = cc.collection;
            }
            this.collection = new Collection((DBusPath)path, this.service);
        }
        this.unlock();
    }

    private void init() throws IOException {
        try {
            this.encryption = new TransportEncryption();
            this.encryption.initialize();
            this.encryption.openSession();
            this.encryption.generateSessionKey();
            this.service = this.encryption.getService();
            this.session = this.service.getSession();
            this.prompt = new Prompt(this.service);
            this.withoutPrompt = new InternalUnsupportedGuiltRiddenInterface(this.service);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | DBusException e) {
            log.error(e.toString(), e.getCause());
            throw new IOException(e.toString(), e.getCause());
        }
    }

    private Map<ObjectPath, String> getLabels() {
        List<ObjectPath> collections = this.service.getCollections();
        HashMap<ObjectPath, String> labels = new HashMap<ObjectPath, String>();
        for (ObjectPath path : collections) {
            Collection c = new Collection((DBusPath)path, this.service, null);
            labels.put(path, c.getLabel());
        }
        return labels;
    }

    private boolean exists(String label) {
        Map<ObjectPath, String> labels = this.getLabels();
        return labels.values().contains(label);
    }

    private ObjectPath getCollectionPath(String label) {
        Map<ObjectPath, String> labels = this.getLabels();
        ObjectPath path = null;
        for (Map.Entry<ObjectPath, String> entry : labels.entrySet()) {
            ObjectPath p = entry.getKey();
            String l = entry.getValue();
            if (!label.equals(l)) continue;
            path = p;
            break;
        }
        return path;
    }

    private final boolean isDefault() {
        List<String> defaults = Arrays.asList(null, "login", "session", "default");
        return defaults.contains(this.collection.getId());
    }

    private void performPrompt(ObjectPath path) {
        if (!"/".equals(path.getPath())) {
            this.prompt.await(path);
        }
    }

    private void unlock() {
        if (this.collection.isLocked()) {
            if (this.encrypted == null) {
                Pair<List<ObjectPath>, ObjectPath> response = this.service.unlock(Arrays.asList(this.collection.getPath()));
                this.performPrompt((ObjectPath)response.b);
            } else {
                this.withoutPrompt.unlockWithMasterPassword((DBusPath)this.collection.getPath(), this.encrypted);
            }
        }
    }

    private Item getItem(String path) {
        return new Item(Static.Convert.toObjectPath(path), this.service);
    }

    private void getUserPermission() throws AccessControlException {
        if (this.isDefault()) {
            List<ObjectPath> lockable = Arrays.asList(this.collection.getPath());
            this.service.lock(lockable);
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                log.error(e.toString(), e.getCause());
            }
            Pair<List<ObjectPath>, ObjectPath> response = this.service.unlock(lockable);
            this.performPrompt((ObjectPath)response.b);
            if (this.collection.isLocked()) {
                throw new AccessControlException("One may not read all passwords from a default collection without permission.");
            }
        }
    }

    public void clear() {
        if (this.encryption != null) {
            this.encryption.clear();
        }
        if (this.encrypted != null) {
            this.encrypted.clear();
        }
    }

    @Override
    public void close() {
        this.clear();
        if (this.session != null) {
            this.session.close();
        }
    }

    public void delete() throws AccessControlException {
        if (this.isDefault()) {
            throw new AccessControlException("Default collections may not be deleted with the simple API.");
        }
        ObjectPath promptPath = this.collection.delete();
        this.performPrompt(promptPath);
    }

    public String createItem(String label, CharSequence password, Map<String, String> attributes) throws IllegalArgumentException {
        if (password == null) {
            throw new IllegalArgumentException("The password may not be null.");
        }
        if (label == null) {
            throw new IllegalArgumentException("The label of the password may not be null.");
        }
        this.unlock();
        DBusPath item = null;
        Map<String, Variant> properties = Item.createProperties(label, attributes);
        try (Secret secret = this.encryption.encrypt(password);){
            Pair<ObjectPath, ObjectPath> response = this.collection.createItem(properties, secret, false);
            item = (DBusPath)response.a;
            if ("/".equals(item.getPath())) {
                Prompt.Completed completed = this.prompt.await((ObjectPath)response.b);
                if (!completed.dismissed) {
                    Collection.ItemCreated ic = this.collection.getSignalHandler().getLastHandledSignal(Collection.ItemCreated.class);
                    item = ic.item;
                }
            }
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            log.error(e.toString(), e.getCause());
        }
        return item.getPath();
    }

    public String createItem(String label, CharSequence password) throws IllegalArgumentException {
        return this.createItem(label, password, null);
    }

    public void updateItem(String objectPath, String label, CharSequence password, Map<String, String> attributes) throws IllegalArgumentException {
        if (objectPath == null) {
            throw new IllegalArgumentException("The object path of the item may not be null.");
        }
        this.unlock();
        Item item = this.getItem(objectPath);
        if (label != null) {
            item.setLabel(label);
        }
        if (attributes != null) {
            item.setAttributes(attributes);
        }
        if (password != null) {
            try (Secret secret = this.encryption.encrypt(password);){
                item.setSecret(secret);
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                log.error(e.toString(), e.getCause());
            }
        }
    }

    public String getLabel(String objectPath) {
        this.unlock();
        return this.getItem(objectPath).getLabel();
    }

    public Map<String, String> getAttributes(String objectPath) {
        this.unlock();
        return this.getItem(objectPath).getAttributes();
    }

    public List<String> getItems(Map<String, String> attributes) {
        this.unlock();
        List<ObjectPath> objects = this.collection.searchItems(attributes);
        if (objects != null && !objects.isEmpty()) {
            return Static.Convert.toStrings(objects);
        }
        return null;
    }

    public char[] getSecret(String objectPath) {
        this.unlock();
        Item item = this.getItem(objectPath);
        char[] decrypted = null;
        try (Secret secret = item.getSecret(this.session.getPath());){
            decrypted = this.encryption.decrypt(secret);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            log.error(e.toString(), e.getCause());
        }
        return decrypted;
    }

    public Map<String, char[]> getSecrets() throws AccessControlException {
        this.getUserPermission();
        List<ObjectPath> items = this.collection.getItems();
        HashMap<String, char[]> passwords = new HashMap<String, char[]>();
        for (ObjectPath item : items) {
            String path = item.getPath();
            passwords.put(path, this.getSecret(path));
        }
        return passwords;
    }

    public void deleteItem(String objectPath) throws AccessControlException {
        this.getUserPermission();
        Item item = this.getItem(objectPath);
        ObjectPath promptPath = item.delete();
        this.performPrompt(promptPath);
    }

    public void deleteItems(List<String> objectPaths) throws AccessControlException {
        for (String item : objectPaths) {
            this.deleteItem(item);
        }
    }
}

