/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.transfer.encrypt;

import org.irods.jargon.core.connection.NegotiatedClientServerConfiguration;
import org.irods.jargon.core.connection.PipelineConfiguration;
import org.irods.jargon.core.exception.ClientServerNegotiationException;
import org.irods.jargon.core.exception.JargonRuntimeException;
import org.irods.jargon.core.protovalues.EncryptionAlgorithmEnum;
import org.irods.jargon.core.transfer.encrypt.AesCipherDecryptWrapper;
import org.irods.jargon.core.transfer.encrypt.AesCipherEncryptWrapper;
import org.irods.jargon.core.transfer.encrypt.ParallelDecryptionCipherWrapper;
import org.irods.jargon.core.transfer.encrypt.ParallelEncryptionCipherWrapper;

public class EncryptionWrapperFactory {
    public static ParallelEncryptionCipherWrapper instanceEncrypt(PipelineConfiguration pipelineConfiguration, NegotiatedClientServerConfiguration negotiatedClientServerConfiguration) throws ClientServerNegotiationException {
        if (pipelineConfiguration == null) {
            throw new IllegalArgumentException("null pipelineConfiguration");
        }
        if (negotiatedClientServerConfiguration == null) {
            throw new IllegalArgumentException("null negotiatedClientServerConfiguration");
        }
        if (!negotiatedClientServerConfiguration.isSslConnection()) {
            throw new JargonRuntimeException("no encryption was negotiated,should not call this factory");
        }
        if (pipelineConfiguration.getEncryptionAlgorithmEnum() == EncryptionAlgorithmEnum.AES_256_CBC) {
            return new AesCipherEncryptWrapper(pipelineConfiguration, negotiatedClientServerConfiguration);
        }
        throw new ClientServerNegotiationException("unsuppored encryption algo:" + (Object)((Object)pipelineConfiguration.getEncryptionAlgorithmEnum()));
    }

    public static ParallelDecryptionCipherWrapper instanceDecrypt(PipelineConfiguration pipelineConfiguration, NegotiatedClientServerConfiguration negotiatedClientServerConfiguration) throws ClientServerNegotiationException {
        if (pipelineConfiguration == null) {
            throw new IllegalArgumentException("null pipelineConfiguration");
        }
        if (negotiatedClientServerConfiguration == null) {
            throw new IllegalArgumentException("null negotiatedClientServerConfiguration");
        }
        if (!negotiatedClientServerConfiguration.isSslConnection()) {
            throw new JargonRuntimeException("no encryption was negotiated,should not call this factory");
        }
        if (pipelineConfiguration.getEncryptionAlgorithmEnum() == EncryptionAlgorithmEnum.AES_256_CBC) {
            return new AesCipherDecryptWrapper(pipelineConfiguration, negotiatedClientServerConfiguration);
        }
        throw new ClientServerNegotiationException("unsuppored decryption algo:" + (Object)((Object)pipelineConfiguration.getEncryptionAlgorithmEnum()));
    }
}

