/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.io.File;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.CatNoAccessException;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.DuplicateDataException;
import org.irods.jargon.core.exception.FileNotFoundException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.JargonFileOrCollAlreadyExistsException;
import org.irods.jargon.core.exception.OverwriteException;
import org.irods.jargon.core.packinstr.DataObjCopyInp;
import org.irods.jargon.core.pub.CollectionAO;
import org.irods.jargon.core.pub.CollectionAndDataObjectListAndSearchAO;
import org.irods.jargon.core.pub.DataObjectAO;
import org.irods.jargon.core.pub.DataTransferOperations;
import org.irods.jargon.core.pub.IRODSAccessObjectFactory;
import org.irods.jargon.core.pub.IRODSFileSystemAO;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.irods.jargon.core.pub.TransferOperationsHelper;
import org.irods.jargon.core.pub.domain.ObjStat;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.pub.io.IRODSFileFactory;
import org.irods.jargon.core.transfer.DefaultTransferControlBlock;
import org.irods.jargon.core.transfer.TransferControlBlock;
import org.irods.jargon.core.transfer.TransferStatus;
import org.irods.jargon.core.transfer.TransferStatusCallbackListener;
import org.irods.jargon.core.utils.LocalFileUtils;
import org.irods.jargon.core.utils.MiscIRODSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataTransferOperationsImpl
extends IRODSGenericAO
implements DataTransferOperations {
    private static Logger log = LoggerFactory.getLogger(DataTransferOperationsImpl.class);
    private TransferOperationsHelper transferOperationsHelper = null;
    private DataObjectAO dataObjectAO = null;
    private CollectionAndDataObjectListAndSearchAO collectionAndDataObjectListAndSearchAO = null;

    protected DataTransferOperationsImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
        this.transferOperationsHelper = TransferOperationsHelper.instance(irodsSession, irodsAccount);
        this.dataObjectAO = this.getIRODSAccessObjectFactory().getDataObjectAO(this.getIRODSAccount());
        this.collectionAndDataObjectListAndSearchAO = this.getIRODSAccessObjectFactory().getCollectionAndDataObjectListAndSearchAO(this.getIRODSAccount());
    }

    @Override
    public void physicalMove(String absolutePathToSourceFile, String targetResource) throws JargonException {
        IRODSFileSystemAO irodsFileSystemAO = this.getIRODSAccessObjectFactory().getIRODSFileSystemAO(this.getIRODSAccount());
        irodsFileSystemAO.physicalMove(absolutePathToSourceFile, targetResource);
    }

    private void moveOperation(IRODSFile irodsSourceFile, IRODSFile irodsTargetFile) throws JargonFileOrCollAlreadyExistsException, JargonException {
        log.info("moveOperation()");
        log.info("target file:{}", (Object)irodsTargetFile.getAbsolutePath());
        log.info("target file isDir? {}", (Object)irodsTargetFile.isDirectory());
        IRODSFile actualTargetFile = irodsTargetFile;
        if (irodsSourceFile.isFile() && irodsTargetFile.isDirectory()) {
            log.info("target file is a directory, automatically propogate the source file name to the target");
            actualTargetFile = this.getIRODSFileFactory().instanceIRODSFile(irodsTargetFile.getAbsolutePath(), irodsSourceFile.getName());
        }
        if (irodsSourceFile.getAbsolutePath().equals(actualTargetFile.getAbsolutePath())) {
            log.warn("attempt to move a file: {} to the same file name, logged and ignored");
            return;
        }
        DataObjCopyInp dataObjCopyInp = null;
        if (irodsSourceFile.isFile()) {
            log.info("move is for a file");
            dataObjCopyInp = DataObjCopyInp.instanceForRenameFile(irodsSourceFile.getAbsolutePath(), actualTargetFile.getAbsolutePath());
        } else {
            log.info("move is for a collection");
            dataObjCopyInp = DataObjCopyInp.instanceForRenameCollection(irodsSourceFile.getAbsolutePath(), actualTargetFile.getAbsolutePath());
        }
        try {
            this.getIRODSProtocol().irodsFunction(dataObjCopyInp);
        }
        catch (JargonException je) {
            log.error("jargon exception in move operation", (Throwable)je);
            throw je;
        }
    }

    @Override
    public void move(String sourceFileAbsolutePath, String targetFileAbsolutePath) throws JargonException {
        if (sourceFileAbsolutePath == null || sourceFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null sourceFileAbsolutePath");
        }
        if (targetFileAbsolutePath == null || targetFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("targetFileAbsolutePath is empty");
        }
        MiscIRODSUtils.checkPathSizeForMax(targetFileAbsolutePath);
        log.info("moveAFileOrCollection() from {}", (Object)sourceFileAbsolutePath);
        log.info("to {}", (Object)targetFileAbsolutePath);
        IRODSFile sourceFile = this.getIRODSFileFactory().instanceIRODSFile(sourceFileAbsolutePath);
        IRODSFile targetFile = this.getIRODSFileFactory().instanceIRODSFile(targetFileAbsolutePath);
        this.move(sourceFile, targetFile);
    }

    @Override
    public void move(IRODSFile sourceFile, IRODSFile targetFile) throws FileNotFoundException, JargonException {
        log.info("moveAFileOrCollection");
        if (sourceFile == null) {
            throw new IllegalArgumentException("null sourceFile");
        }
        if (targetFile == null) {
            throw new IllegalArgumentException("null targetFile");
        }
        log.info("sourceFile:{}", (Object)sourceFile.getAbsolutePath());
        log.info("targetFile:{}", (Object)targetFile.getAbsolutePath());
        if (!sourceFile.exists()) {
            log.error("move error, source file does not exist:{}", (Object)sourceFile.getAbsolutePath());
            throw new IllegalArgumentException("sourceFile does not exist");
        }
        log.info("see if this is just a physical move");
        if (sourceFile.getAbsolutePath().equals(targetFile.getAbsolutePath())) {
            log.info("source and target paths are the same...is this really a phymove?");
            if (!targetFile.getResource().isEmpty()) {
                log.info("delegating to a phymove");
                this.physicalMove(sourceFile.getAbsolutePath(), targetFile.getResource());
                return;
            }
            log.error("moving a file to itself");
            throw new JargonException("cannot move a file to itself!");
        }
        log.info("treat as a normal move");
        this.moveOperation(sourceFile, targetFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void getOperation(IRODSFile irodsSourceFile, File targetLocalFile, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws FileNotFoundException, JargonException {
        log.info("getOperation()");
        TransferControlBlock operativeTransferControlBlock = this.buildTransferControlBlockAndOptionsBasedOnParameters(transferControlBlock);
        if (transferStatusCallbackListener == null) {
            log.info("no transferStatusCallbackListener set for getOperation()");
        }
        if (irodsSourceFile == null) {
            throw new IllegalArgumentException("irods source file is null");
        }
        if (targetLocalFile == null) {
            throw new IllegalArgumentException("target local file is null");
        }
        log.info("get operation, irods source file is: {}", (Object)irodsSourceFile.getAbsolutePath());
        log.info("  local file for get: {}", (Object)targetLocalFile.getAbsolutePath());
        IRODSAccount reroutedAccount = null;
        try {
            File targetLocalFileNameForCallbacks = new File(targetLocalFile.getAbsolutePath(), irodsSourceFile.getName());
            log.info("file name normalized:{}", (Object)targetLocalFileNameForCallbacks);
            log.info("am I rerouting?");
            if (operativeTransferControlBlock.getTransferOptions().isAllowPutGetResourceRedirects() && this.getIRODSServerProperties().isSupportsConnectionRerouting()) {
                reroutedAccount = this.checkForReroutedConnectionDuringGetOperation(irodsSourceFile);
            }
            if (reroutedAccount != null) {
                DataTransferOperationsImpl reroutedDataTransferOperations = (DataTransferOperationsImpl)this.getIRODSAccessObjectFactory().getDataTransferOperations(reroutedAccount);
                reroutedDataTransferOperations.processGetAfterAnyConnectionRerouting(irodsSourceFile, targetLocalFile, transferStatusCallbackListener, operativeTransferControlBlock, targetLocalFileNameForCallbacks);
            } else {
                this.processGetAfterAnyConnectionRerouting(irodsSourceFile, targetLocalFile, transferStatusCallbackListener, operativeTransferControlBlock, targetLocalFileNameForCallbacks);
            }
            if (reroutedAccount == null) return;
        }
        catch (JargonException je) {
            log.warn("unexpected error in transfer that should have been caught in the actual transfer handling code", (Throwable)je);
            this.processExceptionDuringGetOperation(irodsSourceFile, targetLocalFile, transferStatusCallbackListener, operativeTransferControlBlock, je);
            return;
        }
        catch (Exception e) {
            log.warn("unexepected exception occurred in transfer, not caught in transfer code, will wrap in a JargonException and process", (Throwable)e);
            this.processExceptionDuringGetOperation(irodsSourceFile, targetLocalFile, transferStatusCallbackListener, operativeTransferControlBlock, new JargonException(e));
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (reroutedAccount != null) {
                log.info("closing re-routed account");
                this.getIRODSAccessObjectFactory().closeSessionAndEatExceptions(reroutedAccount);
            }
        }
        log.info("closing re-routed account");
        this.getIRODSAccessObjectFactory().closeSessionAndEatExceptions(reroutedAccount);
        return;
    }

    private IRODSAccount checkForReroutedConnectionDuringGetOperation(IRODSFile irodsSourceFile) throws JargonException {
        IRODSAccount reroutedAccount = null;
        log.info("redirects are available, check to see if I need to redirect to a resource server");
        String detectedHost = this.dataObjectAO.getHostForGetOperation(irodsSourceFile.getAbsolutePath(), irodsSourceFile.getResource());
        if (detectedHost == null || detectedHost.equals("thisAddress") || detectedHost.equals("localhost")) {
            log.info("using given resource connection");
            reroutedAccount = this.getIRODSAccount();
        } else {
            log.info("will reroute to host:{}", (Object)detectedHost);
            reroutedAccount = IRODSAccount.instanceForReroutedHost(this.getIRODSAccount(), detectedHost);
        }
        return reroutedAccount;
    }

    protected void processGetAfterAnyConnectionRerouting(IRODSFile irodsSourceFile, File targetLocalFile, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock operativeTransferControlBlock, File targetLocalFileNameForCallbacks) throws FileNotFoundException, JargonException {
        ObjStat objStat;
        if (operativeTransferControlBlock == null) {
            throw new IllegalArgumentException("null operativeTransferControlBlock");
        }
        log.info("get objStat..");
        try {
            objStat = this.collectionAndDataObjectListAndSearchAO.retrieveObjectStatForPath(irodsSourceFile.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            log.error("file not found retrieving objStat for file:{}", (Object)irodsSourceFile.getAbsolutePath(), (Object)e);
            this.processExceptionDuringGetOperation(irodsSourceFile, targetLocalFileNameForCallbacks, transferStatusCallbackListener, operativeTransferControlBlock, e);
            return;
        }
        if (objStat.isSomeTypeOfCollection()) {
            TransferStatus status;
            log.debug("get operation, treating as a directory");
            if (!targetLocalFileNameForCallbacks.getParentFile().exists()) {
                throw new FileNotFoundException("target parent file does not exist");
            }
            if (!targetLocalFileNameForCallbacks.getParentFile().canWrite()) {
                throw new CatNoAccessException("cannot write local file");
            }
            targetLocalFileNameForCallbacks.mkdirs();
            if (operativeTransferControlBlock != null) {
                CollectionAO collectionAO = this.getIRODSAccessObjectFactory().getCollectionAO(this.getIRODSAccount());
                int fileCount = collectionAO.countAllFilesUnderneathTheGivenCollection(irodsSourceFile.getAbsolutePath());
                log.info("get will transfer {} files)", (Object)fileCount);
                operativeTransferControlBlock.setTotalFilesToTransfer(fileCount);
            }
            if (transferStatusCallbackListener != null) {
                status = TransferStatus.instance(TransferStatus.TransferType.GET, irodsSourceFile.getAbsolutePath(), targetLocalFileNameForCallbacks.getAbsolutePath(), "", operativeTransferControlBlock.getTotalBytesToTransfer(), operativeTransferControlBlock.getTotalBytesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesSkippedSoFar(), operativeTransferControlBlock.getTotalFilesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_INITIATION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
                transferStatusCallbackListener.overallStatusCallback(status);
            }
            if (operativeTransferControlBlock.isCancelled()) {
                log.info("operation has been cancelled");
                if (transferStatusCallbackListener != null) {
                    status = TransferStatus.instance(TransferStatus.TransferType.GET, irodsSourceFile.getAbsolutePath(), targetLocalFileNameForCallbacks.getAbsolutePath(), "", operativeTransferControlBlock.getTotalBytesToTransfer(), operativeTransferControlBlock.getTotalBytesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesSkippedSoFar(), operativeTransferControlBlock.getTotalFilesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.CANCELLED, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
                    transferStatusCallbackListener.overallStatusCallback(status);
                }
                return;
            }
            this.getOperationWhenSourceFileIsDirectory(irodsSourceFile, targetLocalFile, transferStatusCallbackListener, operativeTransferControlBlock);
            if (transferStatusCallbackListener != null) {
                status = TransferStatus.instance(TransferStatus.TransferType.GET, irodsSourceFile.getAbsolutePath(), targetLocalFileNameForCallbacks.getAbsolutePath(), "", operativeTransferControlBlock.getTotalBytesToTransfer(), operativeTransferControlBlock.getTotalBytesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesSkippedSoFar(), operativeTransferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_COMPLETION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
                transferStatusCallbackListener.overallStatusCallback(status);
            }
        } else {
            TransferStatus status;
            if (operativeTransferControlBlock != null) {
                operativeTransferControlBlock.setTotalFilesToTransfer(1);
            }
            if (transferStatusCallbackListener != null) {
                status = TransferStatus.instance(TransferStatus.TransferType.GET, irodsSourceFile.getAbsolutePath(), targetLocalFile.getAbsolutePath(), "", 0L, 0L, 0, 0, operativeTransferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_INITIATION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
                transferStatusCallbackListener.overallStatusCallback(status);
            }
            this.transferOperationsHelper.processGetOfSingleFile(irodsSourceFile, targetLocalFile, transferStatusCallbackListener, operativeTransferControlBlock);
            if (transferStatusCallbackListener != null) {
                status = TransferStatus.instance(TransferStatus.TransferType.GET, irodsSourceFile.getAbsolutePath(), targetLocalFile.getAbsolutePath(), "", 0L, 0L, 0, 0, operativeTransferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_COMPLETION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
                transferStatusCallbackListener.overallStatusCallback(status);
            }
        }
    }

    @Override
    public void getOperation(String irodsSourceFileAbsolutePath, String targetLocalFileAbsolutePath, String sourceResourceName, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws FileNotFoundException, OverwriteException, JargonException {
        if (irodsSourceFileAbsolutePath == null || irodsSourceFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("irodsSourceFileAbsolutePath is null or empty");
        }
        if (targetLocalFileAbsolutePath == null || targetLocalFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("targetLocalFileAbsolutePath is null or empty");
        }
        if (sourceResourceName == null) {
            throw new IllegalArgumentException("sourceResourceName is null");
        }
        MiscIRODSUtils.checkPathSizeForMax(irodsSourceFileAbsolutePath);
        log.info("get operation, irods source file is: {}", (Object)irodsSourceFileAbsolutePath);
        log.info("  local file for get: {}", (Object)targetLocalFileAbsolutePath);
        log.info("   specifiying resource:", (Object)sourceResourceName);
        File localFile = new File(targetLocalFileAbsolutePath);
        IRODSFile irodsSourceFile = this.getIRODSFileFactory().instanceIRODSFile(irodsSourceFileAbsolutePath);
        irodsSourceFile.setResource(sourceResourceName);
        this.getOperation(irodsSourceFile, localFile, transferStatusCallbackListener, transferControlBlock);
    }

    private void processExceptionDuringGetOperation(IRODSFile irodsSourceFile, File targetLocalFile, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock, JargonException je) throws JargonException {
        log.error("exception in transfer", (Throwable)je);
        if (transferStatusCallbackListener == null) {
            log.warn("exception will be re-thrown, as there is no status callback listener");
            throw je;
        }
        log.warn("exception will be passed back to existing callback listener");
        TransferStatus status = TransferStatus.instanceForException(TransferStatus.TransferType.GET, irodsSourceFile.getAbsolutePath(), targetLocalFile.getAbsolutePath(), "", targetLocalFile.length(), targetLocalFile.length(), transferControlBlock.getTotalFilesTransferredSoFar(), transferControlBlock.getTotalFilesSkippedSoFar(), transferControlBlock.getTotalFilesToTransfer(), je, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
        transferStatusCallbackListener.statusCallback(status);
    }

    private void getOperationWhenSourceFileIsDirectory(IRODSFile irodsSourceFile, File targetLocalFile, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws FileNotFoundException, JargonException {
        log.info("getOperationWhenSourceFileIsDirectory");
        log.info("this get operation is recursive");
        if (targetLocalFile.exists() && !targetLocalFile.isDirectory()) {
            String msg = "attempt to put a collection (recursively) to a target local file that is not a directory";
            log.error(msg);
            throw new JargonException(msg);
        }
        String thisDirName = irodsSourceFile.getName();
        log.info("this dir name, will be the new parent directory in the local file system:{}", (Object)thisDirName);
        File newParentDirectory = new File(targetLocalFile.getAbsolutePath(), thisDirName);
        boolean result = newParentDirectory.mkdir();
        if (!result) {
            log.warn("mkdirs for {} did not return success", (Object)newParentDirectory.getAbsolutePath());
        }
        log.debug("new parent directory created locally:{}", (Object)newParentDirectory.getAbsolutePath());
        this.transferOperationsHelper.recursivelyGet(irodsSourceFile, newParentDirectory, transferStatusCallbackListener, transferControlBlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putOperation(File sourceFile, IRODSFile targetIrodsFile, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws FileNotFoundException, JargonException {
        TransferControlBlock operativeTransferControlBlock = this.buildTransferControlBlockAndOptionsBasedOnParameters(transferControlBlock);
        IRODSAccount reroutedAccount = null;
        try {
            if (targetIrodsFile == null) {
                throw new JargonException("targetIrodsFile is null");
            }
            if (sourceFile == null) {
                throw new JargonException("sourceFile is null");
            }
            log.info("put operation for source: {}", (Object)sourceFile.getAbsolutePath());
            log.info(" to target: {}", (Object)targetIrodsFile.getAbsolutePath());
            if (targetIrodsFile.getResource().isEmpty()) {
                log.debug("no resource provided, substitute the resource from the irodsAccount");
                targetIrodsFile.setResource(MiscIRODSUtils.getDefaultIRODSResourceFromAccountIfFileInZone(targetIrodsFile.getAbsolutePath(), this.getIRODSAccount()));
            }
            log.info("  resource:{}", (Object)targetIrodsFile.getResource());
            if (operativeTransferControlBlock.getTransferOptions().isAllowPutGetResourceRedirects() && this.getIRODSServerProperties().isSupportsConnectionRerouting()) {
                log.info("redirects are available, check to see if I need to redirect to a resource server");
                String detectedHost = this.dataObjectAO.getHostForPutOperation(targetIrodsFile.getAbsolutePath(), targetIrodsFile.getResource());
                if (detectedHost == null || detectedHost.equals("thisAddress")) {
                    log.info("using given resource connection");
                } else {
                    log.info("rerouting to host:{}", (Object)detectedHost);
                    reroutedAccount = IRODSAccount.instanceForReroutedHost(this.getIRODSAccount(), detectedHost);
                }
            }
            if (reroutedAccount != null) {
                log.info("connection was rerouted");
                DataTransferOperationsImpl reroutedDataTransferOperations = (DataTransferOperationsImpl)this.getIRODSAccessObjectFactory().getDataTransferOperations(reroutedAccount);
                reroutedDataTransferOperations.processPutAfterAnyConnectionRerouting(sourceFile, targetIrodsFile, transferStatusCallbackListener, operativeTransferControlBlock);
            } else {
                log.info("process put with no rerouting");
                this.processPutAfterAnyConnectionRerouting(sourceFile, targetIrodsFile, transferStatusCallbackListener, operativeTransferControlBlock);
            }
        }
        catch (JargonException je) {
            log.warn("unexpected exception in put operation that should have been caught in the transfer handler", (Throwable)je);
            this.processExceptionDuringPutOperation(sourceFile, targetIrodsFile, transferStatusCallbackListener, operativeTransferControlBlock, je);
        }
        catch (Throwable e) {
            log.warn("unexepected exception occurred in transfer, not caught in transfer code, will wrap in a JargonException and process", e);
            this.processExceptionDuringPutOperation(sourceFile, targetIrodsFile, transferStatusCallbackListener, operativeTransferControlBlock, new JargonException(e));
        }
        finally {
            if (reroutedAccount != null) {
                log.info("closing re-routed account");
                this.getIRODSAccessObjectFactory().closeSessionAndEatExceptions(reroutedAccount);
            }
        }
    }

    protected void processPutAfterAnyConnectionRerouting(File sourceFile, IRODSFile targetIrodsFile, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock operativeTransferControlBlock) throws JargonException {
        if (sourceFile.isDirectory()) {
            this.preCountLocalFilesBeforeTransfer(sourceFile, operativeTransferControlBlock);
            this.putWhenSourceFileIsDirectory(sourceFile, targetIrodsFile, transferStatusCallbackListener, operativeTransferControlBlock);
        } else {
            TransferStatus status;
            operativeTransferControlBlock.setTotalFilesToTransfer(1);
            StringBuilder targetIrodsPathBuilder = new StringBuilder();
            if (targetIrodsFile.exists() && targetIrodsFile.isDirectory()) {
                log.info("target is a directory, source is file");
                targetIrodsPathBuilder.append(targetIrodsFile.getAbsolutePath());
                targetIrodsPathBuilder.append("/");
                targetIrodsPathBuilder.append(sourceFile.getName());
            } else if (targetIrodsFile.getParentFile().exists() && targetIrodsFile.getParentFile().isDirectory()) {
                log.info("treating target as a file, using the whole path");
                targetIrodsPathBuilder.append(targetIrodsFile.getAbsolutePath());
            }
            String callbackTargetIrodsPath = targetIrodsPathBuilder.toString();
            log.info("computed callbackTargetIrodsPath:{}", (Object)callbackTargetIrodsPath);
            if (transferStatusCallbackListener != null) {
                status = TransferStatus.instance(TransferStatus.TransferType.PUT, sourceFile.getAbsolutePath(), callbackTargetIrodsPath, "", operativeTransferControlBlock.getTotalBytesToTransfer(), 0L, operativeTransferControlBlock.getTotalFilesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesSkippedSoFar(), operativeTransferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_INITIATION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
                transferStatusCallbackListener.overallStatusCallback(status);
            }
            if (operativeTransferControlBlock.isCancelled()) {
                log.info("operation has been cancelled");
                if (transferStatusCallbackListener != null) {
                    status = TransferStatus.instance(TransferStatus.TransferType.PUT, sourceFile.getAbsolutePath(), callbackTargetIrodsPath, "", operativeTransferControlBlock.getTotalBytesToTransfer(), 0L, operativeTransferControlBlock.getTotalFilesSkippedSoFar(), operativeTransferControlBlock.getTotalFilesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.CANCELLED, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
                    transferStatusCallbackListener.overallStatusCallback(status);
                }
                return;
            }
            this.transferOperationsHelper.processPutOfSingleFile(sourceFile, targetIrodsFile, transferStatusCallbackListener, operativeTransferControlBlock);
            if (transferStatusCallbackListener != null) {
                status = TransferStatus.instance(TransferStatus.TransferType.PUT, sourceFile.getAbsolutePath(), callbackTargetIrodsPath, "", operativeTransferControlBlock.getTotalBytesToTransfer(), operativeTransferControlBlock.getTotalBytesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesSkippedSoFar(), operativeTransferControlBlock.getTotalFilesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_COMPLETION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
                transferStatusCallbackListener.overallStatusCallback(status);
            }
        }
    }

    private TransferControlBlock buildTransferControlBlockAndOptionsBasedOnParameters(TransferControlBlock transferControlBlock) throws JargonException {
        TransferControlBlock operativeTransferControlBlock = transferControlBlock;
        if (operativeTransferControlBlock == null) {
            log.info("creating default transfer control block, none was supplied and a callback listener is set");
            operativeTransferControlBlock = DefaultTransferControlBlock.instance();
        }
        if (operativeTransferControlBlock.getTransferOptions() == null) {
            log.info("no transfer options are set, override with defaults");
            operativeTransferControlBlock.setTransferOptions(this.getIRODSSession().buildTransferOptionsBasedOnJargonProperties());
        }
        return operativeTransferControlBlock;
    }

    @Override
    public void putOperation(String sourceFileAbsolutePath, String targetIrodsFileAbsolutePath, String targetResourceName, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws JargonException {
        if (sourceFileAbsolutePath == null || sourceFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("sourceFileAbsolutePath is null or empty");
        }
        if (targetIrodsFileAbsolutePath == null || targetIrodsFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("targetIrodsFileAbsolutePath is null or empty");
        }
        if (targetResourceName == null) {
            throw new IllegalArgumentException("targetResourceName is null");
        }
        if (targetResourceName.isEmpty()) {
            targetResourceName = this.getIRODSAccount().getDefaultStorageResource();
        }
        MiscIRODSUtils.checkPathSizeForMax(targetIrodsFileAbsolutePath);
        log.info("put operation for source: {}", (Object)sourceFileAbsolutePath);
        log.info(" to target: {}", (Object)targetIrodsFileAbsolutePath);
        log.info("  resource:{}", (Object)targetResourceName);
        File sourceFile = new File(sourceFileAbsolutePath);
        IRODSFile targetFile = this.getIRODSFileFactory().instanceIRODSFile(targetIrodsFileAbsolutePath);
        targetFile.setResource(targetResourceName);
        this.putOperation(sourceFile, targetFile, transferStatusCallbackListener, transferControlBlock);
    }

    private void preCountLocalFilesBeforeTransfer(File sourceFile, TransferControlBlock operativeTransferControlBlock) {
        if (operativeTransferControlBlock != null) {
            int fileCount = LocalFileUtils.countFilesInDirectory(sourceFile);
            log.info("put will transfer {} files)", (Object)fileCount);
            operativeTransferControlBlock.setTotalFilesToTransfer(fileCount);
        }
    }

    private void processExceptionDuringPutOperation(File sourceFile, IRODSFile targetIrodsFile, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock, JargonException je) throws JargonException {
        log.error("exception in transfer", (Throwable)je);
        transferControlBlock.reportErrorInTransfer();
        if (transferStatusCallbackListener == null) {
            log.warn("exception will be re-thrown, as there is no status callback listener");
            throw je;
        }
        log.warn("exception will be passed back to existing callback listener");
        TransferStatus status = TransferStatus.instanceForException(TransferStatus.TransferType.PUT, sourceFile.getAbsolutePath(), targetIrodsFile.getAbsolutePath(), "", sourceFile.length(), sourceFile.length(), transferControlBlock.getTotalFilesTransferredSoFar(), transferControlBlock.getTotalFilesSkippedSoFar(), transferControlBlock.getTotalFilesToTransfer(), je, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
        transferStatusCallbackListener.overallStatusCallback(status);
    }

    private void putWhenSourceFileIsDirectory(File sourceFile, IRODSFile targetIrodsFile, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws JargonException {
        TransferStatus status;
        log.info("this put operation is recursive");
        if (targetIrodsFile.exists() && !targetIrodsFile.isDirectory()) {
            String msg = "attempt to put a collection (recursively) to a target iRODS file that is not a collection";
            log.error(msg);
            throw new JargonException(msg);
        }
        if (!targetIrodsFile.getParentFile().exists()) {
            throw new FileNotFoundException("target parent file does not exist");
        }
        if (!targetIrodsFile.getParentFile().canWrite()) {
            throw new CatNoAccessException("cannot write irodsFile file");
        }
        targetIrodsFile.mkdirs();
        String thisDirName = sourceFile.getName();
        log.info("this dir name, will be the new parent directory in iRODS:{}", (Object)thisDirName);
        IRODSFile newIrodsParentDirectory = this.getIRODSFileFactory().instanceIRODSFile(targetIrodsFile.getAbsolutePath(), thisDirName);
        newIrodsParentDirectory.setResource(targetIrodsFile.getResource());
        if (transferStatusCallbackListener != null) {
            status = TransferStatus.instance(TransferStatus.TransferType.PUT, sourceFile.getAbsolutePath(), newIrodsParentDirectory.getAbsolutePath(), "", transferControlBlock.getTotalBytesToTransfer(), transferControlBlock.getTotalBytesTransferredSoFar(), transferControlBlock.getTotalFilesTransferredSoFar(), transferControlBlock.getTotalFilesSkippedSoFar(), transferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_INITIATION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
            transferStatusCallbackListener.overallStatusCallback(status);
        }
        if (transferControlBlock.isCancelled()) {
            log.info("operation has been cancelled");
            if (transferStatusCallbackListener != null) {
                status = TransferStatus.instance(TransferStatus.TransferType.PUT, sourceFile.getAbsolutePath(), newIrodsParentDirectory.getAbsolutePath(), "", transferControlBlock.getTotalBytesToTransfer(), transferControlBlock.getTotalBytesTransferredSoFar(), transferControlBlock.getTotalFilesSkippedSoFar(), transferControlBlock.getTotalFilesTransferredSoFar(), transferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.CANCELLED, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
                transferStatusCallbackListener.overallStatusCallback(status);
            }
            return;
        }
        try {
            newIrodsParentDirectory.mkdirs();
        }
        catch (Exception e) {
            log.error("exeption in mkdir of: {}", (Object)newIrodsParentDirectory.getAbsolutePath());
            throw new JargonException(e);
        }
        this.transferOperationsHelper.recursivelyPut(sourceFile, newIrodsParentDirectory, transferStatusCallbackListener, transferControlBlock);
        if (transferStatusCallbackListener != null) {
            if (transferControlBlock.isCancelled() || transferControlBlock.isPaused()) {
                TransferStatus.TransferState transferState;
                if (transferControlBlock.shouldTransferBeAbandonedDueToNumberOfErrors()) {
                    log.warn("transfer state is failure");
                    transferState = TransferStatus.TransferState.FAILURE;
                } else {
                    log.info("transferState is cancelled");
                    transferState = TransferStatus.TransferState.CANCELLED;
                }
                TransferStatus status2 = TransferStatus.instance(TransferStatus.TransferType.PUT, sourceFile.getAbsolutePath(), newIrodsParentDirectory.getAbsolutePath(), "", transferControlBlock.getTotalBytesToTransfer(), transferControlBlock.getTotalBytesTransferredSoFar(), transferControlBlock.getTotalFilesTransferredSoFar(), transferControlBlock.getTotalFilesSkippedSoFar(), transferControlBlock.getTotalFilesToTransfer(), transferState, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
                transferStatusCallbackListener.overallStatusCallback(status2);
            } else {
                status = TransferStatus.instance(TransferStatus.TransferType.PUT, sourceFile.getAbsolutePath(), newIrodsParentDirectory.getAbsolutePath(), "", transferControlBlock.getTotalBytesToTransfer(), transferControlBlock.getTotalBytesTransferredSoFar(), transferControlBlock.getTotalFilesTransferredSoFar(), transferControlBlock.getTotalFilesSkippedSoFar(), transferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_COMPLETION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
                transferStatusCallbackListener.overallStatusCallback(status);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void replicate(String irodsFileAbsolutePath, String targetResource, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws JargonException {
        if (irodsFileAbsolutePath == null || irodsFileAbsolutePath.isEmpty()) {
            throw new JargonException("irodsFileAbsolutePath is null or empty");
        }
        if (targetResource == null || targetResource.isEmpty()) {
            throw new JargonException("target resource is null or empty");
        }
        MiscIRODSUtils.checkPathSizeForMax(irodsFileAbsolutePath);
        log.info("replicate operation for source: {}", (Object)irodsFileAbsolutePath);
        log.info(" to target resource: {}", (Object)targetResource);
        TransferControlBlock operativeTransferControlBlock = this.buildTransferControlBlockAndOptionsBasedOnParameters(transferControlBlock);
        IRODSFileFactory irodsFileFactory = this.getIRODSFileFactory();
        IRODSFile sourceFile = irodsFileFactory.instanceIRODSFile(irodsFileAbsolutePath);
        if (sourceFile.isDirectory()) {
            TransferStatus status;
            log.info("this replication operation is recursive");
            this.preCountIrodsFilesBeforeTransfer(irodsFileAbsolutePath, operativeTransferControlBlock);
            if (transferStatusCallbackListener != null) {
                status = TransferStatus.instance(TransferStatus.TransferType.REPLICATE, sourceFile.getAbsolutePath(), "", targetResource, operativeTransferControlBlock.getTotalBytesToTransfer(), operativeTransferControlBlock.getTotalBytesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesSkippedSoFar(), operativeTransferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_INITIATION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
                transferStatusCallbackListener.overallStatusCallback(status);
            }
            try {
                this.transferOperationsHelper.recursivelyReplicate(sourceFile, targetResource, transferStatusCallbackListener, operativeTransferControlBlock);
                if (transferStatusCallbackListener == null) return;
                status = TransferStatus.instance(TransferStatus.TransferType.REPLICATE, sourceFile.getAbsolutePath(), "", targetResource, operativeTransferControlBlock.getTotalBytesToTransfer(), operativeTransferControlBlock.getTotalBytesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesSkippedSoFar(), operativeTransferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_COMPLETION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
                transferStatusCallbackListener.overallStatusCallback(status);
                return;
            }
            catch (Exception e) {
                log.error("error during processing of a replication", (Throwable)e);
                if (transferStatusCallbackListener != null) {
                    TransferStatus status2 = TransferStatus.instanceForException(TransferStatus.TransferType.REPLICATE, sourceFile.getAbsolutePath(), "", targetResource, operativeTransferControlBlock.getTotalBytesToTransfer(), operativeTransferControlBlock.getTotalBytesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesSkippedSoFar(), operativeTransferControlBlock.getTotalFilesToTransfer(), e, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
                    transferStatusCallbackListener.overallStatusCallback(status2);
                    return;
                }
                log.error("no callback listener, rethrow exception as a jargon exception");
                throw new JargonException("exception during replication, rethrown as a JargonException", e);
            }
        } else {
            TransferStatus status;
            operativeTransferControlBlock.setTotalFilesToTransfer(1);
            if (transferStatusCallbackListener != null) {
                status = TransferStatus.instance(TransferStatus.TransferType.REPLICATE, sourceFile.getAbsolutePath(), "", targetResource, operativeTransferControlBlock.getTotalBytesToTransfer(), operativeTransferControlBlock.getTotalBytesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesSkippedSoFar(), operativeTransferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_INITIATION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
                transferStatusCallbackListener.overallStatusCallback(status);
            }
            this.processReplicationOfSingleFile(irodsFileAbsolutePath, targetResource, transferStatusCallbackListener, operativeTransferControlBlock);
            if (transferStatusCallbackListener == null) return;
            status = TransferStatus.instance(TransferStatus.TransferType.REPLICATE, sourceFile.getAbsolutePath(), "", targetResource, operativeTransferControlBlock.getTotalBytesToTransfer(), operativeTransferControlBlock.getTotalBytesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesSkippedSoFar(), operativeTransferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_COMPLETION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
            transferStatusCallbackListener.overallStatusCallback(status);
        }
    }

    @Override
    public void copy(String irodsSourceFileAbsolutePath, String targetResource, String irodsTargetFileAbsolutePath, TransferStatusCallbackListener transferStatusCallbackListener, boolean force, TransferControlBlock transferControlBlock) throws OverwriteException, DataNotFoundException, JargonException {
        if (irodsSourceFileAbsolutePath == null || irodsSourceFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("irodsSourceFileAbsolutePath is null or empty");
        }
        if (irodsTargetFileAbsolutePath == null || irodsTargetFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("irodsTargetFileAbsolutePath is null or empty");
        }
        if (targetResource == null) {
            throw new IllegalArgumentException("target resource is null");
        }
        MiscIRODSUtils.checkPathSizeForMax(irodsSourceFileAbsolutePath);
        MiscIRODSUtils.checkPathSizeForMax(irodsTargetFileAbsolutePath);
        log.info("copy operation for source: {}", (Object)irodsSourceFileAbsolutePath);
        log.info("to target file:{}", (Object)irodsTargetFileAbsolutePath);
        log.info(" to target resource: {}", (Object)targetResource);
        TransferControlBlock operativeTransferControlBlock = this.buildTransferControlBlockAndOptionsBasedOnParameters(transferControlBlock);
        if (transferStatusCallbackListener != null && transferControlBlock == null) {
            log.info("creating default transfer control block, none was supplied and a callback listener is set");
            operativeTransferControlBlock = DefaultTransferControlBlock.instance();
        }
        IRODSFileFactory irodsFileFactory = this.getIRODSFileFactory();
        IRODSFile sourceFile = irodsFileFactory.instanceIRODSFile(irodsSourceFileAbsolutePath);
        IRODSFile targetFile = this.getIRODSFileFactory().instanceIRODSFile(irodsTargetFileAbsolutePath);
        if (sourceFile.isDirectory()) {
            this.processCopyWhenSourceIsDir(targetResource, transferStatusCallbackListener, operativeTransferControlBlock, sourceFile, targetFile);
        } else {
            this.processCopyWhenSourceIsAFile(targetResource, transferStatusCallbackListener, operativeTransferControlBlock, sourceFile, targetFile);
        }
    }

    @Override
    public void copy(String irodsSourceFileAbsolutePath, String targetResource, String irodsTargetFileAbsolutePath, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws OverwriteException, DataNotFoundException, JargonException {
        if (irodsSourceFileAbsolutePath == null || irodsSourceFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("irodsSourceFileAbsolutePath is null or empty");
        }
        if (irodsTargetFileAbsolutePath == null || irodsTargetFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("irodsTargetFileAbsolutePath is null or empty");
        }
        if (targetResource == null) {
            throw new IllegalArgumentException("target resource is null");
        }
        MiscIRODSUtils.checkPathSizeForMax(irodsSourceFileAbsolutePath);
        MiscIRODSUtils.checkPathSizeForMax(irodsTargetFileAbsolutePath);
        log.info("copy operation for source: {}", (Object)irodsSourceFileAbsolutePath);
        log.info("to target file:{}", (Object)irodsTargetFileAbsolutePath);
        log.info(" to target resource: {}", (Object)targetResource);
        IRODSFileFactory irodsFileFactory = this.getIRODSFileFactory();
        IRODSFile sourceFile = irodsFileFactory.instanceIRODSFile(irodsSourceFileAbsolutePath);
        IRODSFile targetFile = this.getIRODSFileFactory().instanceIRODSFile(irodsTargetFileAbsolutePath);
        targetFile.setResource(targetResource);
        this.copy(sourceFile, targetFile, transferStatusCallbackListener, transferControlBlock);
    }

    @Override
    public void copy(IRODSFile irodsSourceFile, IRODSFile irodsTargetFile, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws OverwriteException, FileNotFoundException, JargonException {
        if (irodsSourceFile == null) {
            throw new IllegalArgumentException("irodsSourceFile is null");
        }
        if (irodsTargetFile == null) {
            throw new IllegalArgumentException("irodsTargetFile is null");
        }
        log.info("copy operation for source: {}", (Object)irodsSourceFile);
        log.info("to target file:{}", (Object)irodsTargetFile);
        if (irodsTargetFile.getResource().isEmpty()) {
            log.info("target resource empty, use default resource in irods account");
            irodsTargetFile.setResource(this.getIRODSAccount().getDefaultStorageResource());
        }
        log.info(" to target resource: {}", (Object)irodsTargetFile.getResource());
        TransferControlBlock operativeTransferControlBlock = this.buildTransferControlBlockAndOptionsBasedOnParameters(transferControlBlock);
        if (transferStatusCallbackListener != null && transferControlBlock == null) {
            log.info("creating default transfer control block, none was supplied and a callback listener is set");
            operativeTransferControlBlock = this.buildDefaultTransferControlBlockBasedOnJargonProperties();
        }
        if (irodsSourceFile.isDirectory()) {
            this.processCopyWhenSourceIsDir(irodsTargetFile.getResource(), transferStatusCallbackListener, operativeTransferControlBlock, irodsSourceFile, irodsTargetFile);
        } else {
            this.processCopyWhenSourceIsAFile(irodsTargetFile.getResource(), transferStatusCallbackListener, operativeTransferControlBlock, irodsSourceFile, irodsTargetFile);
        }
    }

    private void processCopyWhenSourceIsAFile(String targetResource, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock operativeTransferControlBlock, IRODSFile sourceFile, IRODSFile targetFile) throws OverwriteException, FileNotFoundException, JargonException {
        TransferStatus status;
        if (targetFile.getAbsolutePath().equals(sourceFile.getParent())) {
            log.error("source file is being copied to own parent:{}", (Object)sourceFile.getAbsolutePath());
            throw new DuplicateDataException("attempt to copy source file to its parent");
        }
        if (operativeTransferControlBlock == null) {
            throw new IllegalArgumentException("null operativeTransferControlBlock");
        }
        operativeTransferControlBlock.setTotalFilesToTransfer(1);
        if (targetFile.isDirectory()) {
            targetFile = this.getIRODSFileFactory().instanceIRODSFile(targetFile.getAbsolutePath(), sourceFile.getName());
            targetFile.setResource(targetResource);
            log.info("file name normailzed:{}", (Object)targetFile);
        }
        if (transferStatusCallbackListener != null) {
            status = TransferStatus.instance(TransferStatus.TransferType.COPY, sourceFile.getAbsolutePath(), targetFile.getAbsolutePath(), targetResource, operativeTransferControlBlock.getTotalBytesToTransfer(), operativeTransferControlBlock.getTotalBytesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesSkippedSoFar(), operativeTransferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_INITIATION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
            transferStatusCallbackListener.overallStatusCallback(status);
        }
        this.transferOperationsHelper.processCopyOfSingleFile(sourceFile.getAbsolutePath(), targetResource, targetFile.getAbsolutePath(), transferStatusCallbackListener, operativeTransferControlBlock);
        if (transferStatusCallbackListener != null) {
            status = TransferStatus.instance(TransferStatus.TransferType.COPY, sourceFile.getAbsolutePath(), targetFile.getAbsolutePath(), targetResource, operativeTransferControlBlock.getTotalBytesToTransfer(), operativeTransferControlBlock.getTotalBytesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesSkippedSoFar(), operativeTransferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_COMPLETION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
            transferStatusCallbackListener.overallStatusCallback(status);
        }
    }

    private void processCopyWhenSourceIsDir(String targetResource, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock operativeTransferControlBlock, IRODSFile sourceFile, IRODSFile targetFile) throws OverwriteException, FileNotFoundException, JargonException {
        TransferStatus status;
        log.info("this copy operation is recursive");
        this.preCountIrodsFilesBeforeTransfer(sourceFile.getAbsolutePath(), operativeTransferControlBlock);
        if (targetFile.getAbsolutePath().equals(sourceFile.getParent())) {
            log.error("source file is being copied to own parent:{}", (Object)sourceFile.getAbsolutePath());
            throw new DuplicateDataException("attempt to copy source file to its parent");
        }
        if (targetFile.getAbsolutePath().equals(sourceFile.getAbsolutePath())) {
            log.error("source file is being copied to self:{}", (Object)sourceFile.getAbsolutePath());
            throw new DuplicateDataException("attempt to copy source file to itself");
        }
        if (targetFile.exists() && targetFile.isFile()) {
            targetFile = (IRODSFile)((Object)targetFile.getParentFile());
            log.error("attempt to copy a directory to a file: {}", (Object)targetFile.getAbsolutePath());
            throw new JargonException("attempt to copy a directory to a file");
        }
        targetFile = this.getIRODSFileFactory().instanceIRODSFile(targetFile.getAbsolutePath(), sourceFile.getName());
        log.info("resolved target file with appended source file collection name is: {}", (Object)targetFile.getAbsolutePath());
        targetFile.mkdirs();
        log.info("any necessary subdirs created for target file");
        if (transferStatusCallbackListener != null) {
            status = TransferStatus.instance(TransferStatus.TransferType.COPY, sourceFile.getAbsolutePath(), targetFile.getAbsolutePath(), targetResource, operativeTransferControlBlock.getTotalBytesToTransfer(), operativeTransferControlBlock.getTotalBytesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesSkippedSoFar(), operativeTransferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_INITIATION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
            transferStatusCallbackListener.overallStatusCallback(status);
        }
        this.transferOperationsHelper.recursivelyCopy(sourceFile, targetResource, targetFile.getAbsolutePath(), transferStatusCallbackListener, operativeTransferControlBlock);
        if (transferStatusCallbackListener != null) {
            status = TransferStatus.instance(TransferStatus.TransferType.COPY, sourceFile.getAbsolutePath(), targetFile.getAbsolutePath(), targetResource, operativeTransferControlBlock.getTotalBytesToTransfer(), operativeTransferControlBlock.getTotalBytesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesTransferredSoFar(), operativeTransferControlBlock.getTotalFilesSkippedSoFar(), operativeTransferControlBlock.getTotalFilesToTransfer(), TransferStatus.TransferState.OVERALL_COMPLETION, this.getIRODSAccount().getHost(), this.getIRODSAccount().getZone());
            transferStatusCallbackListener.overallStatusCallback(status);
        }
    }

    private void preCountIrodsFilesBeforeTransfer(String irodsFileAbsolutePath, TransferControlBlock operativeTransferControlBlock) throws FileNotFoundException, JargonException {
        IRODSAccessObjectFactory irodsAccessObjectFactory = this.getIRODSAccessObjectFactory();
        CollectionAO collectionAO = irodsAccessObjectFactory.getCollectionAO(this.getIRODSAccount());
        int fileCount = collectionAO.countAllFilesUnderneathTheGivenCollection(irodsFileAbsolutePath);
        log.info("replication operation for {} files)", (Object)fileCount);
        operativeTransferControlBlock.setTotalFilesToTransfer(fileCount);
    }

    private void processReplicationOfSingleFile(String irodsFileAbsolutePath, String targetResource, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) throws JargonException {
        log.info("replicate single file");
        this.transferOperationsHelper.processReplicationOfSingleFile(irodsFileAbsolutePath, targetResource, transferStatusCallbackListener, transferControlBlock);
    }

    public TransferOperationsHelper getTransferOperationsHelper() {
        return this.transferOperationsHelper;
    }

    public void setTransferOperationsHelper(TransferOperationsHelper transferOperationsHelper) {
        this.transferOperationsHelper = transferOperationsHelper;
    }

    public DataObjectAO getDataObjectAO() {
        return this.dataObjectAO;
    }

    public void setDataObjectAO(DataObjectAO dataObjectAO) {
        this.dataObjectAO = dataObjectAO;
    }
}

