/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.FileNotFoundException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.JargonRuntimeException;
import org.irods.jargon.core.exception.SpecificQueryException;
import org.irods.jargon.core.packinstr.DataObjInpForObjStat;
import org.irods.jargon.core.packinstr.Tag;
import org.irods.jargon.core.pub.CollectionAOImpl;
import org.irods.jargon.core.pub.CollectionAndDataObjectListAndSearchAO;
import org.irods.jargon.core.pub.CollectionListingUtils;
import org.irods.jargon.core.pub.DataObjectAOImpl;
import org.irods.jargon.core.pub.IRODSGenQueryExecutorImpl;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.irods.jargon.core.pub.SpecificQueryAO;
import org.irods.jargon.core.pub.aohelper.CollectionAOHelper;
import org.irods.jargon.core.pub.domain.DataObject;
import org.irods.jargon.core.pub.domain.ObjStat;
import org.irods.jargon.core.pub.domain.UserFilePermission;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.pub.io.IRODSFileSystemAOHelper;
import org.irods.jargon.core.query.AbstractIRODSQueryResultSet;
import org.irods.jargon.core.query.CollectionAndDataObjectListingEntry;
import org.irods.jargon.core.query.GenQueryBuilderException;
import org.irods.jargon.core.query.GenQueryField;
import org.irods.jargon.core.query.IRODSGenQueryBuilder;
import org.irods.jargon.core.query.IRODSGenQueryFromBuilder;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.IRODSQueryResultSet;
import org.irods.jargon.core.query.JargonQueryException;
import org.irods.jargon.core.query.PagingAwareCollectionListing;
import org.irods.jargon.core.query.QueryConditionOperators;
import org.irods.jargon.core.query.RodsGenQueryEnum;
import org.irods.jargon.core.query.SpecificQuery;
import org.irods.jargon.core.query.SpecificQueryResultSet;
import org.irods.jargon.core.utils.IRODSDataConversionUtil;
import org.irods.jargon.core.utils.MiscIRODSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionAndDataObjectListAndSearchAOImpl
extends IRODSGenericAO
implements CollectionAndDataObjectListAndSearchAO {
    private SpecificQueryAO specificQueryAO;
    public static final Logger log = LoggerFactory.getLogger(CollectionAndDataObjectListAndSearchAOImpl.class);

    protected CollectionAndDataObjectListAndSearchAOImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
        try {
            this.specificQueryAO = this.getIRODSAccessObjectFactory().getSpecificQueryAO(this.getIRODSAccount());
        }
        catch (SpecificQueryException sqe) {
            log.warn("specific query is not supported on this server");
            this.specificQueryAO = null;
        }
    }

    @Override
    public CollectionAndDataObjectListingEntry getCollectionAndDataObjectListingEntryAtGivenAbsolutePath(String absolutePath) throws FileNotFoundException, JargonException {
        log.info("getCollectionAndDataObjectListingEntryAtGivenAbsolutePath()");
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException("absolutePath is null or empty");
        }
        ObjStat objStat = this.retrieveObjectStatForPath(absolutePath.trim());
        MiscIRODSUtils.evaluateSpecCollSupport(objStat);
        IRODSFile entryFile = this.getIRODSFileFactory().instanceIRODSFile(absolutePath);
        CollectionAndDataObjectListingEntry entry = new CollectionAndDataObjectListingEntry();
        entry.setParentPath(entryFile.getParent());
        if (objStat.getObjectType() == CollectionAndDataObjectListingEntry.ObjectType.DATA_OBJECT || objStat.getObjectType() == CollectionAndDataObjectListingEntry.ObjectType.LOCAL_FILE) {
            entry.setPathOrName(entryFile.getName());
        } else {
            entry.setPathOrName(absolutePath);
        }
        entry.setCreatedAt(objStat.getCreatedAt());
        entry.setModifiedAt(objStat.getModifiedAt());
        entry.setDataSize(objStat.getObjSize());
        entry.setId(objStat.getDataId());
        entry.setObjectType(objStat.getObjectType());
        entry.setOwnerName(objStat.getOwnerName());
        entry.setOwnerZone(MiscIRODSUtils.getZoneInPath(absolutePath));
        entry.setSpecColType(objStat.getSpecColType());
        entry.setSpecialObjectPath(objStat.getObjectPath());
        log.info("created entry for path as: {}", (Object)entry);
        return entry;
    }

    @Override
    public PagingAwareCollectionListing listDataObjectsAndCollectionsUnderPathProducingPagingAwareCollectionListing(String absolutePathToParent) throws FileNotFoundException, JargonException {
        log.info("listDataObjectsAndCollectionsUnderPathProducingPagingAwareCollectionListing()");
        if (absolutePathToParent == null || absolutePathToParent.isEmpty()) {
            throw new IllegalArgumentException("absolutePathToParent is null or empty");
        }
        log.info("absolutePath:{}", (Object)absolutePathToParent);
        PagingAwareCollectionListing pagingAwareCollectionListing = new PagingAwareCollectionListing();
        pagingAwareCollectionListing.setPageSizeUtilized(this.getJargonProperties().getMaxFilesAndDirsQueryMax());
        List<CollectionAndDataObjectListingEntry> entries = null;
        ObjStat objStat = null;
        CollectionListingUtils collectionListingUtils = new CollectionListingUtils(this);
        try {
            objStat = this.retrieveObjectStatForPath(absolutePathToParent);
        }
        catch (FileNotFoundException fnf) {
            log.info("didnt find an objStat for the path, account for cases where there are strict acls and give Jargon a chance to drill down to a place where the user has permissions");
            entries = collectionListingUtils.handleNoListingUnderRootOrHomeByLookingForPublicAndHome(absolutePathToParent);
            pagingAwareCollectionListing.setCollectionAndDataObjectListingEntries(entries);
            pagingAwareCollectionListing.setCollectionsComplete(true);
            pagingAwareCollectionListing.setCollectionsCount(entries.size());
            return pagingAwareCollectionListing;
        }
        MiscIRODSUtils.evaluateSpecCollSupport(objStat);
        List<CollectionAndDataObjectListingEntry> queriedEntries = collectionListingUtils.listCollectionsUnderPath(objStat, 0);
        if (queriedEntries.isEmpty()) {
            log.info("no child collections");
            pagingAwareCollectionListing.setCollectionsComplete(true);
            pagingAwareCollectionListing.setCollectionsCount(0);
            pagingAwareCollectionListing.setCollectionsOffset(0);
        } else {
            log.info("adding child collections");
            pagingAwareCollectionListing.setCollectionsComplete(queriedEntries.get(queriedEntries.size() - 1).isLastResult());
            pagingAwareCollectionListing.setCollectionsCount(queriedEntries.get(queriedEntries.size() - 1).getCount());
            pagingAwareCollectionListing.setCollectionsTotalRecords(queriedEntries.get(0).getTotalRecords());
            pagingAwareCollectionListing.getCollectionAndDataObjectListingEntries().addAll(queriedEntries);
        }
        queriedEntries = collectionListingUtils.listDataObjectsUnderPath(objStat, 0);
        if (queriedEntries.isEmpty()) {
            log.info("no child data objects");
            pagingAwareCollectionListing.setDataObjectsComplete(true);
            pagingAwareCollectionListing.setDataObjectsCount(0);
            pagingAwareCollectionListing.setDataObjectsOffset(0);
        } else {
            log.info("adding child data objects");
            pagingAwareCollectionListing.setDataObjectsComplete(queriedEntries.get(queriedEntries.size() - 1).isLastResult());
            pagingAwareCollectionListing.setDataObjectsCount(queriedEntries.get(queriedEntries.size() - 1).getCount());
            pagingAwareCollectionListing.setDataObjectsTotalRecords(queriedEntries.get(0).getTotalRecords());
            pagingAwareCollectionListing.getCollectionAndDataObjectListingEntries().addAll(queriedEntries);
        }
        log.info("pagingAwareCollectionListing:{}", (Object)pagingAwareCollectionListing);
        return pagingAwareCollectionListing;
    }

    @Override
    public List<CollectionAndDataObjectListingEntry> listDataObjectsAndCollectionsUnderPath(String absolutePathToParent) throws FileNotFoundException, JargonException {
        ObjStat objStat;
        if (absolutePathToParent == null || absolutePathToParent.isEmpty()) {
            throw new IllegalArgumentException("absolutePathToParent is null or empty");
        }
        CollectionListingUtils collectionListingUtils = new CollectionListingUtils(this);
        try {
            objStat = this.retrieveObjectStatForPath(absolutePathToParent);
        }
        catch (FileNotFoundException fnf) {
            log.info("didn't find an objStat for the path, account for cases where there are strict acls and give Jargon a chance to drill down to a place where the user has permissions");
            return collectionListingUtils.handleNoListingUnderRootOrHomeByLookingForPublicAndHome(absolutePathToParent);
        }
        MiscIRODSUtils.evaluateSpecCollSupport(objStat);
        ArrayList<CollectionAndDataObjectListingEntry> entries = new ArrayList<CollectionAndDataObjectListingEntry>();
        entries.addAll(collectionListingUtils.listCollectionsUnderPath(objStat, 0));
        entries.addAll(collectionListingUtils.listDataObjectsUnderPath(objStat, 0));
        return entries;
    }

    @Override
    public List<CollectionAndDataObjectListingEntry> listDataObjectsAndCollectionsUnderPath(ObjStat objStat) throws FileNotFoundException, JargonException {
        log.info("listDataObjectsAndCollectionsUnderPath(");
        if (objStat == null) {
            throw new IllegalArgumentException("objStat  is null");
        }
        log.info("objStat:{}", (Object)objStat);
        CollectionListingUtils collectionListingUtils = new CollectionListingUtils(this);
        ArrayList<CollectionAndDataObjectListingEntry> entries = new ArrayList<CollectionAndDataObjectListingEntry>();
        entries.addAll(collectionListingUtils.listCollectionsUnderPath(objStat, 0));
        entries.addAll(collectionListingUtils.listDataObjectsUnderPath(objStat, 0));
        return entries;
    }

    @Override
    public List<CollectionAndDataObjectListingEntry> listDataObjectsAndCollectionsUnderPathWithPermissions(String absolutePathToParent) throws FileNotFoundException, JargonException {
        ObjStat objStat;
        if (absolutePathToParent == null) {
            throw new IllegalArgumentException("absolutePathToParent is null");
        }
        if (absolutePathToParent.isEmpty()) {
            throw new IllegalArgumentException("absolutePathToParent is null");
        }
        CollectionListingUtils collectionListingUtils = new CollectionListingUtils(this);
        try {
            objStat = this.retrieveObjectStatForPath(absolutePathToParent);
        }
        catch (FileNotFoundException fnf) {
            log.info("didnt find an objStat for the path, account for cases where there are strict acls and give Jargon a chance to drill down to a place where the user has permissions");
            return collectionListingUtils.handleNoListingUnderRootOrHomeByLookingForPublicAndHome(absolutePathToParent);
        }
        MiscIRODSUtils.evaluateSpecCollSupport(objStat);
        List<CollectionAndDataObjectListingEntry> entries = this.listCollectionsUnderPathWithPermissionsCheckingIfSpecQueryUsed(absolutePathToParent, 0, objStat);
        entries.addAll(this.listDataObjectsUnderPathWithPermissionsCheckingIfSpecQueryUsed(absolutePathToParent, 0, objStat));
        return entries;
    }

    @Override
    public int countDataObjectsAndCollectionsUnderPath(String absolutePathToParent) throws FileNotFoundException, JargonException {
        if (absolutePathToParent == null) {
            throw new IllegalArgumentException("absolutePathToParent is null");
        }
        log.info("countDataObjectsAndCollectionsUnder: {}", (Object)absolutePathToParent);
        String myPath = MiscIRODSUtils.checkPathSizeForMax(absolutePathToParent);
        ObjStat objStat = this.retrieveObjectStatForPath(myPath);
        MiscIRODSUtils.evaluateSpecCollSupport(objStat);
        String effectiveAbsolutePath = MiscIRODSUtils.determineAbsolutePathBasedOnCollTypeInObjectStat(objStat);
        log.info("determined effectiveAbsolutePathToBe:{}", (Object)effectiveAbsolutePath);
        if (!objStat.isSomeTypeOfCollection()) {
            log.error("this is a file, not a directory, and therefore I cannot get a count of the children: {}", (Object)absolutePathToParent);
            throw new JargonException("attempting to count children under a file at path:" + absolutePathToParent);
        }
        return this.queryDataObjectCountsUnderPath(effectiveAbsolutePath) + this.queryCollectionCountsUnderPath(effectiveAbsolutePath);
    }

    @Override
    public int countDataObjectsUnderPath(String absolutePathToParent) throws FileNotFoundException, JargonException {
        if (absolutePathToParent == null) {
            throw new IllegalArgumentException("absolutePathToParent is null");
        }
        log.info("countDataObjectsAndCollectionsUnder: {}", (Object)absolutePathToParent);
        String myPath = MiscIRODSUtils.checkPathSizeForMax(absolutePathToParent);
        ObjStat objStat = this.retrieveObjectStatForPath(myPath);
        MiscIRODSUtils.evaluateSpecCollSupport(objStat);
        String effectiveAbsolutePath = MiscIRODSUtils.determineAbsolutePathBasedOnCollTypeInObjectStat(objStat);
        log.info("determined effectiveAbsolutePathToBe:{}", (Object)effectiveAbsolutePath);
        if (!objStat.isSomeTypeOfCollection()) {
            log.error("this is a file, not a directory, and therefore I cannot get a count of the children: {}", (Object)absolutePathToParent);
            throw new JargonException("attempting to count children under a file at path:" + absolutePathToParent);
        }
        return this.queryDataObjectCountsUnderPath(effectiveAbsolutePath);
    }

    private int queryDataObjectCountsUnderPath(String effectiveAbsolutePath) throws JargonException, DataNotFoundException {
        IRODSQueryResultSet resultSet;
        IRODSGenQueryExecutorImpl irodsGenQueryExecutor = new IRODSGenQueryExecutorImpl(this.getIRODSSession(), this.getIRODSAccount());
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
        try {
            builder.addSelectAsAgregateGenQueryValue(RodsGenQueryEnum.COL_COLL_NAME, GenQueryField.SelectFieldTypes.COUNT).addSelectAsAgregateGenQueryValue(RodsGenQueryEnum.COL_DATA_NAME, GenQueryField.SelectFieldTypes.COUNT).addConditionAsGenQueryField(RodsGenQueryEnum.COL_COLL_NAME, QueryConditionOperators.EQUAL, effectiveAbsolutePath).addConditionAsGenQueryField(RodsGenQueryEnum.COL_DATA_REPL_NUM, QueryConditionOperators.EQUAL, "0");
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(1);
            resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResultInZone(irodsQuery, 0, MiscIRODSUtils.getZoneInPath(effectiveAbsolutePath));
        }
        catch (JargonQueryException e) {
            log.error("query exception for  query:", (Throwable)e);
            throw new JargonException("error in exists query", e);
        }
        catch (GenQueryBuilderException e) {
            log.error("query exception for  query:", (Throwable)e);
            throw new JargonException("error in exists query", e);
        }
        int fileCtr = 0;
        if (resultSet.getResults().size() > 0) {
            fileCtr = IRODSDataConversionUtil.getIntOrZeroFromIRODSValue(resultSet.getFirstResult().getColumn(0));
        }
        return fileCtr;
    }

    private int queryCollectionCountsUnderPath(String effectiveAbsolutePath) throws JargonException, DataNotFoundException {
        IRODSQueryResultSet resultSet;
        IRODSGenQueryExecutorImpl irodsGenQueryExecutor = new IRODSGenQueryExecutorImpl(this.getIRODSSession(), this.getIRODSAccount());
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
        builder = new IRODSGenQueryBuilder(true, null);
        try {
            builder.addSelectAsAgregateGenQueryValue(RodsGenQueryEnum.COL_COLL_TYPE, GenQueryField.SelectFieldTypes.COUNT).addSelectAsAgregateGenQueryValue(RodsGenQueryEnum.COL_COLL_NAME, GenQueryField.SelectFieldTypes.COUNT).addConditionAsGenQueryField(RodsGenQueryEnum.COL_COLL_PARENT_NAME, QueryConditionOperators.EQUAL, effectiveAbsolutePath);
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(1);
            resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResultInZone(irodsQuery, 0, MiscIRODSUtils.getZoneInPath(effectiveAbsolutePath));
        }
        catch (JargonQueryException e) {
            log.error("query exception for  query:", (Throwable)e);
            throw new JargonException("error in exists query", e);
        }
        catch (GenQueryBuilderException e) {
            log.error("query exception for  query:", (Throwable)e);
            throw new JargonException("error in exists query", e);
        }
        int collCtr = 0;
        if (resultSet.getResults().size() > 0) {
            collCtr = IRODSDataConversionUtil.getIntOrZeroFromIRODSValue(resultSet.getFirstResult().getColumn(0));
        }
        return collCtr;
    }

    @Override
    public int countCollectionsUnderPath(String absolutePathToParent) throws FileNotFoundException, JargonException {
        IRODSQueryResultSet resultSet;
        if (absolutePathToParent == null) {
            throw new IllegalArgumentException("absolutePathToParent is null");
        }
        log.info("countDataObjectsAndCollectionsUnder: {}", (Object)absolutePathToParent);
        String myPath = MiscIRODSUtils.checkPathSizeForMax(absolutePathToParent);
        ObjStat objStat = this.retrieveObjectStatForPath(myPath);
        MiscIRODSUtils.evaluateSpecCollSupport(objStat);
        String effectiveAbsolutePath = MiscIRODSUtils.determineAbsolutePathBasedOnCollTypeInObjectStat(objStat);
        log.info("determined effectiveAbsolutePathToBe:{}", (Object)effectiveAbsolutePath);
        if (!objStat.isSomeTypeOfCollection()) {
            log.error("this is a file, not a directory, and therefore I cannot get a count of the children: {}", (Object)absolutePathToParent);
            throw new JargonException("attempting to count children under a file at path:" + absolutePathToParent);
        }
        IRODSGenQueryExecutorImpl irodsGenQueryExecutor = new IRODSGenQueryExecutorImpl(this.getIRODSSession(), this.getIRODSAccount());
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
        try {
            builder.addSelectAsAgregateGenQueryValue(RodsGenQueryEnum.COL_COLL_TYPE, GenQueryField.SelectFieldTypes.COUNT).addSelectAsAgregateGenQueryValue(RodsGenQueryEnum.COL_COLL_NAME, GenQueryField.SelectFieldTypes.COUNT).addConditionAsGenQueryField(RodsGenQueryEnum.COL_COLL_PARENT_NAME, QueryConditionOperators.EQUAL, effectiveAbsolutePath);
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(1);
            resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResultInZone(irodsQuery, 0, MiscIRODSUtils.getZoneInPath(effectiveAbsolutePath));
        }
        catch (JargonQueryException e) {
            log.error("query exception for  query:", (Throwable)e);
            throw new JargonException("error in exists query", e);
        }
        catch (GenQueryBuilderException e) {
            log.error("query exception for  query:", (Throwable)e);
            throw new JargonException("error in exists query", e);
        }
        int collCtr = 0;
        if (resultSet.getResults().size() > 0) {
            collCtr = IRODSDataConversionUtil.getIntOrZeroFromIRODSValue(resultSet.getFirstResult().getColumn(0));
        }
        return collCtr;
    }

    @Override
    public List<CollectionAndDataObjectListingEntry> searchCollectionsBasedOnName(String searchTerm) throws JargonException {
        if (searchTerm == null) {
            throw new IllegalArgumentException("null searchTerm");
        }
        return this.searchCollectionsBasedOnName(searchTerm.trim(), 0);
    }

    @Override
    public List<CollectionAndDataObjectListingEntry> searchCollectionsBasedOnName(String searchTerm, int partialStartIndex) throws JargonException {
        IRODSQueryResultSet resultSet;
        if (searchTerm == null || searchTerm.isEmpty()) {
            throw new IllegalArgumentException("null or empty search term");
        }
        if (partialStartIndex < 0) {
            throw new IllegalArgumentException("partialStartIndex is < 0");
        }
        log.info("searchCollectionsBasedOnName:{}", (Object)searchTerm);
        IRODSGenQueryExecutorImpl irodsGenQueryExecutor = new IRODSGenQueryExecutorImpl(this.getIRODSSession(), this.getIRODSAccount());
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
        try {
            CollectionAOHelper.buildSelectsNeededForCollectionsInCollectionsAndDataObjectsListingEntry(builder);
            builder.addConditionAsGenQueryField(RodsGenQueryEnum.COL_COLL_NAME, QueryConditionOperators.LIKE, "%" + searchTerm);
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(this.getJargonProperties().getMaxFilesAndDirsQueryMax());
            resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(irodsQuery, partialStartIndex);
        }
        catch (JargonQueryException e) {
            log.error("query exception for  query:", (Throwable)e);
            throw new JargonException("error in exists query", e);
        }
        catch (GenQueryBuilderException e) {
            log.error("query exception for  query:", (Throwable)e);
            throw new JargonException("error in exists query", e);
        }
        ArrayList<CollectionAndDataObjectListingEntry> entries = new ArrayList<CollectionAndDataObjectListingEntry>();
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            entries.add(CollectionAOHelper.buildCollectionListEntryFromResultSetRowForCollectionQuery(row, resultSet.getTotalRecords()));
        }
        return entries;
    }

    @Override
    public List<CollectionAndDataObjectListingEntry> listCollectionsUnderPath(String absolutePathToParent, int partialStartIndex) throws FileNotFoundException, JargonException {
        ObjStat objStat;
        log.info("listCollectionsUnderPath()");
        if (absolutePathToParent == null) {
            throw new JargonException("absolutePathToParent is null");
        }
        String path = absolutePathToParent.isEmpty() ? "/" : absolutePathToParent;
        CollectionListingUtils collectionListingUtils = new CollectionListingUtils(this);
        try {
            objStat = this.retrieveObjectStatForPath(path);
        }
        catch (FileNotFoundException fnf) {
            log.info("didnt find an objStat for the path, account for cases where there are strict acls and give Jargon a chance to drill down to a place where the user has permissions");
            return collectionListingUtils.handleNoListingUnderRootOrHomeByLookingForPublicAndHome(path);
        }
        MiscIRODSUtils.evaluateSpecCollSupport(objStat);
        return collectionListingUtils.listCollectionsUnderPath(objStat, partialStartIndex);
    }

    @Override
    public List<CollectionAndDataObjectListingEntry> listCollectionsUnderPathWithPermissions(String absolutePathToParent, int partialStartIndex) throws FileNotFoundException, JargonException {
        if (absolutePathToParent == null) {
            throw new IllegalArgumentException("absolutePathToParent is null");
        }
        ObjStat objStat = this.retrieveObjectStatForPath(absolutePathToParent);
        if (objStat == null) {
            log.error("not objStat found for collection:{}", (Object)absolutePathToParent);
            throw new FileNotFoundException("no ObjStat found for collection");
        }
        MiscIRODSUtils.evaluateSpecCollSupport(objStat);
        return this.listCollectionsUnderPathWithPermissionsCheckingIfSpecQueryUsed(absolutePathToParent, partialStartIndex, objStat);
    }

    private List<CollectionAndDataObjectListingEntry> listCollectionsUnderPathWithPermissionsViaSpecQuery(ObjStat objStat, int offset) throws JargonException, JargonQueryException {
        log.info("listCollectionsUnderPathWithPermissionsViaSpecQuery()");
        String effectiveAbsolutePath = objStat.determineAbsolutePathBasedOnCollTypeInObjectStat();
        ArrayList<String> arguments = new ArrayList<String>(3);
        arguments.add(effectiveAbsolutePath);
        arguments.add(String.valueOf(this.getJargonProperties().getMaxFilesAndDirsQueryMax()));
        arguments.add(String.valueOf(offset));
        SpecificQuery specificQuery = SpecificQuery.instanceArguments("ilsLACollections", arguments, 0, MiscIRODSUtils.getZoneInPath(effectiveAbsolutePath));
        SpecificQueryResultSet specificQueryResultSet = this.specificQueryAO.executeSpecificQueryUsingAlias(specificQuery, this.getJargonProperties().getMaxFilesAndDirsQueryMax(), offset);
        log.info("got result set:{}", (Object)specificQueryResultSet);
        return this.buildCollectionListingWithAccessInfoFromResultSet(specificQueryResultSet, objStat);
    }

    private List<CollectionAndDataObjectListingEntry> listCollectionsUnderPathWithPermissionsCheckingIfSpecQueryUsed(String absolutePathToParent, int partialStartIndex, ObjStat objStat) throws FileNotFoundException, JargonException {
        log.info("listCollectionsUnderPathWithPermissionsCheckingIfSpecQueryUsed()");
        if (absolutePathToParent == null) {
            throw new IllegalArgumentException("absolutePathToParent is null");
        }
        if (objStat == null) {
            throw new IllegalArgumentException("null objStat");
        }
        log.info("checking to see if I can list via specific query");
        if (this.getJargonProperties().isUsingSpecificQueryForCollectionListingsWithPermissions()) {
            log.info("we are using spec query in jargon.properties...");
            if (this.specificQueryAO == null) {
                log.info("...we are bypassing spec query...");
            } else if (this.specificQueryAO.isSpecificQueryToBeBypassed()) {
                log.info("...we are bypassing spec query...");
            } else {
                log.info("attemting to list via specQuery...");
                try {
                    return this.listCollectionsUnderPathWithPermissionsViaSpecQuery(objStat, partialStartIndex);
                }
                catch (JargonException je) {
                    log.error("error executing spec query will do the genQuery fallback");
                }
                catch (JargonQueryException e) {
                    log.error("query exception error executing spec query will do the genQuery fallback");
                }
            }
        }
        return this.listCollectionsUnderPathWithPermissionsUsingGenQuery(absolutePathToParent, partialStartIndex, objStat);
    }

    private List<CollectionAndDataObjectListingEntry> listCollectionsUnderPathWithPermissionsUsingGenQuery(String absolutePathToParent, int partialStartIndex, ObjStat objStat) throws FileNotFoundException, JargonException {
        if (absolutePathToParent == null) {
            throw new IllegalArgumentException("absolutePathToParent is null");
        }
        if (objStat == null) {
            throw new IllegalArgumentException("null objStat");
        }
        String effectiveAbsolutePath = MiscIRODSUtils.determineAbsolutePathBasedOnCollTypeInObjectStat(objStat);
        log.info("determined effectiveAbsolutePathToBe:{}", (Object)effectiveAbsolutePath);
        log.info("listCollectionsUnderPathWithPermissionsForUser for: {}", (Object)effectiveAbsolutePath);
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
        CollectionListingUtils collectionListingUtils = new CollectionListingUtils(this);
        try {
            IRODSFileSystemAOHelper.buildQueryListAllDirsWithUserAccessInfo(effectiveAbsolutePath, builder);
        }
        catch (GenQueryBuilderException e) {
            log.error("query builder exception", (Throwable)e);
            throw new JargonException("error building query", e);
        }
        IRODSQueryResultSet resultSet = collectionListingUtils.queryForPathAndReturnResultSet(effectiveAbsolutePath, builder, partialStartIndex, objStat);
        return this.buildCollectionListingWithAccessInfoFromResultSet(resultSet, objStat);
    }

    private List<CollectionAndDataObjectListingEntry> buildDataObjectListingWithAccessInfoFromResultSet(AbstractIRODSQueryResultSet resultSet, ObjStat objStat) throws JargonException {
        String effectiveAbsolutePath = objStat.determineAbsolutePathBasedOnCollTypeInObjectStat();
        CollectionListingUtils collectionListingUtils = new CollectionListingUtils(this);
        ArrayList<CollectionAndDataObjectListingEntry> files = new ArrayList<CollectionAndDataObjectListingEntry>();
        String currentPath = null;
        String lastPath = "";
        String currentReplNumber = null;
        String lastReplNumber = "";
        CollectionAndDataObjectListingEntry entry = null;
        int lastCount = 0;
        boolean lastRecord = false;
        ArrayList<UserFilePermission> userFilePermissions = new ArrayList<UserFilePermission>();
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            StringBuilder sb = new StringBuilder();
            sb.append(row.getColumn(0));
            sb.append('/');
            sb.append(row.getColumn(1));
            currentPath = sb.toString();
            currentReplNumber = row.getColumn(6);
            lastCount = row.getRecordCount();
            lastRecord = row.isLastResult();
            if (currentPath.equals(lastPath)) {
                if (!currentReplNumber.equals(lastReplNumber)) continue;
                CollectionAOHelper.buildUserFilePermissionForDataObject(userFilePermissions, row, effectiveAbsolutePath, this.getIRODSAccount().getZone());
                continue;
            }
            if (entry != null) {
                entry.setUserFilePermission(userFilePermissions);
                entry.setCount(lastCount - 1);
                collectionListingUtils.augmentCollectionEntryForSpecialCollections(objStat, effectiveAbsolutePath, entry);
                files.add(entry);
            }
            entry = CollectionAOHelper.buildCollectionListEntryFromResultSetRowForDataObjectQuery(row, resultSet.getTotalRecords());
            lastPath = currentPath;
            lastReplNumber = currentReplNumber;
            userFilePermissions = new ArrayList();
            CollectionAOHelper.buildUserFilePermissionForDataObject(userFilePermissions, row, effectiveAbsolutePath, this.getIRODSAccount().getZone());
        }
        if (entry != null) {
            if (lastRecord) {
                entry.setUserFilePermission(userFilePermissions);
                entry.setCount(lastCount);
                entry.setLastResult(lastRecord);
                collectionListingUtils.augmentCollectionEntryForSpecialCollections(objStat, effectiveAbsolutePath, entry);
                files.add(entry);
            } else {
                log.debug("skipping last entry as it may carry over to the next query page");
            }
        }
        return files;
    }

    private List<CollectionAndDataObjectListingEntry> buildCollectionListingWithAccessInfoFromResultSet(AbstractIRODSQueryResultSet resultSet, ObjStat objStat) throws JargonException {
        CollectionListingUtils collectionListingUtils = new CollectionListingUtils(this);
        String effectiveAbsolutePath = objStat.determineAbsolutePathBasedOnCollTypeInObjectStat();
        ArrayList<CollectionAndDataObjectListingEntry> subdirs = new ArrayList<CollectionAndDataObjectListingEntry>(resultSet.getResults().size());
        CollectionAndDataObjectListingEntry collectionAndDataObjectListingEntry = null;
        ArrayList<UserFilePermission> userFilePermissions = new ArrayList<UserFilePermission>();
        String lastPath = "";
        boolean isAtEndOfQueryResults = false;
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            isAtEndOfQueryResults = row.isLastResult();
            String thisPath = row.getColumn(1);
            if (thisPath.equals(lastPath)) {
                CollectionAOHelper.buildUserFilePermissionForCollection(userFilePermissions, row, effectiveAbsolutePath);
                continue;
            }
            if (collectionAndDataObjectListingEntry != null) {
                collectionAndDataObjectListingEntry.setUserFilePermission(userFilePermissions);
                collectionListingUtils.augmentCollectionEntryForSpecialCollections(objStat, effectiveAbsolutePath, collectionAndDataObjectListingEntry);
                collectionAndDataObjectListingEntry.setCount(row.getRecordCount() - 1);
                subdirs.add(collectionAndDataObjectListingEntry);
            }
            collectionAndDataObjectListingEntry = CollectionAOHelper.buildCollectionListEntryFromResultSetRowForCollectionQuery(row, resultSet.getTotalRecords());
            lastPath = collectionAndDataObjectListingEntry.getPathOrName();
            userFilePermissions = new ArrayList();
            CollectionAOHelper.buildUserFilePermissionForCollection(userFilePermissions, row, effectiveAbsolutePath);
        }
        if (collectionAndDataObjectListingEntry != null) {
            if (isAtEndOfQueryResults) {
                log.debug("adding last entry");
                collectionAndDataObjectListingEntry.setUserFilePermission(userFilePermissions);
                collectionAndDataObjectListingEntry.setLastResult(true);
                collectionListingUtils.augmentCollectionEntryForSpecialCollections(objStat, effectiveAbsolutePath, collectionAndDataObjectListingEntry);
                subdirs.add(collectionAndDataObjectListingEntry);
            } else {
                log.debug("ignoring last entry, as it might carry over to the next page of results");
            }
        }
        return subdirs;
    }

    @Override
    public List<CollectionAndDataObjectListingEntry> listDataObjectsUnderPath(String absolutePathToParent, int partialStartIndex) throws JargonException {
        if (absolutePathToParent == null) {
            throw new JargonException("absolutePathToParent is null");
        }
        ObjStat objStat = this.retrieveObjectStatForPathWithHeuristicPathGuessing(absolutePathToParent);
        CollectionListingUtils collectionListingUtils = new CollectionListingUtils(this);
        if (objStat == null) {
            log.error("unable to find objStat for collection path:{}", (Object)absolutePathToParent);
            throw new FileNotFoundException("unable to find objStat for collection");
        }
        return collectionListingUtils.listDataObjectsUnderPath(objStat, partialStartIndex);
    }

    @Override
    public List<CollectionAndDataObjectListingEntry> listDataObjectsUnderPathWithPermissions(String absolutePathToParent, int partialStartIndex) throws FileNotFoundException, JargonException {
        if (absolutePathToParent == null) {
            throw new JargonException("absolutePathToParent is null");
        }
        log.info("listDataObjectsUnderPathWithPermissions for: {}", (Object)absolutePathToParent);
        ObjStat objStat = this.retrieveObjectStatForPathWithHeuristicPathGuessing(absolutePathToParent);
        if (objStat == null) {
            log.error("unable to find objStat for collection path:{}", (Object)absolutePathToParent);
            throw new FileNotFoundException("unable to find objStat for collection");
        }
        log.info("doing listing using genquery...");
        return this.listDataObjectsUnderPathWithPermissionsCheckingIfSpecQueryUsed(absolutePathToParent, partialStartIndex, objStat);
    }

    private List<CollectionAndDataObjectListingEntry> listDataObjectsUnderPathWithPermissionsCheckingIfSpecQueryUsed(String absolutePathToParent, int partialStartIndex, ObjStat objStat) throws FileNotFoundException, JargonException {
        if (absolutePathToParent == null) {
            throw new JargonException("absolutePathToParent is null");
        }
        if (objStat == null) {
            throw new IllegalArgumentException("null objStat");
        }
        String effectiveAbsolutePath = objStat.determineAbsolutePathBasedOnCollTypeInObjectStat();
        log.info("determined effectiveAbsolutePathToBe:{}", (Object)effectiveAbsolutePath);
        log.info("checking to see if I can list via specific query");
        if (this.getJargonProperties().isUsingSpecificQueryForCollectionListingsWithPermissions()) {
            log.info("we are using spec query in jargon.properties...");
            if (this.specificQueryAO == null) {
                log.info("...we are bypassing spec query...");
            } else if (this.specificQueryAO.isSpecificQueryToBeBypassed()) {
                log.info("...we are bypassing spec query...");
            } else {
                log.info("attemting to list via specQuery...");
                try {
                    return this.listDataObjectsUnderPathWithPermissionsViaSpecQuery(objStat, partialStartIndex);
                }
                catch (JargonException je) {
                    log.error("error executing spec query will do the genQuery fallback");
                }
                catch (JargonQueryException e) {
                    log.error("query exception error executing spec query will do the genQuery fallback");
                }
            }
        }
        log.info("not using specific query, fall back to genQuery");
        return this.listDataObjectsUnderPathWithPermissionsUsingGenQuery(absolutePathToParent, partialStartIndex, objStat);
    }

    private List<CollectionAndDataObjectListingEntry> listDataObjectsUnderPathWithPermissionsUsingGenQuery(String absolutePathToParent, int partialStartIndex, ObjStat objStat) throws FileNotFoundException, JargonException {
        String effectiveAbsolutePath = objStat.determineAbsolutePathBasedOnCollTypeInObjectStat();
        log.info("determined effectiveAbsolutePathToBe:{}", (Object)effectiveAbsolutePath);
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
        CollectionListingUtils collectionListingUtils = new CollectionListingUtils(this);
        IRODSFileSystemAOHelper.buildQueryListAllDataObjectsWithUserAccessInfo(effectiveAbsolutePath, builder);
        IRODSQueryResultSet resultSet = collectionListingUtils.queryForPathAndReturnResultSet(effectiveAbsolutePath, builder, partialStartIndex, objStat);
        log.debug("got result set:{}", (Object)resultSet);
        return this.buildDataObjectListingWithAccessInfoFromResultSet(resultSet, objStat);
    }

    private List<CollectionAndDataObjectListingEntry> listDataObjectsUnderPathWithPermissionsViaSpecQuery(ObjStat objStat, int offset) throws JargonQueryException, JargonException {
        log.info("listDataObjectsUnderPathWithPermissionsViaSpecQuery()");
        String effectiveAbsolutePath = objStat.determineAbsolutePathBasedOnCollTypeInObjectStat();
        log.info("determined effectiveAbsolutePathToBe:{}", (Object)effectiveAbsolutePath);
        ArrayList<String> arguments = new ArrayList<String>(3);
        arguments.add(effectiveAbsolutePath);
        arguments.add(String.valueOf(this.getJargonProperties().getMaxFilesAndDirsQueryMax()));
        arguments.add(String.valueOf(offset));
        SpecificQuery specificQuery = SpecificQuery.instanceArguments("ilsLADataObjects", arguments, 0, MiscIRODSUtils.getZoneInPath(effectiveAbsolutePath));
        SpecificQueryResultSet specificQueryResultSet = this.specificQueryAO.executeSpecificQueryUsingAlias(specificQuery, this.getJargonProperties().getMaxFilesAndDirsQueryMax(), offset);
        log.info("got result set:{}", (Object)specificQueryResultSet);
        return this.buildDataObjectListingWithAccessInfoFromResultSet(specificQueryResultSet, objStat);
    }

    @Override
    public List<CollectionAndDataObjectListingEntry> searchDataObjectsBasedOnName(String searchTerm) throws JargonException {
        return this.searchDataObjectsBasedOnName(searchTerm, 0);
    }

    @Override
    public List<CollectionAndDataObjectListingEntry> searchDataObjectsBasedOnName(String searchTerm, int partialStartIndex) throws JargonException {
        IRODSQueryResultSet resultSet;
        if (searchTerm == null || searchTerm.isEmpty()) {
            throw new IllegalArgumentException("null or empty search term");
        }
        if (partialStartIndex < 0) {
            throw new IllegalArgumentException("partialStartIndex is < 0");
        }
        log.info("searchDataObjectsBasedOnName:{}", (Object)searchTerm);
        IRODSGenQueryExecutorImpl irodsGenQueryExecutor = new IRODSGenQueryExecutorImpl(this.getIRODSSession(), this.getIRODSAccount());
        try {
            IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
            builder.addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_DATA_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_CREATE_TIME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_MODIFY_TIME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_DATA_SIZE).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_OWNER_NAME).addConditionAsGenQueryField(RodsGenQueryEnum.COL_DATA_NAME, QueryConditionOperators.LIKE, "%" + searchTerm + "%");
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(this.getJargonProperties().getMaxFilesAndDirsQueryMax());
            resultSet = irodsGenQueryExecutor.executeIRODSQueryWithPaging(irodsQuery, partialStartIndex);
        }
        catch (JargonQueryException e) {
            log.error("query exception for  query:", (Throwable)e);
            throw new JargonException("error in exists query", e);
        }
        catch (GenQueryBuilderException e) {
            log.error("query exception for  query:", (Throwable)e);
            throw new JargonException("error in exists query", e);
        }
        ArrayList<CollectionAndDataObjectListingEntry> entries = new ArrayList<CollectionAndDataObjectListingEntry>();
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            CollectionAndDataObjectListingEntry entry = new CollectionAndDataObjectListingEntry();
            entry.setParentPath(row.getColumn(0));
            entry.setObjectType(CollectionAndDataObjectListingEntry.ObjectType.DATA_OBJECT);
            entry.setPathOrName(row.getColumn(1));
            entry.setCreatedAt(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(2)));
            entry.setModifiedAt(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(3)));
            entry.setDataSize(IRODSDataConversionUtil.getLongOrZeroFromIRODSValue(row.getColumn(4)));
            entry.setOwnerName(row.getColumn(5));
            entry.setCount(row.getRecordCount());
            entry.setLastResult(row.isLastResult());
            log.info("listing entry built {}", (Object)entry.toString());
            entries.add(entry);
        }
        return entries;
    }

    @Override
    public List<CollectionAndDataObjectListingEntry> searchCollectionsAndDataObjectsBasedOnName(String searchTerm) throws JargonException {
        log.info("searchCollectionsAndDataObjectsBasedOnName for search term:{}, starting with collections", (Object)searchTerm);
        List<CollectionAndDataObjectListingEntry> entries = this.searchCollectionsBasedOnName(searchTerm);
        log.info("adding data objects to search results");
        List<CollectionAndDataObjectListingEntry> dataObjectEntries = this.searchDataObjectsBasedOnName(searchTerm);
        for (CollectionAndDataObjectListingEntry entry : dataObjectEntries) {
            entries.add(entry);
        }
        return entries;
    }

    @Override
    public Object getFullObjectForType(String objectAbsolutePath) throws FileNotFoundException, JargonException {
        if (objectAbsolutePath == null || objectAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty object absolute path");
        }
        log.info("getFullObjectForType for path:{}", (Object)objectAbsolutePath);
        ObjStat objStat = this.retrieveObjectStatForPath(objectAbsolutePath);
        String effectiveAbsolutePath = MiscIRODSUtils.determineAbsolutePathBasedOnCollTypeInObjectStat(objStat);
        log.info("determined effectiveAbsolutePathToBe:{}", (Object)effectiveAbsolutePath);
        MiscIRODSUtils.evaluateSpecCollSupport(objStat);
        Object returnObject = null;
        if (objStat.isSomeTypeOfCollection()) {
            CollectionAOImpl collectionAO = new CollectionAOImpl(this.getIRODSSession(), this.getIRODSAccount());
            returnObject = collectionAO.findGivenObjStat(objStat);
        } else {
            returnObject = objStat.getSpecColType() == ObjStat.SpecColType.STRUCT_FILE_COLL ? this.buildDataObjectFromObjStatIfStructuredCollection(objStat) : this.buildDataObjectFromICAT(objStat);
        }
        return returnObject;
    }

    private Object buildDataObjectFromICAT(ObjStat objStat) throws JargonException, DataNotFoundException {
        DataObjectAOImpl dataObjectAO = new DataObjectAOImpl(this.getIRODSSession(), this.getIRODSAccount());
        DataObject returnObject = dataObjectAO.findGivenObjStat(objStat);
        return returnObject;
    }

    private Object buildDataObjectFromObjStatIfStructuredCollection(ObjStat objStat) {
        DataObject dataObject = new DataObject();
        dataObject.setChecksum(objStat.getChecksum());
        dataObject.setCollectionName(objStat.getCollectionPath());
        dataObject.setCreatedAt(objStat.getCreatedAt());
        dataObject.setDataName(MiscIRODSUtils.getLastPathComponentForGiveAbsolutePath(objStat.getAbsolutePath()));
        dataObject.setDataOwnerName(objStat.getOwnerName());
        dataObject.setDataOwnerZone(objStat.getOwnerZone());
        dataObject.setDataPath(objStat.getObjectPath());
        dataObject.setDataReplicationNumber(objStat.getReplNumber());
        dataObject.setDataSize(objStat.getObjSize());
        dataObject.setSpecColType(objStat.getSpecColType());
        dataObject.setUpdatedAt(objStat.getModifiedAt());
        DataObject returnObject = dataObject;
        return returnObject;
    }

    @Override
    public ObjStat retrieveObjectStatForPathAndDataObjectName(String parentPath, String fileName) throws FileNotFoundException, JargonException {
        log.info("retrieveObjectStatForPathAndDataObjectName()");
        if (parentPath == null || parentPath.isEmpty()) {
            throw new IllegalArgumentException("null or empty parentPath");
        }
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("null or empty fileName");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(parentPath);
        sb.append('/');
        sb.append(fileName);
        return this.retrieveObjectStatForPath(sb.toString());
    }

    @Override
    public ObjStat retrieveObjectStatForPathWithHeuristicPathGuessing(String irodsAbsolutePath) throws FileNotFoundException, JargonException {
        log.info("retrieveObjectStatForPathWithHeuristicPathGuessing()");
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsAbsolutePath");
        }
        CollectionListingUtils collectionListingUtils = new CollectionListingUtils(this);
        ObjStat objStat = null;
        try {
            objStat = this.retrieveObjectStatForPath(irodsAbsolutePath);
        }
        catch (FileNotFoundException fnf) {
            log.info("got a file not found, try to heuristically produce an objstat");
            objStat = collectionListingUtils.handleNoObjStatUnderRootOrHomeByLookingForPublicAndHome(irodsAbsolutePath);
        }
        if (objStat == null) {
            throw new JargonRuntimeException("should not be a null objStat");
        }
        return objStat;
    }

    @Override
    public ObjStat retrieveObjectStatForPath(String irodsAbsolutePath) throws FileNotFoundException, JargonException {
        Tag response;
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("irodsAbsolutePath is null or empty");
        }
        String myPath = MiscIRODSUtils.checkPathSizeForMax(irodsAbsolutePath);
        DataObjInpForObjStat dataObjInp = DataObjInpForObjStat.instance(myPath);
        try {
            response = this.getIRODSProtocol().irodsFunction(dataObjInp);
        }
        catch (DataNotFoundException e) {
            log.info("rethrow DataNotFound as FileNotFound per contract");
            throw new FileNotFoundException(e);
        }
        log.debug("response from objStat: {}", (Object)response.parseTag());
        ObjStat objStat = new ObjStat();
        objStat.setAbsolutePath(myPath);
        objStat.setChecksum(response.getTag("chksum").getStringValue());
        objStat.setDataId(response.getTag("dataId").getIntValue());
        int objType = response.getTag("objType").getIntValue();
        objStat.setObjectType(CollectionAndDataObjectListingEntry.ObjectType.values()[objType]);
        objStat.setObjSize(response.getTag("objSize").getLongValue());
        objStat.setOwnerName(response.getTag("ownerName").getStringValue());
        objStat.setOwnerZone(response.getTag("ownerZone").getStringValue());
        objStat.setSpecColType(ObjStat.SpecColType.NORMAL);
        Tag specColl = response.getTag("SpecColl_PI");
        if (specColl != null) {
            Tag tag = specColl.getTag("collection");
            if (tag != null) {
                objStat.setCollectionPath(tag.getStringValue());
            }
            if ((tag = specColl.getTag("cacheDir")) != null) {
                objStat.setCacheDir(tag.getStringValue());
            }
            if ((tag = specColl.getTag("cacheDirty")) != null) {
                objStat.setCacheDirty(tag.getStringValue().equals("1"));
            }
            int collClass = specColl.getTag("collClass").getIntValue();
            objStat.setReplNumber(specColl.getTag("replNum").getIntValue());
            switch (collClass) {
                case 0: {
                    objStat.setSpecColType(ObjStat.SpecColType.NORMAL);
                    objStat.setObjectPath(specColl.getTag("phyPath").getStringValue());
                    break;
                }
                case 1: {
                    objStat.setSpecColType(ObjStat.SpecColType.STRUCT_FILE_COLL);
                    break;
                }
                case 2: {
                    objStat.setSpecColType(ObjStat.SpecColType.MOUNTED_COLL);
                    break;
                }
                case 3: {
                    objStat.setSpecColType(ObjStat.SpecColType.LINKED_COLL);
                    String canonicalSourceDirForSoftLink = specColl.getTag("phyPath").getStringValue();
                    String softLinkTargetDir = specColl.getTag("collection").getStringValue();
                    if (softLinkTargetDir.length() > objStat.getAbsolutePath().length()) {
                        throw new JargonException("cannot properly compute path for soft link");
                    }
                    String additionalPath = objStat.getAbsolutePath().substring(softLinkTargetDir.length());
                    StringBuilder sb = new StringBuilder();
                    sb.append(canonicalSourceDirForSoftLink);
                    sb.append(additionalPath);
                    objStat.setObjectPath(sb.toString());
                    break;
                }
                default: {
                    throw new JargonException("unknown special coll type:");
                }
            }
        }
        String createdDate = response.getTag("createTime").getStringValue();
        String modifiedDate = response.getTag("modifyTime").getStringValue();
        objStat.setCreatedAt(IRODSDataConversionUtil.getDateFromIRODSValue(createdDate));
        objStat.setModifiedAt(IRODSDataConversionUtil.getDateFromIRODSValue(modifiedDate));
        log.info(objStat.toString());
        return objStat;
    }
}

