/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.packinstr;

import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.AbstractIRODSPackingInstruction;
import org.irods.jargon.core.packinstr.Tag;

public class StartupPack
extends AbstractIRODSPackingInstruction {
    public static final String PI_TAG = "StartupPack_PI";
    public static final String CHALLENGE = "challenge";
    public static final String SP_OPTION_IINIT = "iinit";
    public static final String protocolType = "1";
    private final IRODSAccount irodsAccount;
    private int reconnFlag = 0;
    private int connectCnt = 0;
    private String option = "";
    public static final String NEGOTIATE_OPTION = "request_server_negotiation";

    public StartupPack(IRODSAccount irodsAccount) {
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null irodsAccount");
        }
        this.irodsAccount = irodsAccount;
    }

    public StartupPack(IRODSAccount irodsAccount, boolean reconnect, String option) {
        this(irodsAccount);
        if (reconnect) {
            this.reconnFlag = 200;
        }
        if (option == null) {
            throw new IllegalArgumentException("null option");
        }
        this.option = option;
    }

    @Override
    public Tag getTagValue() throws JargonException {
        Tag startupPacket = new Tag(PI_TAG, new Tag[]{new Tag("irodsProt", protocolType), new Tag("reconnFlag", this.reconnFlag), new Tag("connectCnt", this.connectCnt), new Tag("proxyUser", this.irodsAccount.getProxyName()), new Tag("proxyRcatZone", this.irodsAccount.getProxyZone()), new Tag("clientUser", this.irodsAccount.getUserName()), new Tag("clientRcatZone", this.irodsAccount.getZone()), new Tag("relVersion", "rods3.2"), new Tag("apiVersion", "d"), new Tag("option", this.option)});
        return startupPacket;
    }
}

