/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.packinstr;

import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.AbstractIRODSPackingInstruction;
import org.irods.jargon.core.packinstr.Tag;

public final class ExecCmd
extends AbstractIRODSPackingInstruction {
    public static final String PI_TAG = "ExecCmd_PI";
    public static final String PI_TAG_BACKWORD_COMPATABLE = "ExecCmd241_PI";
    public static final int STANDARD_EXEC_ENCAPSULATE_DATA_IN_RESPONSE_API_NBR = 634;
    public static final int EXEC_AND_USE_ENHANCED_STREAM = 692;
    public static final String CMD = "cmd";
    public static final String CMD_ARGV = "cmdArgv";
    public static final String EXEC_ADDR = "execAddr";
    public static final String HINT_PATH = "hintPath";
    public static final String ADD_PATH_TO_ARGV = "addPathToArgv";
    public static final String STREAM_STDOUT_KW = "streamStdout";
    public static final String DUMMY = "dummy";
    public static final int ADD_PATH_TO_ARGV_WHEN_USING_PATH_TO_ADD_ARGUMENT = 1;
    public static final int ADD_PATH_TO_ARGV_WHEN_USING_PATH_TO_RESOLVE_HOST = 0;
    public static final int ADD_PATH_TO_ARGV_DEFAULT = 0;
    private final String commandToExecuteWithoutArguments;
    private final String argumentsToPassWithCommand;
    private final String executionHost;
    private final String absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn;
    private final boolean useBackwardCompatableInstruction;
    private final PathHandlingMode pathHandlingMode;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ExecCmd");
        sb.append("\n  commandToExecuteWithoutArguments:");
        sb.append(this.commandToExecuteWithoutArguments);
        sb.append("\n   argumentsToPassWithCommand:");
        sb.append(this.argumentsToPassWithCommand);
        sb.append("\n   executionHost:");
        sb.append(this.executionHost);
        sb.append("\n   absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn:");
        sb.append(this.absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn);
        sb.append("\n  useBackwardCompatableInstruction:\n");
        sb.append(this.useBackwardCompatableInstruction);
        sb.append("\n   pathHandlingMode:");
        sb.append((Object)this.pathHandlingMode);
        return sb.toString();
    }

    public static final ExecCmd instanceWithCommandPriorTo25(String commandToExecuteWithoutArguments, String argumentsToPassWithCommand) throws JargonException {
        return new ExecCmd(634, commandToExecuteWithoutArguments, argumentsToPassWithCommand, "", "", true, PathHandlingMode.NONE);
    }

    public static final ExecCmd instanceWithCommandPost25(String commandToExecuteWithoutArguments, String argumentsToPassWithCommand) throws JargonException {
        return new ExecCmd(692, commandToExecuteWithoutArguments, argumentsToPassWithCommand, "", "", false, PathHandlingMode.NONE);
    }

    public static final ExecCmd instanceWithCommandAllowingStreamingForLargeResultsPost25(String commandToExecuteWithoutArguments, String argumentsToPassWithCommand) throws JargonException {
        return new ExecCmd(692, commandToExecuteWithoutArguments, argumentsToPassWithCommand, "", "", false, PathHandlingMode.NONE);
    }

    public static final ExecCmd instanceWithHostAndArgumentsToPassParametersPriorTo25(String commandToExecuteWithoutArguments, String argumentsToPassWithCommand, String executionHost, String absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn, PathHandlingMode pathHandlingMode) throws JargonException {
        return new ExecCmd(634, commandToExecuteWithoutArguments, argumentsToPassWithCommand, executionHost, absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn, true, pathHandlingMode);
    }

    public static final ExecCmd instanceWithHostAndArgumentsToPassParametersPost25(String commandToExecuteWithoutArguments, String argumentsToPassWithCommand, String executionHost, String absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn, PathHandlingMode pathHandlingMode) throws JargonException {
        return new ExecCmd(692, commandToExecuteWithoutArguments, argumentsToPassWithCommand, executionHost, absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn, false, pathHandlingMode);
    }

    public static final ExecCmd instanceWithHostAndArgumentsToPassParametersAllowingStreamingForLargeResultsPost25(String commandToExecuteWithoutArguments, String argumentsToPassWithCommand, String executionHost, String absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn, PathHandlingMode pathHandlingMode) throws JargonException {
        return new ExecCmd(692, commandToExecuteWithoutArguments, argumentsToPassWithCommand, executionHost, absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn, false, pathHandlingMode);
    }

    private ExecCmd(int apiNumber, String commandToExecuteWithoutArguments, String argumentsToPassWithCommand, String executionHost, String absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn, boolean useBackwardCompatableInstruction, PathHandlingMode pathHandlingMode) throws JargonException {
        if (commandToExecuteWithoutArguments == null || commandToExecuteWithoutArguments.length() == 0) {
            throw new IllegalArgumentException("null commandToExecuteWithoutArguments");
        }
        if (argumentsToPassWithCommand == null) {
            throw new IllegalArgumentException("null argumentsToPassWithCommand, set to blank if not used");
        }
        if (executionHost == null) {
            throw new IllegalArgumentException("null executionHost, set to blank if not used");
        }
        if (absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn == null) {
            throw new IllegalArgumentException("null absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn, set to blank if not used");
        }
        if (this.getApiNumber() == 634 && useBackwardCompatableInstruction) {
            throw new IllegalArgumentException("cannot stream binary data using the older instruction, the parameters are in conflict");
        }
        if (pathHandlingMode == null) {
            throw new IllegalArgumentException("null pathHandlingMode");
        }
        this.commandToExecuteWithoutArguments = commandToExecuteWithoutArguments;
        this.argumentsToPassWithCommand = argumentsToPassWithCommand;
        this.executionHost = executionHost;
        this.absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn = absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn;
        this.useBackwardCompatableInstruction = useBackwardCompatableInstruction;
        this.setApiNumber(apiNumber);
        this.pathHandlingMode = pathHandlingMode;
    }

    @Override
    public Tag getTagValue() throws JargonException {
        String piTagToUse = PI_TAG;
        int addPathToArgv = 0;
        if (!this.absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn.isEmpty()) {
            if (this.pathHandlingMode == PathHandlingMode.USE_PATH_TO_ADD_PHYS_PATH_ARGUMENT_TO_REMOTE_SCRIPT) {
                addPathToArgv = 1;
            } else if (this.pathHandlingMode == PathHandlingMode.USE_PATH_TO_FIND_EXECUTING_HOST) {
                addPathToArgv = 0;
            }
        }
        Tag message = new Tag(piTagToUse, new Tag[]{new Tag(CMD, this.commandToExecuteWithoutArguments), new Tag(CMD_ARGV, this.argumentsToPassWithCommand), new Tag(EXEC_ADDR, this.executionHost), new Tag(HINT_PATH, this.absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn), new Tag(ADD_PATH_TO_ARGV, addPathToArgv)});
        if (!this.useBackwardCompatableInstruction) {
            message.addTag(new Tag(DUMMY, 0));
        }
        if (!this.useBackwardCompatableInstruction) {
            message.addTag(Tag.createKeyValueTag(STREAM_STDOUT_KW, ""));
        } else {
            message.addTag(Tag.createKeyValueTag(null));
        }
        return message;
    }

    public String getCommandToExecuteWithoutArguments() {
        return this.commandToExecuteWithoutArguments;
    }

    public String getArgumentsToPassWithCommand() {
        return this.argumentsToPassWithCommand;
    }

    public String getExecutionHost() {
        return this.executionHost;
    }

    public String getAbsolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn() {
        return this.absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn;
    }

    public static enum PathHandlingMode {
        NONE,
        USE_PATH_TO_ADD_PHYS_PATH_ARGUMENT_TO_REMOTE_SCRIPT,
        USE_PATH_TO_FIND_EXECUTING_HOST;

    }
}

