/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.packinstr;

import org.irods.jargon.core.connection.ClientServerNegotiationPolicy;
import org.irods.jargon.core.exception.ClientServerNegotiationException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.AbstractIRODSPackingInstruction;
import org.irods.jargon.core.packinstr.Tag;

public class ClientServerNegotiationStructInitNegotiation
extends AbstractIRODSPackingInstruction {
    private int status = 0;
    private ClientServerNegotiationPolicy.SslNegotiationPolicy sslNegotiationPolicy = ClientServerNegotiationPolicy.SslNegotiationPolicy.NO_NEGOTIATION;
    public static final String NEG_PI = "CS_NEG_PI";
    public static final int STATUS_FAILURE = 0;
    public static final int STATUS_SUCCESS = 1;
    public static final int API_NBR = 0;
    public static final String CS_NEG_RESULT_KW = "cs_neg_result_kw";

    private ClientServerNegotiationStructInitNegotiation(Tag tag) throws ClientServerNegotiationException {
        if (tag == null) {
            throw new IllegalArgumentException("Null tag");
        }
        if (!tag.getName().equals(NEG_PI)) {
            throw new IllegalArgumentException("tag is not a NEG_PI tag");
        }
        int status = tag.getTag("status").getIntValue();
        this.setStatus(status);
        String sslNegResult = tag.getTag("result").getStringValue();
        if (sslNegResult == null || sslNegResult.isEmpty()) {
            throw new ClientServerNegotiationException("no ssl negotiation result found");
        }
        if (sslNegResult.equals(ClientServerNegotiationPolicy.SslNegotiationPolicy.CS_NEG_DONT_CARE.name())) {
            this.setSslNegotiationPolicy(ClientServerNegotiationPolicy.SslNegotiationPolicy.CS_NEG_DONT_CARE);
        } else if (sslNegResult.equals(ClientServerNegotiationPolicy.SslNegotiationPolicy.CS_NEG_REFUSE.name())) {
            this.setSslNegotiationPolicy(ClientServerNegotiationPolicy.SslNegotiationPolicy.CS_NEG_REFUSE);
        } else if (sslNegResult.equals(ClientServerNegotiationPolicy.SslNegotiationPolicy.CS_NEG_REQUIRE.name())) {
            this.setSslNegotiationPolicy(ClientServerNegotiationPolicy.SslNegotiationPolicy.CS_NEG_REQUIRE);
        } else {
            throw new ClientServerNegotiationException("Unrecognized ssl negotiation response:" + sslNegResult);
        }
    }

    public static ClientServerNegotiationStructInitNegotiation instanceFromTag(Tag tag) throws ClientServerNegotiationException {
        return new ClientServerNegotiationStructInitNegotiation(tag);
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public ClientServerNegotiationPolicy.SslNegotiationPolicy getSslNegotiationPolicy() {
        return this.sslNegotiationPolicy;
    }

    public void setSslNegotiationPolicy(ClientServerNegotiationPolicy.SslNegotiationPolicy sslNegotiationPolicy) {
        this.sslNegotiationPolicy = sslNegotiationPolicy;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ClientServerNegotiationStruct [status=").append(this.status).append(", ");
        if (this.sslNegotiationPolicy != null) {
            builder.append("sslNegotiationPolicy=").append((Object)this.sslNegotiationPolicy);
        }
        builder.append("]");
        return builder.toString();
    }

    public boolean wasThisASuccess() {
        return this.getStatus() == 1;
    }

    @Override
    public Tag getTagValue() throws JargonException {
        StringBuilder sb = new StringBuilder();
        sb.append(CS_NEG_RESULT_KW);
        sb.append('=');
        sb.append(this.sslNegotiationPolicy.name());
        sb.append(';');
        Tag message = new Tag(NEG_PI, new Tag[]{new Tag("status", this.status), new Tag("result", sb.toString())});
        return message;
    }
}

