/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.ClosedChannelException;
import org.irods.jargon.core.connection.AbstractIRODSMidLevelProtocol;
import org.irods.jargon.core.connection.ClientServerNegotiationPolicy;
import org.irods.jargon.core.connection.ClientServerNegotiationService;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.StartupResponseData;
import org.irods.jargon.core.exception.AuthenticationException;
import org.irods.jargon.core.exception.ClientServerNegotiationException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.ClientServerNegotiationStructInitNegotiation;
import org.irods.jargon.core.packinstr.StartupPack;
import org.irods.jargon.core.packinstr.Tag;
import org.irods.jargon.core.protovalues.RequestTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AuthMechanism {
    public static final int AUTH_REQUEST_AN = 703;
    public static final int AUTH_RESPONSE_AN = 704;
    public static final String VERSION_PI_TAG = "Version_PI";
    public String cachedChallenge = "";
    public static final Logger log = LoggerFactory.getLogger(AuthMechanism.class);

    AuthMechanism() {
    }

    protected void preConnectionStartup() throws JargonException {
    }

    protected void postConnectionStartupPreAuthentication() throws JargonException {
    }

    protected StartupResponseData clientServerNegotiationHook(AbstractIRODSMidLevelProtocol irodsMidLevelProtocol, IRODSAccount irodsAccount) throws JargonException {
        log.info("clientServerNegotiationHook()");
        StartupResponseData startupResponseData = null;
        if (irodsMidLevelProtocol.getIrodsConnection().getOperativeClientServerNegotiationPolicy().getSslNegotiationPolicy() != ClientServerNegotiationPolicy.SslNegotiationPolicy.NO_NEGOTIATION) {
            log.info("negotiation is required");
            startupResponseData = this.clientServerNegotiation(irodsMidLevelProtocol, irodsAccount);
        } else {
            Tag versionPI = irodsMidLevelProtocol.readMessage();
            startupResponseData = AuthMechanism.buldStartupResponseFromVersionPI(versionPI);
        }
        log.info("startup response:{}", (Object)startupResponseData);
        irodsMidLevelProtocol.setStartupResponseData(startupResponseData);
        return startupResponseData;
    }

    static StartupResponseData buldStartupResponseFromVersionPI(Tag versionPI) {
        StartupResponseData startupResponseData = new StartupResponseData(versionPI.getTag("status").getIntValue(), versionPI.getTag("relVersion").getStringValue(), versionPI.getTag("apiVersion").getStringValue(), versionPI.getTag("reconnPort").getIntValue(), versionPI.getTag("reconnAddr").getStringValue(), versionPI.getTag("cookie").getStringValue());
        return startupResponseData;
    }

    private StartupResponseData clientServerNegotiation(AbstractIRODSMidLevelProtocol irodsMidLevelProtocol, IRODSAccount irodsAccount) throws JargonException {
        log.info("clientServerNegotiation()");
        Tag negResultPI = irodsMidLevelProtocol.readMessage();
        if (negResultPI.getName().equals(VERSION_PI_TAG)) {
            log.info("got version pi back instead of negotiation status, so treat as no SSL");
            return AuthMechanism.buldStartupResponseFromVersionPI(negResultPI);
        }
        if (negResultPI.getName().equals("CS_NEG_PI")) {
            ClientServerNegotiationStructInitNegotiation struct = ClientServerNegotiationStructInitNegotiation.instanceFromTag(negResultPI);
            if (!struct.wasThisASuccess()) {
                log.error("negotiation was unsuccesful:{}", (Object)struct);
                throw new ClientServerNegotiationException("unsuccesful client-server negotiation");
            }
            log.info("have a server negotiation response:{}", (Object)struct.toString());
            ClientServerNegotiationService clientServerNegotiationService = new ClientServerNegotiationService(irodsMidLevelProtocol);
            StartupResponseData startupResponseData = clientServerNegotiationService.negotiate(struct);
            log.info("negotiated configuration:{}", (Object)startupResponseData);
            return startupResponseData;
        }
        log.error("unknown response to startup pack:{}", (Object)negResultPI.getName());
        throw new ClientServerNegotiationException("unexpected result from send of startup pack, was neither versionPI nor NegotiationPI");
    }

    protected AbstractIRODSMidLevelProtocol authenticate(AbstractIRODSMidLevelProtocol irodsMidLevelProtocol, IRODSAccount irodsAccount) throws AuthenticationException, JargonException {
        irodsMidLevelProtocol.setIrodsAccount(irodsAccount);
        this.preConnectionStartup();
        this.sendStartupPacket(irodsAccount, irodsMidLevelProtocol);
        StartupResponseData startupResponseData = this.clientServerNegotiationHook(irodsMidLevelProtocol, irodsAccount);
        this.postConnectionStartupPreAuthentication();
        AbstractIRODSMidLevelProtocol authenticatedProtocol = this.processAuthenticationAfterStartup(irodsAccount, irodsMidLevelProtocol, startupResponseData);
        authenticatedProtocol = this.processAfterAuthentication(authenticatedProtocol, startupResponseData);
        return authenticatedProtocol;
    }

    protected AbstractIRODSMidLevelProtocol processAfterAuthentication(AbstractIRODSMidLevelProtocol irodsMidLevelProtocol, StartupResponseData startupResponseData) throws AuthenticationException, JargonException {
        return irodsMidLevelProtocol;
    }

    protected String sendAuthRequestAndGetChallenge(AbstractIRODSMidLevelProtocol irodsCommands) throws JargonException {
        try {
            irodsCommands.sendHeader(RequestTypes.RODS_API_REQ.getRequestType(), 0, 0, 0L, 703);
            irodsCommands.getIrodsConnection().flush();
        }
        catch (ClosedChannelException e) {
            log.error("closed channel", (Throwable)e);
            e.printStackTrace();
            throw new JargonException(e);
        }
        catch (InterruptedIOException e) {
            log.error("interrupted io", (Throwable)e);
            e.printStackTrace();
            throw new JargonException(e);
        }
        catch (IOException e) {
            log.error("io exception", (Throwable)e);
            e.printStackTrace();
            throw new JargonException(e);
        }
        Tag message = irodsCommands.readMessage(false);
        String cachedChallengeValue = message.getTag("challenge").getStringValue();
        log.debug("cached challenge response:{}", (Object)cachedChallengeValue);
        return cachedChallengeValue;
    }

    protected abstract AbstractIRODSMidLevelProtocol processAuthenticationAfterStartup(IRODSAccount var1, AbstractIRODSMidLevelProtocol var2, StartupResponseData var3) throws AuthenticationException, JargonException;

    protected void sendStartupPacket(IRODSAccount irodsAccount, AbstractIRODSMidLevelProtocol irodsCommands) throws JargonException {
        log.info("sendStartupPacket()");
        String myOption = irodsCommands.getIrodsConnection().getOperativeClientServerNegotiationPolicy().getSslNegotiationPolicy() == ClientServerNegotiationPolicy.SslNegotiationPolicy.NO_NEGOTIATION ? "iinit" : "request_server_negotiation";
        StartupPack startupPack = new StartupPack(irodsAccount, irodsCommands.getPipelineConfiguration().isReconnect(), myOption);
        String startupPackData = startupPack.getParsedTags();
        log.debug("startupPackData:{}", (Object)startupPackData);
        try {
            irodsCommands.sendHeader(RequestTypes.RODS_CONNECT.getRequestType(), startupPackData.length(), 0, 0L, 0);
            irodsCommands.getIrodsConnection().send(startupPackData);
            irodsCommands.getIrodsConnection().flush();
        }
        catch (ClosedChannelException e) {
            log.error("closed channel", (Throwable)e);
            e.printStackTrace();
            throw new JargonException(e);
        }
        catch (InterruptedIOException e) {
            log.error("interrupted io", (Throwable)e);
            e.printStackTrace();
            throw new JargonException(e);
        }
        catch (IOException e) {
            log.error("io exception", (Throwable)e);
            e.printStackTrace();
            throw new JargonException(e);
        }
    }
}

