/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.io.MemorySegementingOutputStream;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.openstack.SwiftExceptionMappingService;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSegmentService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.cyberduck.core.openstack.SwiftTouchFeature;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.DefaultRetryCallable;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.openstack.swift.Client;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.model.StorageObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.log4j.Logger;

public class SwiftLargeUploadWriteFeature
implements MultipartWrite<List<StorageObject>> {
    private static final Logger log = Logger.getLogger(SwiftLargeUploadWriteFeature.class);
    private final PathContainerService containerService = new PathContainerService();
    private final SwiftSession session;
    private final Find finder;
    private final AttributesFinder attributes;
    private final SwiftSegmentService segmentService;
    private final SwiftRegionService regionService;

    public SwiftLargeUploadWriteFeature(SwiftSession session) {
        this(session, (Find)new DefaultFindFeature((Session)session), (AttributesFinder)new DefaultAttributesFinderFeature((Session)session));
    }

    public SwiftLargeUploadWriteFeature(SwiftSession session, SwiftRegionService regionService) {
        this(session, regionService, new SwiftSegmentService(session, regionService), (Find)new DefaultFindFeature((Session)session), (AttributesFinder)new DefaultAttributesFinderFeature((Session)session));
    }

    public SwiftLargeUploadWriteFeature(SwiftSession session, SwiftRegionService regionService, SwiftSegmentService segmentService) {
        this(session, regionService, segmentService, (Find)new DefaultFindFeature((Session)session), (AttributesFinder)new DefaultAttributesFinderFeature((Session)session));
    }

    public SwiftLargeUploadWriteFeature(SwiftSession session, Find finder, AttributesFinder attributes) {
        this(session, new SwiftRegionService(session), new SwiftSegmentService(session), finder, attributes);
    }

    public SwiftLargeUploadWriteFeature(SwiftSession session, SwiftRegionService regionService, SwiftSegmentService segmentService, Find finder, AttributesFinder attributes) {
        this.session = session;
        this.regionService = regionService;
        this.segmentService = segmentService;
        this.finder = finder;
        this.attributes = attributes;
    }

    public HttpResponseOutputStream<List<StorageObject>> write(Path file, TransferStatus status, ConnectionCallback callback) {
        final LargeUploadOutputStream proxy = new LargeUploadOutputStream(file, status);
        return new HttpResponseOutputStream<List<StorageObject>>((OutputStream)new MemorySegementingOutputStream((OutputStream)proxy, Integer.valueOf(PreferencesFactory.get().getInteger("openstack.upload.largeobject.size.minimum")))){

            public List<StorageObject> getStatus() {
                return proxy.getCompleted();
            }
        };
    }

    public Write.Append append(Path file, Long length, Cache<Path> cache) throws BackgroundException {
        if (this.finder.withCache(cache).find(file)) {
            PathAttributes attr = this.attributes.withCache(cache).find(file);
            return new Write.Append(false, true).withSize(Long.valueOf(attr.getSize())).withChecksum(attr.getChecksum());
        }
        return Write.notfound;
    }

    public boolean temporary() {
        return false;
    }

    public boolean random() {
        return false;
    }

    private final class LargeUploadOutputStream
    extends OutputStream {
        private final List<StorageObject> completed = new ArrayList<StorageObject>();
        private final Path file;
        private final TransferStatus overall;
        private final AtomicBoolean close = new AtomicBoolean();
        private int segmentNumber;

        public LargeUploadOutputStream(Path file, TransferStatus status) {
            this.file = file;
            this.overall = status;
        }

        @Override
        public void write(int value) throws IOException {
            throw new IOException(new UnsupportedOperationException());
        }

        @Override
        public void write(final byte[] content, final int off, final int len) throws IOException {
            try {
                this.completed.add((StorageObject)new DefaultRetryCallable(SwiftLargeUploadWriteFeature.this.session.getHost(), (BackgroundExceptionCallable)new BackgroundExceptionCallable<StorageObject>(){

                    public StorageObject call() throws BackgroundException {
                        String checksum;
                        TransferStatus status = new TransferStatus().length((long)len);
                        status.setChecksum(SwiftLargeUploadWriteFeature.this.checksum(LargeUploadOutputStream.this.file, status).compute((InputStream)new ByteArrayInputStream(content, off, len), status));
                        Path segment = SwiftLargeUploadWriteFeature.this.segmentService.getSegment(LargeUploadOutputStream.this.file, status.getLength(), ++LargeUploadOutputStream.this.segmentNumber);
                        ByteArrayEntity entity = new ByteArrayEntity(content, off, len);
                        HashMap headers = new HashMap();
                        try {
                            checksum = ((Client)SwiftLargeUploadWriteFeature.this.session.getClient()).storeObject(SwiftLargeUploadWriteFeature.this.regionService.lookup(LargeUploadOutputStream.this.file), SwiftLargeUploadWriteFeature.this.containerService.getContainer(segment).getName(), SwiftLargeUploadWriteFeature.this.containerService.getKey(segment), (HttpEntity)entity, headers, status.getChecksum().algorithm == HashAlgorithm.md5 ? status.getChecksum().hash : null);
                        }
                        catch (GenericException e) {
                            throw new SwiftExceptionMappingService().map("Upload {0} failed", e, LargeUploadOutputStream.this.file);
                        }
                        catch (IOException e) {
                            throw new DefaultIOExceptionMappingService().map("Upload {0} failed", (Throwable)e, LargeUploadOutputStream.this.file);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Saved segment %s with checksum %s", segment, checksum));
                        }
                        StorageObject stored = new StorageObject(SwiftLargeUploadWriteFeature.this.containerService.getKey(segment));
                        stored.setMd5sum(checksum);
                        stored.setSize(Long.valueOf(status.getLength()));
                        return stored;
                    }
                }, (StreamCancelation)this.overall).call());
            }
            catch (BackgroundException e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        @Override
        public void close() throws IOException {
            try {
                if (this.close.get()) {
                    log.warn((Object)String.format("Skip double close of stream %s", this));
                    return;
                }
                if (this.completed.isEmpty()) {
                    new SwiftTouchFeature(SwiftLargeUploadWriteFeature.this.session, SwiftLargeUploadWriteFeature.this.regionService).touch(this.file, new TransferStatus());
                } else {
                    String manifest = SwiftLargeUploadWriteFeature.this.segmentService.manifest(SwiftLargeUploadWriteFeature.this.containerService.getContainer(this.file).getName(), this.completed);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Creating SLO manifest %s for %s", manifest, this.file));
                    }
                    ((Client)SwiftLargeUploadWriteFeature.this.session.getClient()).createSLOManifestObject(SwiftLargeUploadWriteFeature.this.regionService.lookup(SwiftLargeUploadWriteFeature.this.containerService.getContainer(this.file)), SwiftLargeUploadWriteFeature.this.containerService.getContainer(this.file).getName(), this.overall.getMime(), SwiftLargeUploadWriteFeature.this.containerService.getKey(this.file), manifest, Collections.emptyMap());
                }
            }
            catch (BackgroundException e) {
                throw new IOException(e.getMessage(), e);
            }
            finally {
                this.close.set(true);
            }
        }

        public List<StorageObject> getCompleted() {
            return this.completed;
        }
    }
}

