/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.ResolveFailedException;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.utils.ServiceUtils;

public class S3BucketCreateService {
    private static final Logger log = Logger.getLogger(S3BucketCreateService.class);
    private final S3Session session;
    private final PathContainerService containerService = new S3PathContainerService();
    private final Preferences preferences = PreferencesFactory.get();

    public S3BucketCreateService(S3Session session) {
        this.session = session;
    }

    public void create(Path bucket, String region) throws BackgroundException {
        if (!((RequestEntityRestStorageService)((Object)this.session.getClient())).getConfiguration().getBoolProperty("s3service.disable-dns-buckets", false) && !ServiceUtils.isBucketNameValidDNSName((String)bucket.getName())) {
            throw new InteroperabilityException(LocaleFactory.localizedString((String)"Bucket name is not DNS compatible", (String)"S3"));
        }
        AccessControlList acl = PreferencesFactory.get().getProperty("s3.bucket.acl.default").equals("public-read") ? AccessControlList.REST_CANNED_PUBLIC_READ : AccessControlList.REST_CANNED_PRIVATE;
        try {
            this.create(bucket, acl, region);
        }
        catch (ResolveFailedException e) {
            log.warn((Object)String.format("Failure %s resolving bucket name. Disable use of DNS bucket names", new Object[]{e}));
            ((RequestEntityRestStorageService)((Object)this.session.getClient())).getConfiguration().setProperty("s3service.disable-dns-buckets", String.valueOf(true));
            this.create(bucket, acl, region);
        }
    }

    protected void create(Path bucket, AccessControlList acl, String region) throws BackgroundException {
        try {
            if (StringUtils.isNotBlank((CharSequence)region) && S3Session.isAwsHostname(this.session.getHost().getHostname())) {
                ((RequestEntityRestStorageService)((Object)this.session.getClient())).getConfiguration().setProperty("s3service.s3-endpoint", String.format("s3.dualstack.%s.amazonaws.com", region));
            }
            ((RequestEntityRestStorageService)((Object)this.session.getClient())).createBucket(URIEncoder.encode((String)this.containerService.getContainer(bucket).getName()), "us-east-1".equals(region) ? "US" : region, acl);
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map("Cannot create folder {0}", e, bucket);
        }
    }
}

