/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.nextcloud;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.StringAppender;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.nextcloud.NextcloudSession;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.AbstractResponseHandler;

public class NextcloudShareProvider
implements PromptUrlProvider {
    private final NextcloudSession session;

    public NextcloudShareProvider(NextcloudSession session) {
        this.session = session;
    }

    public boolean isSupported(Path file, PromptUrlProvider.Type type) {
        switch (type) {
            case upload: {
                return file.isDirectory();
            }
        }
        return true;
    }

    public DescriptiveUrl toDownloadUrl(Path file, Object options, PasswordCallback callback) throws BackgroundException {
        Host bookmark = this.session.getHost();
        StringBuilder request = new StringBuilder(String.format("https://%s/ocs/v2.php/apps/files_sharing/api/v1/shares?path=%s&shareType=%d", bookmark.getHostname(), URIEncoder.encode((String)StringUtils.substringAfter((String)file.getAbsolute(), (String)bookmark.getDefaultPath())), 3));
        try {
            request.append(String.format("&password=%s", callback.prompt(bookmark, LocaleFactory.localizedString((String)"Passphrase", (String)"Cryptomator"), MessageFormat.format(LocaleFactory.localizedString((String)"Create a passphrase required to access {0}", (String)"Credentials"), file.getName()), new LoginOptions().keychain(false).icon(bookmark.getProtocol().disk())).getPassword()));
        }
        catch (LoginCanceledException loginCanceledException) {
            // empty catch block
        }
        HttpPost resource = new HttpPost(request.toString());
        resource.setHeader("OCS-APIRequest", "true");
        resource.setHeader("Accept", "application/xml");
        try {
            return new DescriptiveUrl((URI)((DAVClient)this.session.getClient()).execute((HttpRequestBase)resource, (ResponseHandler)new AbstractResponseHandler<URI>(){

                public URI handleResponse(HttpResponse response) throws HttpResponseException, IOException {
                    StatusLine statusLine = response.getStatusLine();
                    HttpEntity entity = response.getEntity();
                    if (statusLine.getStatusCode() >= 300) {
                        StringAppender message = new StringAppender();
                        message.append(statusLine.getReasonPhrase());
                        ocs error = (ocs)new XmlMapper().readValue(entity.getContent(), ocs.class);
                        message.append(error.meta.message);
                        throw new HttpResponseException(statusLine.getStatusCode(), message.toString());
                    }
                    return (URI)super.handleResponse(response);
                }

                public URI handleEntity(HttpEntity entity) throws IOException {
                    XmlMapper mapper = new XmlMapper();
                    ocs value = (ocs)mapper.readValue(entity.getContent(), ocs.class);
                    return URI.create(value.data.url);
                }
            }), DescriptiveUrl.Type.http);
        }
        catch (HttpResponseException e) {
            throw new DefaultHttpResponseExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public DescriptiveUrl toUploadUrl(Path file, Object options, PasswordCallback callback) throws BackgroundException {
        Host bookmark = this.session.getHost();
        StringBuilder request = new StringBuilder(String.format("https://%s/ocs/v2.php/apps/files_sharing/api/v1/shares?path=%s&shareType=%d&publicUpload=true", bookmark.getHostname(), URIEncoder.encode((String)StringUtils.substringAfter((String)file.getAbsolute(), (String)bookmark.getDefaultPath())), 3));
        try {
            request.append(String.format("&password=%s", callback.prompt(bookmark, LocaleFactory.localizedString((String)"Passphrase", (String)"Cryptomator"), MessageFormat.format(LocaleFactory.localizedString((String)"Create a passphrase required to access {0}", (String)"Credentials"), file.getName()), new LoginOptions().keychain(false).icon(bookmark.getProtocol().disk())).getPassword()));
        }
        catch (LoginCanceledException loginCanceledException) {
            // empty catch block
        }
        HttpPost resource = new HttpPost(request.toString());
        resource.setHeader("OCS-APIRequest", "true");
        resource.setHeader("Accept", "application/xml");
        try {
            return new DescriptiveUrl((URI)((DAVClient)this.session.getClient()).execute((HttpRequestBase)resource, (ResponseHandler)new AbstractResponseHandler<URI>(){

                public URI handleEntity(HttpEntity entity) throws IOException {
                    XmlMapper mapper = new XmlMapper();
                    ocs value = (ocs)mapper.readValue(entity.getContent(), ocs.class);
                    return URI.create(value.data.url);
                }
            }), DescriptiveUrl.Type.http);
        }
        catch (HttpResponseException e) {
            throw new DefaultHttpResponseExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static final class ocs {
        public meta meta;
        public data data;

        private ocs() {
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        private static final class data {
            public int id;
            public String url;

            private data() {
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        private static final class meta {
            public String status;
            public String statuscode;
            public String message;

            private meta() {
            }
        }
    }
}

