/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectType;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.ext.oracle.model.source.OracleSourceObject;
import org.jkiss.dbeaver.ext.oracle.model.source.OracleStatefulObject;
import org.jkiss.dbeaver.model.exec.compile.DBCCompileError;
import org.jkiss.dbeaver.model.exec.compile.DBCCompileLog;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public abstract class OracleTaskHandler
extends AbstractHandler
implements IElementUpdater {
    private static final Log log = Log.getLog(OracleTaskHandler.class);

    protected List<OracleSourceObject> getOracleSourceObjects(UIElement element) {
        ArrayList<OracleSourceObject> objects = new ArrayList<OracleSourceObject>();
        IWorkbenchPartSite partSite = UIUtils.getWorkbenchPartSite((IServiceLocator)element.getServiceLocator());
        if (partSite != null) {
            IWorkbenchPart activePart;
            OracleSourceObject sourceObject;
            ISelection selection;
            ISelectionProvider selectionProvider = partSite.getSelectionProvider();
            if (selectionProvider != null && (selection = selectionProvider.getSelection()) instanceof IStructuredSelection && !selection.isEmpty()) {
                for (Object item : (IStructuredSelection)selection) {
                    OracleSourceObject sourceObject2 = (OracleSourceObject)RuntimeUtils.getObjectAdapter(item, OracleSourceObject.class);
                    if (sourceObject2 == null) continue;
                    objects.add(sourceObject2);
                }
            }
            if (objects.isEmpty() && (sourceObject = (OracleSourceObject)RuntimeUtils.getObjectAdapter((Object)(activePart = partSite.getPart()), OracleSourceObject.class)) != null) {
                objects.add(sourceObject);
            }
        }
        return objects;
    }

    /*
     * Loose catch block
     */
    public static boolean logObjectErrors(JDBCSession session, DBCCompileLog compileLog, OracleStatefulObject schemaObject, OracleObjectType objectType) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM " + OracleUtils.getSysSchemaPrefix((OracleDataSource)schemaObject.getDataSource()) + "ALL_ERRORS WHERE OWNER=? AND NAME=? AND TYPE=? ORDER BY SEQUENCE");){
                boolean bl;
                JDBCResultSet dbResult;
                Throwable throwable2;
                block23: {
                    dbStat.setString(1, schemaObject.getSchema().getName());
                    dbStat.setString(2, schemaObject.getName());
                    dbStat.setString(3, objectType.getTypeName());
                    throwable2 = null;
                    Object var8_12 = null;
                    dbResult = dbStat.executeQuery();
                    boolean hasErrors = false;
                    while (dbResult.next()) {
                        DBCCompileError error = new DBCCompileError("ERROR".equals(dbResult.getString("ATTRIBUTE")), dbResult.getString("TEXT"), dbResult.getInt("LINE"), dbResult.getInt("POSITION"));
                        hasErrors = true;
                        if (error.isError()) {
                            compileLog.error(error);
                            continue;
                        }
                        compileLog.warn(error);
                    }
                    bl = !hasErrors;
                    if (dbResult == null) break block23;
                    dbResult.close();
                }
                return bl;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (dbResult != null) {
                                dbResult.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)"Can't read user errors", (Throwable)e);
            return false;
        }
    }
}

