/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.manager;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.ExasolMessages;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.ExasolPriorityGroup;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class ExasolPriorityGroupManager
extends SQLObjectEditor<ExasolPriorityGroup, ExasolDataSource>
implements DBEObjectRenamer<ExasolPriorityGroup> {
    public long getMakerOptions(@NotNull DBPDataSource dataSource) {
        return 1L;
    }

    public DBSObjectCache<ExasolDataSource, ExasolPriorityGroup> getObjectsCache(ExasolPriorityGroup object) {
        return object.getDataSource().getPriorityGroupCache();
    }

    protected ExasolPriorityGroup createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) throws DBException {
        return new ExasolPriorityGroup((ExasolDataSource)((Object)container), "PG", null, 0);
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        ExasolPriorityGroup group = (ExasolPriorityGroup)command.getObject();
        String script = String.format("CREATE PRIORITY GROUP %s WITH WEIGHT = %d", DBUtils.getQuotedIdentifier((DBSObject)group), group.getWeight());
        actions.add((DBEPersistAction)new SQLDatabasePersistAction(ExasolMessages.manager_priority_create, script));
        if (!group.getDescription().isEmpty()) {
            actions.add((DBEPersistAction)this.getCommentCommand(group));
        }
    }

    private SQLDatabasePersistAction getCommentCommand(ExasolPriorityGroup group) {
        return new SQLDatabasePersistAction(ExasolMessages.manager_priority_group_comment, String.format("COMMENT ON PRIORITY GROUP %s is '%s'", DBUtils.getQuotedIdentifier((DBSObject)group), ExasolUtils.quoteString(group.getDescription())));
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) throws DBException {
        ExasolPriorityGroup group = (ExasolPriorityGroup)command.getObject();
        Map com = command.getProperties();
        if (com.containsKey("description")) {
            actionList.add((DBEPersistAction)this.getCommentCommand(group));
        }
        if (com.containsKey("weight")) {
            String script = String.format("ALTER PRIORITY GROUP %s SET WEIGHT = %d", DBUtils.getQuotedIdentifier((DBSObject)group), group.getWeight());
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(ExasolMessages.manager_priority_alter, script));
        }
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) {
        ExasolPriorityGroup group = (ExasolPriorityGroup)command.getObject();
        String script = String.format("DROP PRIORITY GROUP %s", DBUtils.getQuotedIdentifier((DBSObject)group));
        actions.add((DBEPersistAction)new SQLDatabasePersistAction(ExasolMessages.manager_priority_drop, script));
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull ExasolPriorityGroup object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        ExasolPriorityGroup group = (ExasolPriorityGroup)command.getObject();
        String script = String.format("RENAME PRIORITY GROUP %s to %s", DBUtils.getQuotedIdentifier((DBPDataSource)group.getDataSource(), (String)command.getOldName()), DBUtils.getQuotedIdentifier((DBPDataSource)group.getDataSource(), (String)command.getNewName()));
        actions.add((DBEPersistAction)new SQLDatabasePersistAction(ExasolMessages.manager_priority_rename, script));
    }
}

