/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.cli;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.cli.ApplicationInstanceController;
import org.jkiss.dbeaver.model.cli.CLIProcessResult;

public class CommandLineContext
implements AutoCloseable {
    private static final Log log = Log.getLog(CommandLineContext.class);
    @NotNull
    private final Map<String, Object> contextParameter = new LinkedHashMap<String, Object>();
    private final List<Runnable> closeHandlers = new ArrayList<Runnable>();
    @NotNull
    private final List<String> results = new ArrayList<String>();
    @Nullable
    private final ApplicationInstanceController instanceController;
    @Nullable
    private CLIProcessResult.PostAction postAction = null;

    public CommandLineContext(@Nullable ApplicationInstanceController instanceController) {
        this.instanceController = instanceController;
    }

    @NotNull
    public Map<String, Object> getContext() {
        return this.contextParameter;
    }

    @Nullable
    public <T> T getContextParameter(String name) {
        return (T)this.contextParameter.get(name);
    }

    public void setContextParameter(@NotNull String name, @NotNull Object value) {
        this.contextParameter.put(name, value);
    }

    public void addResult(@NotNull String result) {
        this.results.add(result);
    }

    @NotNull
    public List<String> getResults() {
        return List.copyOf(this.results);
    }

    public void addCloseHandler(@NotNull Runnable closeHandler) {
        this.closeHandlers.add(closeHandler);
    }

    @Nullable
    public CLIProcessResult.PostAction getPostAction() {
        return this.postAction;
    }

    public void setPostAction(@Nullable CLIProcessResult.PostAction postAction) {
        this.postAction = postAction;
    }

    @Nullable
    public ApplicationInstanceController getInstanceController() {
        return this.instanceController;
    }

    @Override
    public void close() {
        for (Runnable closeHandler : this.closeHandlers) {
            try {
                closeHandler.run();
            }
            catch (Exception e) {
                log.error((Object)("Error during close cli context: " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

