/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.decorations;

import java.util.List;
import java.util.Random;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.services.IDisposable;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;

record SnowflakeAtlas(@NotNull Image image, int count, int size, int step, int mips) implements IDisposable
{
    @NotNull
    static SnowflakeAtlas generate(@NotNull Display display, @NotNull List<? extends DBPImage> images, @NotNull RGB color, int size, int step, int mips) {
        ImageData data = SnowflakeAtlas.generateAtlasData(display, images, color, size, step, mips);
        Image image = new Image((Device)display, data);
        float scale = (float)image.getBounds().width / (float)(size * images.size());
        return new SnowflakeAtlas(image, images.size(), Math.round((float)size * scale), Math.round((float)step * scale), mips);
    }

    @NotNull
    private static ImageData generateAtlasData(@NotNull Display display, @NotNull List<? extends DBPImage> images, @NotNull RGB color, int size, int step, int mips) {
        Image image = new Image((Device)display, size * images.size(), size * mips - SnowflakeAtlas.sum(mips - 1) * step);
        Transform transform = new Transform((Device)display);
        GC gc = new GC((Drawable)image);
        Random random = new Random();
        try {
            gc.setAntialias(1);
            gc.setInterpolation(2);
            gc.setBackground(display.getSystemColor(11));
            gc.fillRectangle(0, 0, image.getBounds().width, image.getBounds().height);
            int i = 0;
            while (i < images.size()) {
                int j = 0;
                while (j < mips) {
                    Image sprite = DBeaverIcons.getImage(images.get(i));
                    Rectangle bounds = sprite.getBounds();
                    int scale = size - j * step;
                    int center = (int)((float)scale * 0.5f);
                    int angle = random.nextInt(360);
                    int x = i * scale;
                    int y = size * j - SnowflakeAtlas.sum(j - 1) * step;
                    transform.identity();
                    transform.translate((float)(x + center), (float)(y + center));
                    transform.rotate((float)angle);
                    gc.setTransform(transform);
                    gc.setAlpha(255 / random.nextInt(3, 8));
                    gc.drawImage(sprite, bounds.x, bounds.y, bounds.width, bounds.height, -center, -center, scale, scale);
                    ++j;
                }
                ++i;
            }
            ImageData result = image.getImageData();
            int filler = result.palette.getPixel(color);
            int y = 0;
            while (y < result.height) {
                int x = 0;
                while (x < result.width) {
                    RGB pixel = result.palette.getRGB(result.getPixel(x, y));
                    result.setAlpha(x, y, 255 - pixel.red);
                    result.setPixel(x, y, filler);
                    ++x;
                }
                ++y;
            }
            ImageData imageData = result;
            return imageData;
        }
        finally {
            transform.dispose();
            gc.dispose();
            image.dispose();
        }
    }

    int getSize(int mip) {
        return this.size - mip * this.step;
    }

    @NotNull
    Rectangle getClip(int index, int mip) {
        int mipSize = this.getSize(mip);
        int mipShift = SnowflakeAtlas.sum(mip - 1) * this.step;
        return new Rectangle(index * mipSize, mip * this.size - mipShift, mipSize, mipSize);
    }

    public void dispose() {
        this.image.dispose();
    }

    private static int sum(int n) {
        return n * (n + 1) / 2;
    }
}

