/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataType;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSEntityElement;

public abstract class OracleDataTypeMember
implements DBSEntityElement {
    private static final Log log = Log.getLog(OracleDataTypeMember.class);
    private OracleDataType ownerType;
    protected String name;
    protected int number;
    private boolean inherited;
    private boolean persisted;

    protected OracleDataTypeMember(OracleDataType ownerType) {
        this.ownerType = ownerType;
        this.persisted = false;
    }

    protected OracleDataTypeMember(OracleDataType ownerType, ResultSet dbResult) {
        this.ownerType = ownerType;
        this.inherited = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"INHERITED", (String)"YES");
        this.persisted = true;
    }

    @NotNull
    public OracleDataType getOwnerType() {
        return this.ownerType;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @NotNull
    public OracleDataType getParentObject() {
        return this.ownerType;
    }

    @NotNull
    public OracleDataSource getDataSource() {
        return this.ownerType.getDataSource();
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public int getNumber() {
        return this.number;
    }

    @Property(viewable=true, order=20)
    public boolean isInherited() {
        return this.inherited;
    }
}

