/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.loader.sources;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.sources.PackageSource;
import org.eclipse.osgi.internal.loader.sources.SingleSourcePackage;

public class MultiSourcePackage
extends PackageSource {
    private final SingleSourcePackage[] suppliers;

    public MultiSourcePackage(String id, SingleSourcePackage[] suppliers) {
        super(id);
        this.suppliers = suppliers;
    }

    @Override
    public SingleSourcePackage[] getSuppliers() {
        return this.suppliers;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> result = null;
        SingleSourcePackage[] singleSourcePackageArray = this.suppliers;
        int n = this.suppliers.length;
        int n2 = 0;
        while (n2 < n) {
            SingleSourcePackage supplier = singleSourcePackageArray[n2];
            result = supplier.loadClass(name);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        return result;
    }

    @Override
    public URL getResource(String name) {
        URL result = null;
        SingleSourcePackage[] singleSourcePackageArray = this.suppliers;
        int n = this.suppliers.length;
        int n2 = 0;
        while (n2 < n) {
            SingleSourcePackage supplier = singleSourcePackageArray[n2];
            result = supplier.getResource(name);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        return result;
    }

    @Override
    public Enumeration<URL> getResources(String name) {
        Enumeration<URL> results = null;
        SingleSourcePackage[] singleSourcePackageArray = this.suppliers;
        int n = this.suppliers.length;
        int n2 = 0;
        while (n2 < n) {
            SingleSourcePackage supplier = singleSourcePackageArray[n2];
            results = BundleLoader.compoundEnumerations(results, supplier.getResources(name));
            ++n2;
        }
        return results;
    }

    @Override
    public Collection<String> listResources(String path, String filePattern) {
        ArrayList<String> result = new ArrayList<String>();
        SingleSourcePackage[] singleSourcePackageArray = this.suppliers;
        int n = this.suppliers.length;
        int n2 = 0;
        while (n2 < n) {
            SingleSourcePackage source = singleSourcePackageArray[n2];
            Collection<String> sourceResources = source.listResources(path, filePattern);
            for (String resource : sourceResources) {
                if (result.contains(resource)) continue;
                result.add(resource);
            }
            ++n2;
        }
        return result;
    }
}

