/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.trino.model;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSQLDialect;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.trino.model.TrinoMetaModel;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformType;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.impl.sql.QueryTransformerLimit;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.utils.CommonUtils;

public class TrinoDataSource
extends GenericDataSource {
    TrinoDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container, @NotNull TrinoMetaModel metaModel) throws DBException {
        super(monitor, container, (GenericMetaModel)metaModel, (SQLDialect)new GenericSQLDialect());
    }

    @NotNull
    public DBPErrorAssistant.ErrorType discoverErrorType(@NotNull Throwable error) {
        String message = error.getMessage();
        if (CommonUtils.isNotEmpty((String)message)) {
            if (message.contains("Connection is closed") || message.contains("Connection is already closed")) {
                return DBPErrorAssistant.ErrorType.CONNECTION_LOST;
            }
            if (CommonUtils.isNotEmpty((String)message) && message.contains("SQL Error [13]:")) {
                return DBPErrorAssistant.ErrorType.FEATURE_UNSUPPORTED;
            }
            if (CommonUtils.isNotEmpty((String)message) && message.contains("Error [22]:")) {
                return DBPErrorAssistant.ErrorType.TRANSACTION_ABORTED;
            }
        }
        return super.discoverErrorType(error);
    }

    @Nullable
    public DBCQueryTransformer createQueryTransformer(@NotNull DBCQueryTransformType type) {
        if (type == DBCQueryTransformType.RESULT_SET_LIMIT) {
            return new QueryTransformerLimit(false, false);
        }
        return null;
    }
}

