/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.histogram;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.DateTickUnitType;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.time.Day;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Minute;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.Week;
import org.jfree.data.time.Year;
import org.jfree.data.xy.XYDataset;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.dashboard.DBDashboardFetchType;
import org.jkiss.dbeaver.model.dashboard.DBDashboardInterval;
import org.jkiss.dbeaver.model.dashboard.DBDashboardValueType;
import org.jkiss.dbeaver.model.dashboard.data.DashboardDataset;
import org.jkiss.dbeaver.model.dashboard.data.DashboardDatasetRow;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardItemConfiguration;
import org.jkiss.dbeaver.ui.AWTUtils;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.charts.BaseChartDrawingSupplier;
import org.jkiss.dbeaver.ui.dashboard.DashboardUIUtils;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardChartComposite;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardRendererDatabaseChart;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardViewItem;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardItemContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardItemViewSettings;

public class DashboardRendererTimeseries
extends DashboardRendererDatabaseChart {
    private static final Font DEFAULT_TICK_LABEL_FONT = new Font("SansSerif", 0, 8);
    public static final int MAX_TIMESERIES_RANGE_LABELS = 25;

    public DashboardChartComposite createDashboard(@NotNull Composite composite, @NotNull DashboardItemContainer container, @NotNull DashboardContainer viewContainer, @NotNull Point preferredSize) {
        DashboardItemConfiguration dashboard = container.getItemDescriptor();
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        DashboardItemViewSettings viewConfig = container.getItemConfiguration();
        Color gridColor = AWTUtils.makeAWTColor((org.eclipse.swt.graphics.Color)UIStyles.getDefaultTextForeground());
        JFreeChart histogramChart = ChartFactory.createXYLineChart(null, (String)"Time", (String)"Value", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        histogramChart.setBorderVisible(false);
        histogramChart.setPadding(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        histogramChart.setTextAntiAlias(true);
        histogramChart.setBackgroundPaint((Paint)AWTUtils.makeAWTColor((org.eclipse.swt.graphics.Color)UIStyles.getDefaultTextBackground()));
        this.createDefaultLegend(viewConfig, histogramChart);
        ChartPanel chartPanel = new ChartPanel(histogramChart);
        chartPanel.setPreferredSize(new Dimension(preferredSize.x, preferredSize.y));
        XYPlot plot = histogramChart.getXYPlot();
        plot.setOutlinePaint(null);
        plot.setShadowGenerator(null);
        plot.setDrawingSupplier((DrawingSupplier)new BaseChartDrawingSupplier());
        plot.getRenderer().setDefaultToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{0}: ({1}, {2})", DateFormat.getDateTimeInstance(3, 3), NumberFormat.getNumberInstance()));
        DateAxis domainAxis = new DateAxis("Time");
        domainAxis.setDateFormatOverride((DateFormat)new SimpleDateFormat("HH:mm:ss"));
        domainAxis.setTickMarkPosition(DateTickMarkPosition.MIDDLE);
        domainAxis.setAutoRange(true);
        domainAxis.setLabel(null);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setTickLabelPaint((Paint)gridColor);
        domainAxis.setTickLabelFont(DEFAULT_TICK_LABEL_FONT);
        domainAxis.setTickLabelInsets(RectangleInsets.ZERO_INSETS);
        DateTickUnitType unitType = switch (dashboard.getInterval()) {
            case DBDashboardInterval.minute -> DateTickUnitType.MINUTE;
            case DBDashboardInterval.hour -> DateTickUnitType.HOUR;
            case DBDashboardInterval.day, DBDashboardInterval.week -> DateTickUnitType.DAY;
            case DBDashboardInterval.month -> DateTickUnitType.MONTH;
            case DBDashboardInterval.year -> DateTickUnitType.YEAR;
            default -> DateTickUnitType.SECOND;
        };
        int tickCount = container.getDashboardMaxItems();
        if (tickCount > 40) {
            tickCount = container.getDashboardMaxItems() / 5;
        }
        if (tickCount <= 1) {
            tickCount = 10;
        }
        domainAxis.setTickUnit(new DateTickUnit(unitType, Math.min(25, tickCount)));
        if (viewConfig != null && !viewConfig.isDomainTicksVisible()) {
            domainAxis.setVisible(false);
        }
        plot.setDomainAxis((ValueAxis)domainAxis);
        ValueAxis rangeAxis = plot.getRangeAxis();
        rangeAxis.setLabel(null);
        rangeAxis.setTickLabelPaint((Paint)gridColor);
        rangeAxis.setTickLabelFont(DEFAULT_TICK_LABEL_FONT);
        rangeAxis.setTickLabelInsets(RectangleInsets.ZERO_INSETS);
        rangeAxis.setStandardTickUnits(DashboardUIUtils.getTickUnitsSource(dashboard.getValueType()));
        if (dashboard.getValueType() == DBDashboardValueType.percent) {
            rangeAxis.setLowerBound(0.0);
            rangeAxis.setUpperBound(100.0);
        }
        if (viewConfig != null && !viewConfig.isRangeTicksVisible()) {
            rangeAxis.setVisible(false);
        }
        XYItemRenderer plotRenderer = plot.getRenderer();
        plotRenderer.setDefaultItemLabelPaint((Paint)gridColor);
        BasicStroke stroke = new BasicStroke(2.0f, 0, 1, 10.0f, null, 0.0f);
        plot.getRenderer().setDefaultStroke((Stroke)stroke);
        plot.setBackgroundPaint(histogramChart.getBackgroundPaint());
        plot.setDomainGridlinePaint((Paint)gridColor);
        plot.setDomainGridlinesVisible(viewConfig == null || viewConfig.isGridVisible());
        plot.setRangeGridlinePaint((Paint)gridColor);
        plot.setRangeGridlinesVisible(viewConfig == null || viewConfig.isGridVisible());
        DashboardChartComposite chartComposite = this.createChartComposite(composite, container, viewContainer, preferredSize);
        chartComposite.setChart(histogramChart);
        return chartComposite;
    }

    @Override
    public void updateDashboardData(@NotNull DashboardItemContainer container, @Nullable Date lastUpdateTime, @NotNull DashboardDataset dataset) {
        long secondsPassed;
        DashboardChartComposite chartComposite = this.getChartComposite(container);
        if (chartComposite.isDisposed()) {
            return;
        }
        JFreeChart chart = chartComposite.getChart();
        XYPlot plot = (XYPlot)chart.getPlot();
        TimeSeriesCollection chartDataset = (TimeSeriesCollection)plot.getDataset();
        DashboardItemConfiguration dashboard = container.getItemDescriptor();
        if (dashboard.getFetchType() == DBDashboardFetchType.stats) {
            chartDataset.removeAllSeries();
        }
        long currentTime = System.currentTimeMillis();
        long l = secondsPassed = lastUpdateTime == null ? 1L : (currentTime - lastUpdateTime.getTime()) / 1000L;
        if (secondsPassed <= 0L) {
            secondsPassed = 1L;
        }
        DashboardDatasetRow lastRow = (DashboardDatasetRow)chartComposite.getData("last_row");
        List rows = dataset.getRows();
        String[] srcSeries = dataset.getColumnNames();
        int i = 0;
        while (i < srcSeries.length) {
            String seriesName = srcSeries[i];
            TimeSeries series = chartDataset.getSeries((Comparable)((Object)seriesName));
            if (series == null) {
                series = new TimeSeries((Comparable)((Object)seriesName));
                series.setMaximumItemCount(container.getDashboardMaxItems());
                series.setMaximumItemAge(container.getDashboardMaxAge());
                chartDataset.addSeries(series);
                plot.getRenderer().setSeriesStroke(chartDataset.getSeriesCount() - 1, plot.getRenderer().getDefaultStroke());
            }
            block0 : switch (dashboard.getCalcType()) {
                case value: {
                    int maxDP = 200;
                    Date startTime = null;
                    for (DashboardDatasetRow row : rows) {
                        long diffSeconds;
                        if (startTime == null) {
                            startTime = row.getTimestamp();
                        } else if ((dashboard.getInterval() == DBDashboardInterval.second || dashboard.getInterval() == DBDashboardInterval.millisecond) && (diffSeconds = (row.getTimestamp().getTime() - startTime.getTime()) / 1000L) > (long)maxDP) break block0;
                        Object value = row.getValues()[i];
                        if (!(value instanceof Number)) continue;
                        series.addOrUpdate(this.makeDataItem(container, row), (Number)value);
                    }
                    break;
                }
                case delta: {
                    if (lastUpdateTime == null) {
                        return;
                    }
                    for (DashboardDatasetRow row : rows) {
                        if (lastRow == null) continue;
                        Object prevValue = lastRow.getValues()[i];
                        Object newValue = row.getValues()[i];
                        if (!(newValue instanceof Number) || !(prevValue instanceof Number)) continue;
                        double deltaValue = ((Number)newValue).doubleValue() - ((Number)prevValue).doubleValue();
                        deltaValue /= (double)secondsPassed;
                        if (dashboard.getValueType() != DBDashboardValueType.decimal) {
                            deltaValue = Math.round(deltaValue);
                        }
                        series.addOrUpdate(this.makeDataItem(container, row), deltaValue);
                    }
                    break;
                }
            }
            ++i;
        }
        if (!rows.isEmpty()) {
            chartComposite.setData("last_row", rows.get(rows.size() - 1));
        }
    }

    private RegularTimePeriod makeDataItem(DashboardItemContainer container, DashboardDatasetRow row) {
        return switch (container.getItemDescriptor().getInterval()) {
            case DBDashboardInterval.second -> new FixedMillisecond(row.getTimestamp().getTime());
            case DBDashboardInterval.minute -> new Minute(row.getTimestamp());
            case DBDashboardInterval.hour -> new Hour(row.getTimestamp());
            case DBDashboardInterval.day -> new Day(row.getTimestamp());
            case DBDashboardInterval.week -> new Week(row.getTimestamp());
            case DBDashboardInterval.month -> new Month(row.getTimestamp());
            case DBDashboardInterval.year -> new Year(row.getTimestamp());
            default -> new FixedMillisecond(row.getTimestamp().getTime());
        };
    }

    @Override
    public void resetDashboardData(@NotNull DashboardItemContainer container, Date lastUpdateTime) {
        XYPlot plot = this.getDashboardPlot(container);
        if (plot != null) {
            TimeSeriesCollection chartDataset = (TimeSeriesCollection)plot.getDataset();
            chartDataset.removeAllSeries();
        }
    }

    @Override
    public void updateDashboardView(@NotNull DashboardViewItem dashboardItem) {
        XYPlot plot = this.getDashboardPlot(dashboardItem);
        if (plot != null) {
            DashboardChartComposite chartComposite = this.getChartComposite(dashboardItem);
            DashboardItemViewSettings dashboardConfig = dashboardItem.getItemConfiguration();
            if (dashboardConfig != null) {
                plot.getRangeAxis().setVisible(dashboardConfig.isRangeTicksVisible());
                plot.getDomainAxis().setVisible(dashboardConfig.isDomainTicksVisible());
                plot.setDomainGridlinesVisible(dashboardConfig.isGridVisible());
                plot.setRangeGridlinesVisible(dashboardConfig.isGridVisible());
                chartComposite.getChart().getLegend().setVisible(dashboardConfig.isLegendVisible());
                TimeSeriesCollection chartDataset = (TimeSeriesCollection)plot.getDataset();
                int i = 0;
                while (i < chartDataset.getSeriesCount()) {
                    TimeSeries series = chartDataset.getSeries(i);
                    series.setMaximumItemCount(dashboardConfig.getMaxItems());
                    series.setMaximumItemAge(dashboardConfig.getMaxAge());
                    ++i;
                }
            }
        }
        dashboardItem.getParent().layout(true, true);
    }

    private XYPlot getDashboardPlot(DashboardItemContainer container) {
        DashboardChartComposite chartComposite = this.getChartComposite(container);
        JFreeChart chart = chartComposite.getChart();
        return chart == null ? null : (XYPlot)chart.getPlot();
    }
}

