/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.db.Cursor;
import com.sleepycat.db.CursorConfig;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.JoinCursor;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.Transaction;
import com.sleepycat.persist.BasicIndex;
import com.sleepycat.persist.BasicIterator;
import com.sleepycat.persist.ForwardCursor;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.SecondaryIndex;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EntityJoin<PK, E> {
    private PrimaryIndex<PK, E> primary;
    private List<Condition> conditions;

    public EntityJoin(PrimaryIndex<PK, E> primaryIndex) {
        this.primary = primaryIndex;
        this.conditions = new ArrayList<Condition>();
    }

    public <SK> void addCondition(SecondaryIndex<SK, PK, E> secondaryIndex, SK SK) {
        DatabaseEntry databaseEntry = new DatabaseEntry();
        secondaryIndex.getKeyBinding().objectToEntry(SK, databaseEntry);
        Database database = secondaryIndex.getKeysDatabase();
        if (database == null) {
            database = secondaryIndex.getDatabase();
        }
        this.conditions.add(new Condition(database, databaseEntry));
    }

    public ForwardCursor<E> entities() throws DatabaseException {
        return this.entities(null, null);
    }

    public ForwardCursor<E> entities(Transaction transaction, CursorConfig cursorConfig) throws DatabaseException {
        return new JoinForwardCursor(transaction, cursorConfig, false);
    }

    public ForwardCursor<PK> keys() throws DatabaseException {
        return this.keys(null, null);
    }

    public ForwardCursor<PK> keys(Transaction transaction, CursorConfig cursorConfig) throws DatabaseException {
        return new JoinForwardCursor(transaction, cursorConfig, true);
    }

    private static class Condition {
        private Database db;
        private DatabaseEntry key;

        Condition(Database database, DatabaseEntry databaseEntry) {
            this.db = database;
            this.key = databaseEntry;
        }

        Cursor openCursor(Transaction transaction, CursorConfig cursorConfig) throws DatabaseException {
            OperationStatus operationStatus;
            Cursor cursor = this.db.openCursor(transaction, cursorConfig);
            try {
                DatabaseEntry databaseEntry = BasicIndex.NO_RETURN_ENTRY;
                operationStatus = cursor.getSearchKey(this.key, databaseEntry, null);
            }
            catch (DatabaseException databaseException) {
                try {
                    cursor.close();
                }
                catch (DatabaseException databaseException2) {
                    // empty catch block
                }
                throw databaseException;
            }
            if (operationStatus == OperationStatus.SUCCESS) {
                return cursor;
            }
            cursor.close();
            return null;
        }
    }

    private class JoinForwardCursor<V>
    implements ForwardCursor<V> {
        private Cursor[] cursors;
        private JoinCursor joinCursor;
        private boolean doKeys;

        JoinForwardCursor(Transaction transaction, CursorConfig cursorConfig, boolean bl) throws DatabaseException {
            this.doKeys = bl;
            try {
                this.cursors = new Cursor[EntityJoin.this.conditions.size()];
                for (int i = 0; i < this.cursors.length; ++i) {
                    Condition condition = (Condition)EntityJoin.this.conditions.get(i);
                    Cursor cursor = condition.openCursor(transaction, cursorConfig);
                    if (cursor == null) {
                        this.doClose(null);
                        return;
                    }
                    this.cursors[i] = cursor;
                }
                this.joinCursor = EntityJoin.this.primary.getDatabase().join(this.cursors, null);
            }
            catch (DatabaseException databaseException) {
                this.doClose(databaseException);
            }
        }

        @Override
        public V next() throws DatabaseException {
            return this.next(null);
        }

        @Override
        public V next(LockMode lockMode) throws DatabaseException {
            if (this.joinCursor == null) {
                return null;
            }
            if (this.doKeys) {
                DatabaseEntry databaseEntry = new DatabaseEntry();
                OperationStatus operationStatus = this.joinCursor.getNext(databaseEntry, lockMode);
                if (operationStatus == OperationStatus.SUCCESS) {
                    EntryBinding entryBinding = EntityJoin.this.primary.getKeyBinding();
                    return (V)entryBinding.entryToObject(databaseEntry);
                }
            } else {
                DatabaseEntry databaseEntry = new DatabaseEntry();
                DatabaseEntry databaseEntry2 = new DatabaseEntry();
                OperationStatus operationStatus = this.joinCursor.getNext(databaseEntry, databaseEntry2, lockMode);
                if (operationStatus == OperationStatus.SUCCESS) {
                    EntityBinding entityBinding = EntityJoin.this.primary.getEntityBinding();
                    return (V)entityBinding.entryToObject(databaseEntry, databaseEntry2);
                }
            }
            return null;
        }

        @Override
        public Iterator<V> iterator() {
            return this.iterator(null);
        }

        @Override
        public Iterator<V> iterator(LockMode lockMode) {
            return new BasicIterator(this, lockMode);
        }

        @Override
        public void close() throws DatabaseException {
            this.doClose(null);
        }

        private void doClose(DatabaseException databaseException) throws DatabaseException {
            block7: {
                if (this.joinCursor != null) {
                    try {
                        this.joinCursor.close();
                        this.joinCursor = null;
                    }
                    catch (DatabaseException databaseException2) {
                        if (databaseException != null) break block7;
                        databaseException = databaseException2;
                    }
                }
            }
            for (int i = 0; i < this.cursors.length; ++i) {
                Cursor cursor = this.cursors[i];
                if (cursor == null) continue;
                try {
                    cursor.close();
                    this.cursors[i] = null;
                    continue;
                }
                catch (DatabaseException databaseException3) {
                    if (databaseException != null) continue;
                    databaseException = databaseException3;
                }
            }
            if (databaseException != null) {
                throw databaseException;
            }
        }
    }
}

