/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.db.DatabaseEntry;

public class CharacterBinding
extends TupleBinding {
    private static final int CHAR_SIZE = 2;

    @Override
    public Object entryToObject(TupleInput tupleInput) {
        return new Character(tupleInput.readChar());
    }

    @Override
    public void objectToEntry(Object object, TupleOutput tupleOutput) {
        tupleOutput.writeChar(((Character)object).charValue());
    }

    @Override
    protected TupleOutput getTupleOutput(Object object) {
        return CharacterBinding.sizedOutput();
    }

    public static char entryToChar(DatabaseEntry databaseEntry) {
        return CharacterBinding.entryToInput(databaseEntry).readChar();
    }

    public static void charToEntry(char c, DatabaseEntry databaseEntry) {
        CharacterBinding.outputToEntry(CharacterBinding.sizedOutput().writeChar(c), databaseEntry);
    }

    private static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[2]);
    }
}

