/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.ArrayList;
import java.util.Arrays;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.Expr;
import org.basex.query.expr.If;
import org.basex.query.expr.List;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.SwitchGroup;
import org.basex.query.expr.TypeCheck;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.Array;
import org.basex.util.Checks;
import org.basex.util.InputInfo;
import org.basex.util.Util;
import org.basex.util.hash.IntObjectMap;

public final class Switch
extends ParseExpr {
    private Expr cond;
    private SwitchGroup[] groups;

    public Switch(InputInfo info, Expr cond, SwitchGroup[] groups) {
        super(info, Types.ITEM_ZM);
        this.cond = cond;
        this.groups = groups;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoUp(this.cond);
        for (SwitchGroup group : this.groups) {
            group.checkUp();
        }
        ExprList rtrns = new ExprList(this.groups.length);
        for (SwitchGroup group : this.groups) {
            rtrns.add(group.rtrn());
        }
        this.checkAllUp((Expr[])rtrns.finish());
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        this.cond = this.cond.compile(cc);
        for (SwitchGroup group : this.groups) {
            group.compile(cc);
        }
        return this.optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.cond = this.cond.simplifyFor(CompileContext.Simplify.STRING, cc);
        Expr expr = this.opt(cc);
        if (expr != this) {
            return cc.replaceWith(this, expr);
        }
        this.exprType.assign(SeqType.union(this.groups, true)).data(this.groups);
        return this;
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        boolean changed = false;
        for (SwitchGroup group : this.groups) {
            changed |= group.simplifyFor(mode, cc) == null;
        }
        return changed ? this.optimize(cc) : super.simplifyFor(mode, cc);
    }

    private Expr opt(CompileContext cc) throws QueryException {
        Expr expr;
        ExprList cases = new ExprList();
        Item cnd = this.cond instanceof Value ? this.cond.atomItem(cc.qc, this.info) : null;
        ArrayList<SwitchGroup> tmpGroups = new ArrayList<SwitchGroup>();
        for (SwitchGroup group : this.groups) {
            int el = group.exprs.length;
            ExprList list = (ExprList)((Object)new ExprList(el).add(group.rtrn()));
            for (int e = 1; e < el; ++e) {
                Expr expr2 = group.exprs[e];
                boolean remove = cases.contains(expr2);
                if (!remove && cnd != null) {
                    if (expr2 instanceof Value) {
                        if (group.match(cnd, e, cc.qc)) {
                            return group.rtrn();
                        }
                        remove = true;
                    } else {
                        cnd = null;
                    }
                }
                if (remove) {
                    cc.info("remove % from %", expr2, this::description);
                    continue;
                }
                cases.add(expr2);
                list.add(expr2);
            }
            if (list.size() <= 1 && el != 1) continue;
            group.exprs = (Expr[])list.finish();
            tmpGroups.add(group);
        }
        for (int g = 0; g < tmpGroups.size(); ++g) {
            SwitchGroup group1 = g > 0 ? (SwitchGroup)tmpGroups.get(g - 1) : null;
            SwitchGroup group2 = (SwitchGroup)tmpGroups.get(g);
            if (g <= 0 || !group1.rtrn().equals(group2.rtrn())) continue;
            if (g + 1 == tmpGroups.size() && !group1.has(Flag.NDT)) {
                tmpGroups.set(g - 1, group2);
            } else {
                ExprList list = new ExprList(group1.exprs.length + group2.exprs.length - 1);
                ((ExprList)list.add(group1.exprs)).add(Arrays.copyOfRange(group2.exprs, 1, group2.exprs.length));
                tmpGroups.set(g - 1, new SwitchGroup(group1.info, (Expr[])list.finish()).optimize(cc));
            }
            tmpGroups.remove(g--);
        }
        if (tmpGroups.size() != this.groups.length) {
            this.groups = (SwitchGroup[])tmpGroups.toArray(SwitchGroup[]::new);
            cc.info("simplify %: %", this::description, this);
        }
        if ((expr = this.simplify()) == this) {
            expr = this.toIf(cc);
        }
        return expr;
    }

    private Expr simplify() {
        Expr expr = this.groups[0].rtrn();
        for (int g = this.groups.length - 1; g >= 1; --g) {
            if (expr.equals(this.groups[g].rtrn())) continue;
            return this;
        }
        return expr;
    }

    private Expr toIf(CompileContext cc) throws QueryException {
        if (this.groups.length != 2) {
            return this;
        }
        SeqType st = this.cond.seqType();
        boolean string = st.type.isStringOrUntyped();
        boolean dec = st.type.instanceOf(AtomType.DECIMAL);
        if (!st.one() || !string && !dec) {
            return this;
        }
        Expr[] exprs = this.groups[0].exprs;
        for (int e = exprs.length - 1; e >= 1; --e) {
            SeqType est = exprs[e].seqType();
            if (est.oneOrMore() && (string && est.type.isStringOrUntyped() || dec && est.type.instanceOf(AtomType.DECIMAL))) continue;
            return this;
        }
        Expr list = List.get(cc, this.groups[0].info, Arrays.copyOfRange(exprs, 1, exprs.length));
        CmpG cmp = new CmpG(this.groups[0].info, this.cond, list, CmpG.OpG.EQ);
        return new If(this.info, cmp.optimize(cc), this.groups[0].rtrn(), this.groups[1].rtrn()).optimize(cc);
    }

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.expr(qc).iter(qc);
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.expr(qc).value(qc);
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        return this.expr(qc).item(qc, this.info);
    }

    private Expr expr(QueryContext qc) throws QueryException {
        Item item = this.cond.atomItem(qc, this.info);
        for (SwitchGroup group : this.groups) {
            if (!group.match(item, qc)) continue;
            return group.rtrn();
        }
        throw Util.notExpected();
    }

    @Override
    public boolean vacuous() {
        return ((Checks<SwitchGroup>)group -> group.rtrn().vacuous()).all((SwitchGroup[])this.groups);
    }

    @Override
    public boolean ddo() {
        return ((Checks<SwitchGroup>)group -> group.rtrn().ddo()).all((SwitchGroup[])this.groups);
    }

    @Override
    public boolean has(Flag ... flags) {
        for (SwitchGroup group : this.groups) {
            if (!group.has(flags)) continue;
            return true;
        }
        return this.cond.has(flags);
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        for (SwitchGroup group : this.groups) {
            if (group.inlineable(ic)) continue;
            return false;
        }
        return this.cond.inlineable(ic);
    }

    @Override
    public VarUsage count(Var var) {
        VarUsage max = VarUsage.NEVER;
        VarUsage uses = VarUsage.NEVER;
        for (SwitchGroup cs : this.groups) {
            uses = uses.plus(cs.countCases(var));
            max = max.max(uses.plus(cs.count(var)));
        }
        return max.plus(this.cond.count(var));
    }

    @Override
    public Expr inline(InlineContext ic) throws QueryException {
        boolean changed = ic.inline(this.groups, true);
        Expr inlined = this.cond.inline(ic);
        if (inlined != null) {
            changed = true;
            this.cond = inlined;
        }
        return changed ? this.optimize(ic.cc) : null;
    }

    @Override
    public Expr typeCheck(TypeCheck tc, CompileContext cc) throws QueryException {
        boolean changed = false;
        for (SwitchGroup group : this.groups) {
            changed = group.typeCheck(tc, cc) != null;
        }
        return changed ? this.optimize(cc) : this;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new Switch(this.info, this.cond.copy(cc, vm), (SwitchGroup[])Arr.copyAll((CompileContext)cc, vm, (Expr[])this.groups)));
    }

    @Override
    public void markTailCalls(CompileContext cc) {
        for (SwitchGroup group : this.groups) {
            group.markTailCalls(cc);
        }
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return this.cond.accept(visitor) && Switch.visitAll(visitor, this.groups);
    }

    @Override
    public int exprSize() {
        int size = 1;
        for (SwitchGroup group : this.groups) {
            size += ((Expr)group).exprSize();
        }
        return size;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Switch)) return false;
        Switch s = (Switch)obj;
        if (!this.cond.equals(s.cond)) return false;
        if (!Array.equals(this.groups, s.groups)) return false;
        return true;
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, new Object[0]), new Object[]{this.cond, this.groups});
    }

    @Override
    public void toString(QueryString qs) {
        qs.token("switch").paren(this.cond).tokens(this.groups);
    }
}

