/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.json;

import java.io.IOException;
import org.basex.build.json.JsonOptions;
import org.basex.build.json.JsonParserOptions;
import org.basex.io.IO;
import org.basex.io.in.NewlineInput;
import org.basex.io.in.TextInput;
import org.basex.io.parse.json.JsonAttsConverter;
import org.basex.io.parse.json.JsonDirectConverter;
import org.basex.io.parse.json.JsonMLConverter;
import org.basex.io.parse.json.JsonParser;
import org.basex.io.parse.json.JsonW3Converter;
import org.basex.io.parse.json.JsonW3XmlConverter;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryFunction;
import org.basex.query.util.SharedData;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;

public abstract class JsonConverter {
    protected final SharedData shared = new SharedData();
    protected final JsonParserOptions jopts;
    protected QueryFunction<byte[], byte[]> fallback;
    protected QueryFunction<byte[], Item> numberParser;
    protected Value nullValue = Empty.VALUE;
    protected QueryContext qctx;

    public static JsonConverter get(JsonParserOptions jopts) throws QueryException {
        return switch (jopts.get(JsonOptions.FORMAT)) {
            case JsonOptions.JsonFormat.ATTRIBUTES -> new JsonAttsConverter(jopts);
            case JsonOptions.JsonFormat.JSONML -> new JsonMLConverter(jopts);
            case JsonOptions.JsonFormat.W3, JsonOptions.JsonFormat.XQUERY -> new JsonW3Converter(jopts);
            case JsonOptions.JsonFormat.W3_XML, JsonOptions.JsonFormat.BASIC -> new JsonW3XmlConverter(jopts);
            default -> new JsonDirectConverter(jopts);
        };
    }

    protected JsonConverter(JsonParserOptions jopts) {
        this.jopts = jopts;
    }

    public final void fallback(QueryFunction<byte[], byte[]> func) {
        this.fallback = func;
    }

    public final void numberParser(QueryFunction<byte[], Item> func) {
        this.numberParser = func;
    }

    public final void nullValue(Value item) {
        this.nullValue = item;
    }

    public final Value convert(IO input) throws QueryException, IOException {
        String encoding = this.jopts.get(JsonParserOptions.ENCODING);
        try (NewlineInput ni = new NewlineInput(input, encoding);){
            Value value = this.convert(ni, input.url(), null, null);
            return value;
        }
    }

    public final Value convert(TextInput input, String uri, InputInfo ii, QueryContext qc) throws QueryException, IOException {
        this.qctx = qc;
        this.init(uri);
        new JsonParser(input, this.jopts, this).parse(ii);
        return this.finish();
    }

    protected abstract void init(String var1);

    protected abstract Item finish();

    protected abstract void openObject() throws QueryException;

    protected abstract void closeObject();

    protected abstract void openPair(byte[] var1, boolean var2) throws QueryException;

    protected abstract void closePair(boolean var1) throws QueryException;

    protected abstract void openArray() throws QueryException;

    protected abstract void closeArray() throws QueryException;

    protected abstract void openItem();

    protected abstract void closeItem();

    protected abstract void numberLit(byte[] var1) throws QueryException;

    protected abstract void stringLit(byte[] var1) throws QueryException;

    protected abstract void nullLit() throws QueryException;

    protected abstract void booleanLit(byte[] var1) throws QueryException;
}

