/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.util.Locale;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.core.users.Perm;
import org.basex.util.Prop;
import org.basex.util.Util;
import org.basex.util.options.Option;
import org.basex.util.options.Options;

public final class Set
extends Command {
    public <O extends Option<V>, V> Set(O option, V value) {
        this(option.name(), value);
    }

    public Set(String name, Object value) {
        super(Perm.NONE, name, value == null ? "" : value.toString());
    }

    @Override
    protected boolean run() {
        String name = this.args[0].toUpperCase(Locale.ENGLISH);
        String val = this.args[1];
        Options opts = this.options;
        boolean debug = false;
        if (this.context.user().has(Perm.ADMIN)) {
            Option<?> opt = this.soptions.option(name);
            if (opt == StaticOptions.DEBUG) {
                debug = true;
                opts = this.soptions;
            } else if (opt != null) {
                return this.error(Text.GLOBAL_OPTION_X, name);
            }
        }
        try {
            opts.assign(name, val);
            if (debug) {
                Prop.debug = opts.get(StaticOptions.DEBUG);
            }
            return this.info(name + ": " + String.valueOf(opts.get(opts.option(name))), new Object[0]);
        }
        catch (BaseXException ex) {
            Util.debug(ex);
            return this.error(Util.message(ex), new Object[0]);
        }
    }

    @Override
    public void addLocks() {
    }
}

