/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.imagery;

import java.awt.image.BufferedImage;
import java.awt.image.LookupOp;
import java.awt.image.ShortLookupTable;
import java.util.Collections;
import java.util.Map;
import org.openstreetmap.josm.io.session.SessionAwareReadApply;
import org.openstreetmap.josm.tools.ImageProcessor;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class GammaImageProcessor
implements ImageProcessor,
SessionAwareReadApply {
    private double gamma = 1.0;
    final short[] gammaChange = new short[256];
    private final LookupOp op3 = new LookupOp(new ShortLookupTable(0, new short[][]{this.gammaChange, this.gammaChange, this.gammaChange}), null);
    private final LookupOp op4 = new LookupOp(new ShortLookupTable(0, new short[][]{this.gammaChange, this.gammaChange, this.gammaChange, this.gammaChange}), null);

    public double getGamma() {
        return this.gamma;
    }

    public void setGamma(double gamma) {
        this.gamma = gamma;
        for (int i = 0; i < 256; ++i) {
            this.gammaChange[i] = (short)(255.0 * Math.pow((double)i / 255.0, gamma));
        }
    }

    @Override
    public BufferedImage process(BufferedImage image) {
        if (this.gamma == 1.0) {
            return image;
        }
        try {
            int bands = image.getRaster().getNumBands();
            if (image.getType() != 0 && bands == 3) {
                return this.op3.filter(image, null);
            }
            if (image.getType() != 0 && bands == 4) {
                return this.op4.filter(image, null);
            }
        }
        catch (IllegalArgumentException ignore) {
            Logging.trace(ignore);
        }
        int type = image.getTransparency() == 1 ? 1 : 2;
        BufferedImage to = new BufferedImage(image.getWidth(), image.getHeight(), type);
        to.getGraphics().drawImage(image, 0, 0, null);
        return this.process(to);
    }

    @Override
    public void applyFromPropertiesMap(Map<String, String> properties) {
        String cStr = properties.get("gamma");
        if (cStr != null) {
            try {
                this.setGamma(Double.parseDouble(cStr));
            }
            catch (NumberFormatException e) {
                Logging.trace(e);
            }
        }
    }

    @Override
    public Map<String, String> toPropertiesMap() {
        if (Utils.equalsEpsilon(this.gamma, 1.0)) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap("gamma", Double.toString(this.gamma));
    }

    public String toString() {
        return "GammaImageProcessor [gamma=" + this.gamma + "]";
    }
}

