/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.IFilterablePrimitive;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.search.SearchMode;
import org.openstreetmap.josm.data.osm.search.SearchParseError;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

public class FilterMatcher {
    private final List<FilterInfo> hiddenFilters = new ArrayList<FilterInfo>();
    private final List<FilterInfo> disabledFilters = new ArrayList<FilterInfo>();

    public void update(Collection<Filter> filters) throws SearchParseError {
        this.reset();
        for (Filter filter : filters) {
            this.add(filter);
        }
    }

    public void reset() {
        this.hiddenFilters.clear();
        this.disabledFilters.clear();
    }

    public boolean hasFilters() {
        return !this.hiddenFilters.isEmpty() || !this.disabledFilters.isEmpty();
    }

    public void add(Filter filter) throws SearchParseError {
        if (!filter.enable) {
            return;
        }
        FilterInfo fi = new FilterInfo(filter);
        if (fi.isDelete) {
            if (filter.hiding) {
                this.hiddenFilters.add(fi);
            } else {
                this.disabledFilters.add(fi);
                this.hiddenFilters.add(fi);
            }
        } else {
            if (filter.mode == SearchMode.replace && filter.hiding) {
                this.hiddenFilters.clear();
                this.disabledFilters.clear();
            }
            this.disabledFilters.add(fi);
            if (filter.hiding) {
                this.hiddenFilters.add(fi);
            }
        }
    }

    private static boolean isFiltered(IPrimitive primitive, boolean hidden) {
        return hidden ? primitive.isDisabledAndHidden() : primitive.isDisabled();
    }

    private static <T extends IFilterablePrimitive> boolean isFilterExplicit(T primitive, boolean hidden) {
        return hidden ? primitive.getHiddenType() : primitive.getDisabledType();
    }

    private static <T extends IPrimitive & IFilterablePrimitive> boolean allParentWaysFiltered(T primitive, boolean hidden) {
        List<? extends IPrimitive> refs = primitive.getReferrers();
        boolean isExplicit = false;
        for (IPrimitive iPrimitive : refs) {
            if (!(iPrimitive instanceof IWay) || !(iPrimitive instanceof IFilterablePrimitive)) continue;
            if (!FilterMatcher.isFiltered(iPrimitive, hidden)) {
                return false;
            }
            isExplicit |= FilterMatcher.isFilterExplicit((IFilterablePrimitive)((Object)iPrimitive), hidden);
        }
        return isExplicit;
    }

    private static boolean oneParentWayNotFiltered(IPrimitive primitive, boolean hidden) {
        return primitive.getReferrers().stream().filter(IWay.class::isInstance).map(IWay.class::cast).anyMatch(p -> !FilterMatcher.isFiltered(p, hidden));
    }

    private static boolean allParentMultipolygonsFiltered(IPrimitive primitive, boolean hidden) {
        boolean isExplicit = false;
        for (IRelation r : new SubclassFilteredCollection(primitive.getReferrers(), i -> i.isMultipolygon() && i instanceof IFilterablePrimitive)) {
            if (!FilterMatcher.isFiltered(r, hidden)) {
                return false;
            }
            isExplicit |= FilterMatcher.isFilterExplicit((IFilterablePrimitive)((Object)r), hidden);
        }
        return isExplicit;
    }

    private static boolean oneParentMultipolygonNotFiltered(IPrimitive primitive, boolean hidden) {
        return new SubclassFilteredCollection(primitive.getReferrers(), IPrimitive::isMultipolygon).stream().anyMatch(r -> !FilterMatcher.isFiltered(r, hidden));
    }

    private static <T extends IPrimitive & IFilterablePrimitive> FilterType test(List<FilterInfo> filters, T primitive, boolean hidden) {
        if (primitive.isIncomplete() || primitive.isPreserved()) {
            return FilterType.NOT_FILTERED;
        }
        boolean filtered = false;
        boolean explicitlyFiltered = false;
        for (FilterInfo fi : filters) {
            if (fi.isDelete) {
                if (!filtered || !fi.match.match(primitive)) continue;
                filtered = false;
                continue;
            }
            if (filtered && (explicitlyFiltered || fi.isInverted) || !fi.match.match(primitive)) continue;
            filtered = true;
            if (fi.isInverted) continue;
            explicitlyFiltered = true;
        }
        if (primitive instanceof INode) {
            if (filtered) {
                if (explicitlyFiltered) {
                    return FilterType.PASSIV;
                }
                if (FilterMatcher.oneParentWayNotFiltered(primitive, hidden)) {
                    return FilterType.NOT_FILTERED;
                }
                return FilterType.PASSIV;
            }
            if (!primitive.isTagged() && FilterMatcher.allParentWaysFiltered(primitive, hidden)) {
                return FilterType.PASSIV;
            }
            return FilterType.NOT_FILTERED;
        }
        if (primitive instanceof IWay) {
            if (filtered) {
                if (explicitlyFiltered) {
                    return FilterType.EXPLICIT;
                }
                if (FilterMatcher.oneParentMultipolygonNotFiltered(primitive, hidden)) {
                    return FilterType.NOT_FILTERED;
                }
                return FilterType.PASSIV;
            }
            if (!primitive.isTagged() && FilterMatcher.allParentMultipolygonsFiltered(primitive, hidden)) {
                return FilterType.EXPLICIT;
            }
            return FilterType.NOT_FILTERED;
        }
        if (filtered) {
            return explicitlyFiltered ? FilterType.EXPLICIT : FilterType.PASSIV;
        }
        return FilterType.NOT_FILTERED;
    }

    public <T extends IPrimitive & IFilterablePrimitive> FilterType isHidden(T primitive) {
        return FilterMatcher.test(this.hiddenFilters, primitive, true);
    }

    public <T extends IPrimitive & IFilterablePrimitive> FilterType isDisabled(T primitive) {
        return FilterMatcher.test(this.disabledFilters, primitive, false);
    }

    public static FilterMatcher of(Filter ... filters) throws SearchParseError {
        FilterMatcher result = new FilterMatcher();
        for (Filter filter : filters) {
            result.add(filter);
        }
        return result;
    }

    private static class FilterInfo {
        private final SearchCompiler.Match match;
        private final boolean isDelete;
        private final boolean isInverted;

        FilterInfo(Filter filter) throws SearchParseError {
            this.isDelete = filter.mode == SearchMode.remove || filter.mode == SearchMode.in_selection;
            SearchCompiler.Match compiled = SearchCompiler.compile(filter);
            this.match = filter.inverted ? new SearchCompiler.Not(compiled) : compiled;
            this.isInverted = filter.inverted;
        }
    }

    public static enum FilterType {
        NOT_FILTERED,
        EXPLICIT,
        PASSIV;

    }
}

