/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.audio;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public final class AudioPreference
extends DefaultTabPreferenceSetting {
    private final JCheckBox audioMenuVisible = new JCheckBox(I18n.tr("Display the Audio menu.", new Object[0]));
    private final JCheckBox markerButtonLabels = new JCheckBox(I18n.tr("Label audio (and image and web) markers.", new Object[0]));
    private final JCheckBox markerAudioTraceVisible = new JCheckBox(I18n.tr("Display live audio trace.", new Object[0]));
    private final JCheckBox audioMarkersFromExplicitWaypoints = new JCheckBox(I18n.tr("Explicit waypoints with valid timestamps.", new Object[0]));
    private final JCheckBox audioMarkersFromUntimedWaypoints = new JCheckBox(I18n.tr("Explicit waypoints with time estimated from track position.", new Object[0]));
    private final JCheckBox audioMarkersFromNamedTrackpoints = new JCheckBox(I18n.tr("Named trackpoints.", new Object[0]));
    private final JCheckBox audioMarkersFromWavTimestamps = new JCheckBox(I18n.tr("Modified times (time stamps) of audio files.", new Object[0]));
    private final JCheckBox audioMarkersFromStart = new JCheckBox(I18n.tr("Start of track (will always do this if no other markers available).", new Object[0]));
    private final JosmTextField audioLeadIn = new JosmTextField(8);
    private final JosmTextField audioForwardBackAmount = new JosmTextField(8);
    private final JosmTextField audioFastForwardMultiplier = new JosmTextField(8);
    private final JosmTextField audioCalibration = new JosmTextField(8);

    private AudioPreference() {
        super("audio", I18n.tr("Audio", new Object[0]), I18n.tr("Settings for the audio player and audio markers.", new Object[0]));
    }

    @Override
    public void addGui(PreferenceTabbedPane gui) {
        VerticallyScrollablePanel audio = new VerticallyScrollablePanel(new GridBagLayout());
        this.audioMenuVisible.setSelected(!Config.getPref().getBoolean("audio.menuinvisible"));
        this.audioMenuVisible.setToolTipText(I18n.tr("Show or hide the audio menu entry on the main menu bar.", new Object[0]));
        audio.add((Component)this.audioMenuVisible, GBC.eol().insets(0, 0, 0, 0));
        this.markerAudioTraceVisible.setSelected(Config.getPref().getBoolean("marker.traceaudio", true));
        this.markerAudioTraceVisible.setToolTipText(I18n.tr("Display a moving icon representing the point on the synchronized track where the audio currently playing was recorded.", new Object[0]));
        audio.add((Component)this.markerAudioTraceVisible, GBC.eol().insets(0, 0, 0, 0));
        this.markerButtonLabels.setSelected(Config.getPref().getBoolean("marker.buttonlabels", true));
        this.markerButtonLabels.setToolTipText(I18n.tr("Put text labels against audio (and image and web) markers as well as their button icons.", new Object[0]));
        audio.add((Component)this.markerButtonLabels, GBC.eol().insets(0, 0, 0, 0));
        audio.add((Component)new JLabel(I18n.tr("When importing audio, make markers from...", new Object[0])), GBC.eol());
        this.audioMarkersFromExplicitWaypoints.setSelected(Config.getPref().getBoolean("marker.audiofromexplicitwaypoints", true));
        this.audioMarkersFromExplicitWaypoints.setToolTipText(I18n.tr("When importing audio, apply it to any waypoints in the GPX layer.", new Object[0]));
        audio.add((Component)this.audioMarkersFromExplicitWaypoints, GBC.eol().insets(10, 0, 0, 0));
        this.audioMarkersFromUntimedWaypoints.setSelected(Config.getPref().getBoolean("marker.audiofromuntimedwaypoints", true));
        this.audioMarkersFromUntimedWaypoints.setToolTipText(I18n.tr("When importing audio, apply it to any waypoints in the GPX layer.", new Object[0]));
        audio.add((Component)this.audioMarkersFromUntimedWaypoints, GBC.eol().insets(10, 0, 0, 0));
        this.audioMarkersFromNamedTrackpoints.setSelected(Config.getPref().getBoolean("marker.audiofromnamedtrackpoints", false));
        this.audioMarkersFromNamedTrackpoints.setToolTipText(I18n.tr("Automatically create audio markers from trackpoints (rather than explicit waypoints) with names or descriptions.", new Object[0]));
        audio.add((Component)this.audioMarkersFromNamedTrackpoints, GBC.eol().insets(10, 0, 0, 0));
        this.audioMarkersFromWavTimestamps.setSelected(Config.getPref().getBoolean("marker.audiofromwavtimestamps", false));
        this.audioMarkersFromWavTimestamps.setToolTipText(I18n.tr("Create audio markers at the position on the track corresponding to the modified time of each audio WAV file imported.", new Object[0]));
        audio.add((Component)this.audioMarkersFromWavTimestamps, GBC.eol().insets(10, 0, 0, 0));
        this.audioMarkersFromStart.setSelected(Config.getPref().getBoolean("marker.audiofromstart"));
        this.audioMarkersFromStart.setToolTipText(I18n.tr("Automatically create audio markers from trackpoints (rather than explicit waypoints) with names or descriptions.", new Object[0]));
        audio.add((Component)this.audioMarkersFromStart, GBC.eol().insets(10, 0, 0, 0));
        this.audioForwardBackAmount.setText(Config.getPref().get("audio.forwardbackamount", "10.0"));
        this.audioForwardBackAmount.setToolTipText(I18n.tr("The number of seconds to jump forward or back when the relevant button is pressed", new Object[0]));
        audio.add((Component)new JLabel(I18n.tr("Forward/back time (seconds)", new Object[0])), GBC.std());
        audio.add((Component)this.audioForwardBackAmount, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.audioFastForwardMultiplier.setText(Config.getPref().get("audio.fastfwdmultiplier", "1.3"));
        this.audioFastForwardMultiplier.setToolTipText(I18n.tr("The amount by which the speed is multiplied for fast forwarding", new Object[0]));
        audio.add((Component)new JLabel(I18n.tr("Fast forward multiplier", new Object[0])), GBC.std());
        audio.add((Component)this.audioFastForwardMultiplier, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.audioLeadIn.setText(Config.getPref().get("audio.leadin", "1.0"));
        this.audioLeadIn.setToolTipText(I18n.tr("Playback starts this number of seconds before (or after, if negative) the audio track position requested", new Object[0]));
        audio.add((Component)new JLabel(I18n.tr("Lead-in time (seconds)", new Object[0])), GBC.std());
        audio.add((Component)this.audioLeadIn, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.audioCalibration.setText(Config.getPref().get("audio.calibration", "1.0"));
        this.audioCalibration.setToolTipText(I18n.tr("The ratio of voice recorder elapsed time to true elapsed time", new Object[0]));
        audio.add((Component)new JLabel(I18n.tr("Voice recorder calibration", new Object[0])), GBC.std());
        audio.add((Component)this.audioCalibration, GBC.eol().fill(2).insets(5, 0, 0, 5));
        audio.add(Box.createVerticalGlue(), GBC.eol().fill(3));
        this.createPreferenceTabWithScrollPane(gui, audio);
    }

    @Override
    public boolean ok() {
        Config.getPref().putBoolean("audio.menuinvisible", !this.audioMenuVisible.isSelected());
        AudioPreference.saveBoolean("marker.traceaudio", this.markerAudioTraceVisible);
        AudioPreference.saveBoolean("marker.buttonlabels", this.markerButtonLabels);
        AudioPreference.saveBoolean("marker.audiofromexplicitwaypoints", this.audioMarkersFromExplicitWaypoints);
        AudioPreference.saveBoolean("marker.audiofromuntimedwaypoints", this.audioMarkersFromUntimedWaypoints);
        AudioPreference.saveBoolean("marker.audiofromnamedtrackpoints", this.audioMarkersFromNamedTrackpoints);
        AudioPreference.saveBoolean("marker.audiofromwavtimestamps", this.audioMarkersFromWavTimestamps);
        AudioPreference.saveBoolean("marker.audiofromstart", this.audioMarkersFromStart);
        AudioPreference.saveDouble("audio.forwardbackamount", this.audioForwardBackAmount);
        AudioPreference.saveDouble("audio.fastfwdmultiplier", this.audioFastForwardMultiplier);
        AudioPreference.saveDouble("audio.leadin", this.audioLeadIn);
        AudioPreference.saveDouble("audio.calibration", this.audioCalibration);
        return false;
    }

    @Override
    public String getHelpContext() {
        return HelpUtil.ht("/Preferences/Audio");
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new AudioPreference();
        }
    }
}

