/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.mappaint.BooleanStyleSettingGui;
import org.openstreetmap.josm.gui.mappaint.StyleSetting;
import org.openstreetmap.josm.gui.mappaint.StyleSettingGui;
import org.openstreetmap.josm.gui.mappaint.loader.MapPaintStyleLoader;
import org.openstreetmap.josm.gui.util.StayOpenCheckBoxMenuItemUI;
import org.openstreetmap.josm.tools.I18n;

public class StyleSettingGroupGui
implements StyleSettingGui {
    private final StyleSetting.StyleSettingGroup group;
    private final List<StyleSetting> settings;

    public StyleSettingGroupGui(StyleSetting.StyleSettingGroup group, List<StyleSetting> settings) {
        this.group = Objects.requireNonNull(group);
        this.settings = Objects.requireNonNull(settings);
    }

    @Override
    public void addMenuEntry(JMenu menu) {
        final JMenu submenu = new JMenu();
        submenu.setText(this.group.label);
        submenu.setIcon(this.group.icon);
        if (this.settings.isEmpty()) {
            submenu.setEnabled(false);
        } else if (this.settings.size() >= 2) {
            JMenuItem item = new JMenuItem(new AbstractAction(this, I18n.tr("Toggle all settings", new Object[0])){
                final /* synthetic */ StyleSettingGroupGui this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    List items = Arrays.stream(submenu.getMenuComponents()).filter(BooleanStyleSettingGui.BooleanStyleSettingCheckBoxMenuItem.class::isInstance).map(c -> (BooleanStyleSettingGui.BooleanStyleSettingCheckBoxMenuItem)c).collect(Collectors.toList());
                    boolean select = items.stream().anyMatch(cbi -> !cbi.isSelected());
                    items.stream().filter(cbi -> select != cbi.isSelected()).forEach(cbi -> cbi.doClickWithoutRepaint(0));
                    MainApplication.worker.submit(new MapPaintStyleLoader(Collections.singletonList(this.this$0.group.parentStyle)));
                }
            });
            item.setUI(new StayOpenCheckBoxMenuItemUI());
            submenu.add(item);
            submenu.addSeparator();
        }
        for (StyleSetting s : this.settings) {
            s.getStyleSettingGui().addMenuEntry(submenu);
        }
        menu.add(submenu);
    }
}

