/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.validator;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.data.preferences.sources.ExtendedSourceEntry;
import org.openstreetmap.josm.data.preferences.sources.SourceEntry;
import org.openstreetmap.josm.data.preferences.sources.SourceProvider;
import org.openstreetmap.josm.data.preferences.sources.SourceType;
import org.openstreetmap.josm.data.preferences.sources.ValidatorPrefHelper;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SourceEditor;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.map.MapPaintPreference;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorPreference;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;

public class ValidatorTagCheckerRulesPreference
implements SubPreferenceSetting {
    private static final List<SourceProvider> ruleSourceProviders = new ArrayList<SourceProvider>();
    private SourceEditor sources;

    public static final boolean registerSourceProvider(SourceProvider provider) {
        if (provider != null) {
            return ruleSourceProviders.add(provider);
        }
        return false;
    }

    @Override
    public void addGui(PreferenceTabbedPane gui) {
        ValidatorPreference valPref = gui.getValidatorPreference();
        this.sources = new TagCheckerRulesSourceEditor();
        valPref.addSubTab(this, I18n.tr("Tag checker rules", new Object[0]), this.sources, I18n.tr("Choose Tag checker rules to enable", new Object[0]));
        this.sources.deferLoading(valPref, (Component)this.sources);
    }

    @Override
    public boolean ok() {
        MapCSSTagChecker tagChecker;
        if (this.sources.finish() && (tagChecker = OsmValidator.getTest(MapCSSTagChecker.class)) != null) {
            OsmValidator.initializeTests(Collections.singleton(tagChecker));
        }
        return false;
    }

    @Override
    public boolean isExpert() {
        return false;
    }

    @Override
    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane gui) {
        return gui.getValidatorPreference();
    }

    static class TagCheckerRulesSourceEditor
    extends SourceEditor {
        TagCheckerRulesSourceEditor() {
            super(SourceType.TAGCHECKER_RULE, Config.getUrls().getJOSMWebsite() + "/rules", ruleSourceProviders, false);
        }

        @Override
        public Collection<? extends SourceEntry> getInitialSourcesList() {
            return ValidatorPrefHelper.INSTANCE.get();
        }

        @Override
        public boolean finish() {
            return ValidatorPrefHelper.INSTANCE.put(this.activeSourcesModel.getSources());
        }

        @Override
        public Collection<ExtendedSourceEntry> getDefault() {
            return ValidatorPrefHelper.INSTANCE.getDefault();
        }

        @Override
        public Collection<String> getInitialIconPathsList() {
            return null;
        }

        @Override
        public String getStr(SourceEditor.I18nString ident) {
            switch (ident) {
                case AVAILABLE_SOURCES: {
                    return I18n.tr("Available rules:", new Object[0]);
                }
                case ACTIVE_SOURCES: {
                    return I18n.tr("Active rules:", new Object[0]);
                }
                case NEW_SOURCE_ENTRY_TOOLTIP: {
                    return I18n.tr("Add a new rule by entering filename or URL", new Object[0]);
                }
                case NEW_SOURCE_ENTRY: {
                    return I18n.tr("New rule entry:", new Object[0]);
                }
                case REMOVE_SOURCE_TOOLTIP: {
                    return I18n.tr("Remove the selected rules from the list of active rules", new Object[0]);
                }
                case EDIT_SOURCE_TOOLTIP: {
                    return I18n.tr("Edit the filename or URL for the selected active rule", new Object[0]);
                }
                case ACTIVATE_TOOLTIP: {
                    return I18n.tr("Add the selected available rules to the list of active rules", new Object[0]);
                }
                case RELOAD_ALL_AVAILABLE: {
                    return I18n.marktr("Reloads the list of available rules from ''{0}''");
                }
                case LOADING_SOURCES_FROM: {
                    return I18n.marktr("Loading rule sources from ''{0}''");
                }
                case FAILED_TO_LOAD_SOURCES_FROM: {
                    return I18n.marktr("<html>Failed to load the list of rule sources from<br>''{0}''.<br><br>Details (untranslated):<br>{1}</html>");
                }
                case FAILED_TO_LOAD_SOURCES_FROM_HELP_TOPIC: {
                    return "/Preferences/Rules#FailedToLoadRuleSources";
                }
                case ILLEGAL_FORMAT_OF_ENTRY: {
                    return I18n.marktr("Warning: illegal format of entry in rule list ''{0}''. Got ''{1}''");
                }
            }
            throw new AssertionError();
        }

        @Override
        protected String getTitleForSourceEntry(SourceEntry entry) {
            String title = MapPaintPreference.getTitleFromSourceEntry(entry);
            return title != null ? title : super.getTitleForSourceEntry(entry);
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new ValidatorTagCheckerRulesPreference();
        }
    }
}

